/*
 * Decompiled with CFR 0.152.
 */
package eanative.android;

import android.app.Activity;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.RelativeLayout;
import android.widget.TextView;
import eanative.android.R;
import eanative.android.util.Logger;
import eanative.android.view.EAVastPlayerView;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.nexage.sourcekit.util.HttpTools;
import org.nexage.sourcekit.vast.VASTPlayer;
import org.nexage.sourcekit.vast.model.TRACKING_EVENTS_TYPE;
import org.nexage.sourcekit.vast.model.VASTModel;

public class VastTeaserActivity
extends Activity {
    private static String TAG = "VASTActivity";
    private static final long TOOLBAR_HIDE_DELAY = 3000L;
    private static final long QUARTILE_TIMER_INTERVAL = 250L;
    private static final long VIDEO_PROGRESS_TIMER_INTERVAL = 250L;
    private Timer mToolBarTimer;
    private Timer mTrackingEventTimer;
    private Handler durationHandler = new Handler();
    private LinkedList<Integer> mVideoProgressTracker = null;
    private final int mMaxProgressTrackingPoints = 20;
    private Handler mHandler;
    private VASTModel mVastModel = null;
    private HashMap<TRACKING_EVENTS_TYPE, List<String>> mTrackingEventMap;
    private RelativeLayout mOverlay;
    private RelativeLayout mButtonsView;
    private RelativeLayout mRootLayout;
    private TextView mInfoButton;
    private TextView mCountdown;
    private ImageButton mCloseButton;
    private boolean mIsVideoPaused = false;
    private boolean mIsPlayBackError = false;
    private boolean mIsProcessedImpressions = false;
    private boolean mIsCompleted = false;
    private boolean mIsToolbarVisible = true;
    private boolean mDoNotConsiderTouchUp = false;
    private int mCurrentVideoPosition;
    private int mQuartile = 0;
    private String elapsedTimeText;
    private VASTPlayer vastPlayer;
    private EAVastPlayerView vastPlayerView;
    private Runnable updateRemainingTime = new Runnable(){

        @Override
        public void run() {
            if (VastTeaserActivity.this.vastPlayerView != null) {
                int mediaDuration = VastTeaserActivity.this.vastPlayerView.getDuration();
                int mediaPosition = VastTeaserActivity.this.vastPlayerView.getCurrentPosition();
                int duration = mediaDuration / 1000 - mediaPosition / 1000;
                int minutes = duration / 60;
                int seconds = duration % 60;
                String countdownText = VastTeaserActivity.this.elapsedTimeText.replaceAll("\\{m\\}", String.valueOf(minutes)).replaceAll("\\{s\\}", String.valueOf(seconds));
                VastTeaserActivity.this.mCountdown.setText((CharSequence)countdownText);
                VastTeaserActivity.this.durationHandler.postDelayed((Runnable)this, 100L);
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        int currentOrientation = this.getResources().getConfiguration().orientation;
        Logger.debug("currentOrientation:" + currentOrientation, new Object[0]);
        if (currentOrientation != 2) {
            Logger.debug("Orientation is not landscape.....forcing landscape", new Object[0]);
            this.setRequestedOrientation(0);
        }
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        this.setContentView(R.layout.activity_vast_teaser);
        Intent i = this.getIntent();
        this.mVastModel = (VASTModel)i.getSerializableExtra("eanative.android.vast.player.vastModel");
        this.elapsedTimeText = this.getIntent().getStringExtra("eanative.android.placement.ett");
        if (this.mVastModel == null) {
            Logger.debug("vastModel is null. Stopping activity.", new Object[0]);
            this.finishVAST();
        } else {
            this.mHandler = new Handler();
            this.createUIComponents();
            this.hideSystemUI();
        }
    }

    protected void onStart() {
        Logger.debug("entered onStart --(life cycle event)", new Object[0]);
        super.onStart();
    }

    protected void onResume() {
        Logger.debug("entered on onResume --(life cycle event)", new Object[0]);
        super.onResume();
    }

    protected void onStop() {
        Logger.debug("entered on onStop --(life cycle event)", new Object[0]);
        super.onStop();
    }

    protected void onRestart() {
        Logger.debug("entered on onRestart --(life cycle event)", new Object[0]);
        super.onRestart();
    }

    protected void onPause() {
        Logger.debug("entered on onPause --(life cycle event)", new Object[0]);
        super.onPause();
        if (this.vastPlayerView != null) {
            this.mCurrentVideoPosition = this.vastPlayerView.getCurrentPosition();
            this.vastPlayerView.pause();
        }
    }

    protected void onDestroy() {
        Logger.debug("entered on onDestroy --(life cycle event)", new Object[0]);
        super.onDestroy();
    }

    public void onSaveInstanceState(Bundle savedInstanceState) {
        Logger.debug("entered onSaveInstanceState ", new Object[0]);
        super.onSaveInstanceState(savedInstanceState);
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        Logger.debug("in onRestoreInstanceState", new Object[0]);
        super.onRestoreInstanceState(savedInstanceState);
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        if (hasFocus) {
            this.hideSystemUI();
        }
    }

    private void hideSystemUI() {
        this.getWindow().getDecorView().setSystemUiVisibility(7942);
    }

    private void showSystemUI() {
        this.getWindow().getDecorView().setSystemUiVisibility(1792);
    }

    private void createUIComponents() {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        this.mRootLayout = (RelativeLayout)this.findViewById(R.id.mRootLayout);
        this.createOverlay();
        this.createMediaPlayer();
        this.createInfoButton();
        this.setContentView((View)this.mRootLayout);
        this.createCloseButton();
    }

    private void createMediaPlayer() {
        Logger.debug("show vast player view %s", this.mVastModel.toString());
        if (this.mVastModel != null) {
            this.vastPlayerView = new EAVastPlayerView(this.getApplicationContext(), this.mVastModel){

                @Override
                protected void onMediaStart() {
                    VastTeaserActivity.this.showToolBar();
                    VastTeaserActivity.this.durationHandler.postDelayed(VastTeaserActivity.this.updateRemainingTime, 100L);
                }
            };
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
            this.vastPlayerView.setLayoutParams((ViewGroup.LayoutParams)params);
            this.mOverlay.addView((View)this.vastPlayerView, 0);
        }
    }

    private void createCloseButton() {
        this.mCloseButton = (ImageButton)this.findViewById(R.id.mCloseButton);
        this.mCloseButton.setImageResource(R.drawable.arrow_back);
        this.mCloseButton.setVisibility(0);
        this.mCloseButton.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getActionMasked() == 1) {
                    VastTeaserActivity.this.closeClicked();
                }
                return true;
            }
        });
        this.mCloseButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VastTeaserActivity.this.closeClicked();
            }
        });
    }

    private void createOverlay() {
        this.mOverlay = (RelativeLayout)this.findViewById(R.id.mOverlay);
        this.mOverlay.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getActionMasked() == 0) {
                    VastTeaserActivity.this.mDoNotConsiderTouchUp = !VastTeaserActivity.this.mIsToolbarVisible;
                    if (!VastTeaserActivity.this.mIsToolbarVisible) {
                        VastTeaserActivity.this.showToolBar();
                    }
                } else if (!VastTeaserActivity.this.mDoNotConsiderTouchUp) {
                    VastTeaserActivity.this.hideToolBar();
                }
                return true;
            }
        });
        this.mButtonsView = (RelativeLayout)this.findViewById(R.id.mButtonsView);
    }

    private void createInfoButton() {
        String callToActionText = this.getIntent().getStringExtra("eanative.android.placement.cta");
        String clickThroughUrl = this.mVastModel.getVideoClicks().getClickThrough();
        this.mInfoButton = (TextView)this.findViewById(R.id.mInfoButton);
        this.mInfoButton.setText((CharSequence)callToActionText);
        if (clickThroughUrl != null && clickThroughUrl.length() > 0) {
            this.mInfoButton.setVisibility(0);
            this.mInfoButton.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    if (event.getActionMasked() == 1) {
                        VastTeaserActivity.this.infoClicked();
                    }
                    return true;
                }
            });
            this.mInfoButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    VastTeaserActivity.this.infoClicked();
                }
            });
        } else {
            this.mInfoButton.setVisibility(8);
        }
        this.mCountdown = (TextView)this.findViewById(R.id.mCountdown);
    }

    private void infoClicked() {
        Logger.debug("entered infoClicked:", new Object[0]);
        this.activateButtons(false);
        boolean isPlaying = this.vastPlayerView.isPlaying();
        if (isPlaying) {
            this.vastPlayerView.pause();
            this.mCurrentVideoPosition = this.vastPlayerView.getCurrentPosition();
        }
        this.processClickThroughEvent();
    }

    private void activateButtons(boolean active) {
        Logger.debug("entered activateButtons:", new Object[0]);
        this.mIsToolbarVisible = active;
        this.vastPlayerView.activateButtons(active);
        if (active) {
            this.mButtonsView.animate().alpha(1.0f);
        } else {
            this.mButtonsView.animate().alpha(0.0f);
        }
    }

    private void processClickThroughEvent() {
        Logger.debug("entered processClickThroughEvent:", new Object[0]);
        if (VASTPlayer.lastListener != null) {
            VASTPlayer.lastListener.vastClick();
        }
        String clickThroughUrl = this.mVastModel.getVideoClicks().getClickThrough();
        Logger.debug("clickThrough url: %s", clickThroughUrl);
        List<String> urls = this.mVastModel.getVideoClicks().getClickTracking();
        this.fireUrls(urls);
        try {
            Uri uri = Uri.parse((String)clickThroughUrl);
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            ResolveInfo resolvable = this.getPackageManager().resolveActivity(intent, 32);
            if (resolvable == null) {
                Logger.debug("Clickthrough error occured, uri unresolvable", new Object[0]);
                if ((double)this.mCurrentVideoPosition >= (double)this.vastPlayerView.getCurrentPosition() * 0.99) {
                    this.vastPlayerView.start();
                }
                this.activateButtons(true);
                return;
            }
            this.startActivity(intent);
        }
        catch (NullPointerException e) {
            Logger.debug(e.getMessage(), e);
        }
    }

    private void closeClicked() {
        Logger.debug("entered closeClicked()", new Object[0]);
        this.cleanActivityUp();
        if (!this.mIsPlayBackError) {
            // empty if block
        }
        this.finishVAST();
        Logger.debug("leaving closeClicked()", new Object[0]);
    }

    public void onBackPressed() {
        Logger.debug("entered onBackPressed", new Object[0]);
        this.closeClicked();
    }

    private void cleanActivityUp() {
        this.vastPlayerView.cleanPlayerUp();
        this.stopToolBarTimer();
        this.durationHandler.removeCallbacks(this.updateRemainingTime);
        this.mRootLayout.removeAllViews();
        this.vastPlayerView = null;
    }

    private void processErrorEvent() {
        Logger.debug("entered processErrorEvent", new Object[0]);
        List<String> errorUrls = this.mVastModel.getErrorUrl();
        this.fireUrls(errorUrls);
    }

    private void overlayClicked() {
        this.activateButtons(true);
        this.startToolBarTimer();
        Logger.debug("overlay clicked", new Object[0]);
    }

    private void fireUrls(List<String> urls) {
        Logger.debug("entered fireUrls", new Object[0]);
        if (urls != null) {
            for (String url : urls) {
                Logger.debug("\tfiring url:%s", url);
                HttpTools.httpGetURL(url);
            }
        } else {
            Logger.debug("\turl list is null", new Object[0]);
        }
    }

    private void showToolBar() {
        this.activateButtons(true);
        this.startToolBarTimer();
    }

    private void hideToolBar() {
        this.activateButtons(false);
    }

    private void startToolBarTimer() {
        Logger.debug("entered startToolBarTimer", new Object[0]);
        if (this.mQuartile == 4) {
            return;
        }
        if (this.mIsToolbarVisible && this.vastPlayerView != null && this.vastPlayerView.isPlaying()) {
            this.stopToolBarTimer();
            this.mToolBarTimer = new Timer();
            this.mToolBarTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    VastTeaserActivity.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            Logger.debug("hiding buttons", new Object[0]);
                            VastTeaserActivity.this.activateButtons(false);
                            VastTeaserActivity.this.mIsToolbarVisible = false;
                        }
                    });
                }
            }, 3000L);
        }
        if (this.mIsVideoPaused) {
            this.activateButtons(true);
        }
    }

    private void stopToolBarTimer() {
        Logger.debug("entered stopToolBarTimer", new Object[0]);
        if (this.mToolBarTimer != null) {
            this.mToolBarTimer.cancel();
            this.mToolBarTimer = null;
        }
    }

    private void finishVAST() {
        if (VASTPlayer.lastListener != null) {
            VASTPlayer.lastListener.vastDismiss();
        }
        this.finish();
    }
}

