package eanative.android.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.view.View;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;

import com.android.volley.toolbox.ImageLoader;
import com.android.volley.toolbox.VolleyImageView;

import eanative.android.R;
import eanative.android.ad.AdData;
import eanative.android.events.EANativeAdListener;
import eanative.android.events.EANativeEvent;
import eanative.android.events.EANativeEventListener;
import eanative.android.util.EAImageLoader;
import eanative.android.util.Logger;
import eanative.android.util.Utils;

/**
 * Created by beni on 02/03/16.
 */
public class EAImageGallery extends HorizontalScrollView {
    private final AdClickListener adClickListener;
    protected LinearLayout imagesContainer;
    private AdData adData;

    public EAImageGallery(Context context){
        super(context);
        imagesContainer = new LinearLayout(context);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(
                RelativeLayout.LayoutParams.WRAP_CONTENT,
                RelativeLayout.LayoutParams.MATCH_PARENT);

        int padding = (int) getResources().getDimension(R.dimen.media_images_distance);
        this.imagesContainer.setPadding(padding,0,0,0);
        this.imagesContainer.setLayoutParams(params);
        this.addView(imagesContainer);
        this.adClickListener = new AdClickListener();
        this.setHorizontalScrollBarEnabled(false);
    }
    public void setNativeAd(AdData ad, String tagName,ImageLoader imageLoader){
        this.adData = ad;
        String[] imagesHash = ad.getAdImageTag(tagName);

        this.imagesContainer.removeAllViews();
        for(int i=0;i<imagesHash.length;i++){
            VolleyImageView imageView = new VolleyImageView(this.getContext()){
                @Override
                public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
                    int height = MeasureSpec.getSize(heightMeasureSpec);
                    setMeasuredDimension(height, height);
                }

            };
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(
                    LinearLayout.LayoutParams.WRAP_CONTENT,
                    LinearLayout.LayoutParams.MATCH_PARENT);

            int margin = (int) getResources().getDimension(R.dimen.media_images_distance);
            params.setMargins(0,0,margin,0);
            imageView.setLayoutParams(params);

            this.imagesContainer.addView(imageView);
            imageView.setOnClickListener(this.adClickListener );

             EAImageLoader eaImageLoader = new EAImageLoader();

            eaImageLoader.setNativeAd(imageView,ad,tagName,imageLoader);
            eaImageLoader.registerEventListener(EANativeEvent.COMPLETE, new EANativeEventListener() {
                @Override
                public void handleMessage(String event, Object eaImageLoader) {
                    View imageView = ((EAImageLoader)eaImageLoader).getView();
                    Utils.fadeInView(imageView);
                }
            });
            eaImageLoader.loadImage(false,i);

        }
    }
    private final class AdClickListener implements View.OnClickListener {
        @TargetApi(Build.VERSION_CODES.ICE_CREAM_SANDWICH_MR1)
        public void onClick(View view) {
            EAImageGallery.this.callOnClick();
        }
    }
}
