/*
 * Decompiled with CFR 0.152.
 */
package org.nexage.sourcekit.vast.processor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import javax.xml.parsers.DocumentBuilderFactory;
import org.nexage.sourcekit.util.VASTLog;
import org.nexage.sourcekit.util.XmlTools;
import org.nexage.sourcekit.vast.model.VASTModel;
import org.nexage.sourcekit.vast.model.VAST_DOC_ELEMENTS;
import org.nexage.sourcekit.vast.processor.VASTMediaPicker;
import org.nexage.sourcekit.vast.processor.VASTModelPostValidator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class VASTProcessor {
    private static final String TAG = "VASTProcessor";
    private static final int MAX_VAST_LEVELS = 5;
    private VASTMediaPicker mediaPicker;
    private VASTModel vastModel;
    private StringBuilder mergedVastDocs = new StringBuilder(500);

    public VASTProcessor(VASTMediaPicker mediaPicker) {
        this.mediaPicker = mediaPicker;
    }

    public VASTModel getModel() {
        return this.vastModel;
    }

    public int process(String xmlData) {
        VASTLog.d(TAG, "process");
        this.vastModel = null;
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(xmlData.getBytes(Charset.defaultCharset().name()));
        }
        catch (UnsupportedEncodingException e) {
            VASTLog.e(TAG, e.getMessage(), e);
            return 3;
        }
        int error = this.processUri(is, 0);
        try {
            ((InputStream)is).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (error != 0) {
            return error;
        }
        Document mainDoc = this.wrapMergedVastDocWithVasts();
        this.vastModel = new VASTModel(mainDoc);
        if (mainDoc == null) {
            return 3;
        }
        if (!VASTModelPostValidator.validate(this.vastModel, this.mediaPicker)) {
            return 5;
        }
        return 0;
    }

    private Document wrapMergedVastDocWithVasts() {
        VASTLog.d(TAG, "wrapmergedVastDocWithVasts");
        this.mergedVastDocs.insert(0, "<VASTS>");
        this.mergedVastDocs.append("</VASTS>");
        String merged = this.mergedVastDocs.toString();
        VASTLog.v(TAG, "Merged VAST doc:\n" + merged);
        Document doc = XmlTools.stringToDocument(merged);
        return doc;
    }

    private int processUri(InputStream is, int depth) {
        VASTLog.d(TAG, "processUri");
        if (depth >= 5) {
            String message = "VAST wrapping exceeded max limit of 5.";
            VASTLog.e(TAG, message);
            return 6;
        }
        Document doc = this.createDoc(is);
        if (doc == null) {
            return 3;
        }
        this.merge(doc);
        NodeList uriToNextDoc = doc.getElementsByTagName(VAST_DOC_ELEMENTS.vastAdTagURI.getValue());
        if (uriToNextDoc == null || uriToNextDoc.getLength() == 0) {
            return 0;
        }
        VASTLog.d(TAG, "Doc is a wrapper. ");
        Node node = uriToNextDoc.item(0);
        String nextUri = XmlTools.getElementValue(node);
        VASTLog.d(TAG, "Wrapper URL: " + nextUri);
        InputStream nextInputStream = null;
        try {
            URL nextUrl = new URL(nextUri);
            nextInputStream = nextUrl.openStream();
        }
        catch (Exception e) {
            VASTLog.e(TAG, e.getMessage(), e);
            return 2;
        }
        int error = this.processUri(nextInputStream, depth + 1);
        try {
            nextInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return error;
    }

    private Document createDoc(InputStream is) {
        VASTLog.d(TAG, "About to create doc from InputStream");
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
            doc.getDocumentElement().normalize();
            VASTLog.d(TAG, "Doc successfully created.");
            return doc;
        }
        catch (Exception e) {
            VASTLog.e(TAG, e.getMessage(), e);
            return null;
        }
    }

    private void merge(Document newDoc) {
        VASTLog.d(TAG, "About to merge doc into main doc.");
        NodeList nl = newDoc.getElementsByTagName("VAST");
        Node newDocElement = nl.item(0);
        String doc = XmlTools.xmlDocumentToString(newDocElement);
        this.mergedVastDocs.append(doc);
        VASTLog.d(TAG, "Merge successful.");
    }
}

