/*
 * Decompiled with CFR 0.152.
 */
package eanative.android.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.android.volley.toolbox.ImageLoader;
import com.android.volley.toolbox.VolleyImageView;
import com.facebook.ads.MediaView;
import eanative.android.R;
import eanative.android.ad.AdData;
import eanative.android.util.EAImageLoader;
import eanative.android.util.Logger;
import eanative.android.view.EAImageGallery;
import eanative.android.view.EAVastPlayerView;
import org.nexage.sourcekit.vast.VASTPlayer;
import org.nexage.sourcekit.vast.model.VASTModel;

public class EAMediaView
extends RelativeLayout {
    private final AttributeSet attributes;
    private final AdClickListener adClickListener;
    protected MediaView fbMediaView;
    protected EAVastPlayerView vastPlayerView;
    protected VolleyImageView imageView;
    protected EAImageLoader eaImageLoader;
    private VASTPlayer vastPlayer;
    private EAImageGallery eaImageGallery;
    private boolean autoPlay = true;

    public EAMediaView(Context context) {
        this(context, null);
    }

    public EAMediaView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.attributes = attrs;
        this.adClickListener = new AdClickListener();
    }

    public void setNativeAd(AdData ad, ImageLoader imageLoader) {
        if (this.fbMediaView != null) {
            this.fbMediaView.setVisibility(8);
        }
        if (this.vastPlayerView != null) {
            this.vastPlayerView.setVisibility(8);
        }
        if (this.eaImageGallery != null) {
            this.eaImageGallery.setVisibility(8);
        }
        if (this.imageView != null) {
            this.imageView.setVisibility(8);
        }
        if (ad.getAdDSP().equals("facebook")) {
            if (this.fbMediaView == null) {
                this.fbMediaView = new MediaView(this.getContext(), this.attributes);
                this.addView((View)this.fbMediaView);
            }
            this.fbMediaView.setNativeAd(ad.nativeFBAd);
            ad.nativeFBAd.registerViewForInteraction((View)this.fbMediaView);
            this.fbMediaView.setVisibility(0);
        } else if (ad.isVideoTeaser()) {
            if (this.vastPlayerView != null) {
                this.vastPlayerView.cleanPlayerUp();
                this.removeView((View)this.vastPlayerView);
                this.vastPlayerView = null;
            }
            String videoUrl = ad.getAdTag("video_url");
            if (this.vastPlayer == null) {
                this.vastPlayer = new VASTPlayer(this.getContext(), new VASTPlayer.VASTPlayerListener(){

                    @Override
                    public void vastReady() {
                        Logger.debug("VAST Document is ready and we can play it now", new Object[0]);
                        EAMediaView.this.showVastPlayerView(EAMediaView.this.vastPlayer);
                    }

                    @Override
                    public void vastError(int error) {
                        String message = "Unable to play VAST Document: Error: " + error;
                        Logger.debug(message, new Object[0]);
                    }

                    @Override
                    public void vastClick() {
                        Logger.debug("VAST click event fired", new Object[0]);
                    }

                    @Override
                    public void vastComplete() {
                        Logger.debug("VAST complete event fired", new Object[0]);
                    }

                    @Override
                    public void vastDismiss() {
                        Logger.debug("VAST dismiss event fired", new Object[0]);
                    }
                });
            }
            this.vastPlayer.loadVideoWithUrl(videoUrl);
        } else {
            String[] squareImages = ad.getAdImageTag("image_square");
            if (squareImages != null && squareImages.length > 1) {
                if (this.eaImageGallery == null) {
                    this.eaImageGallery = new EAImageGallery(this.getContext());
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
                    this.eaImageGallery.setLayoutParams((ViewGroup.LayoutParams)params);
                    this.eaImageGallery.setOnClickListener(this.adClickListener);
                    this.addView((View)this.eaImageGallery);
                }
                this.eaImageGallery.setNativeAd(ad, "image_square", imageLoader);
                this.eaImageGallery.setVisibility(0);
            } else {
                if (this.imageView == null) {
                    this.imageView = new VolleyImageView(this.getContext());
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
                    this.imageView.setLayoutParams((ViewGroup.LayoutParams)params);
                    this.imageView.setOnClickListener(this.adClickListener);
                    this.addView((View)this.imageView);
                }
                if (this.eaImageLoader == null) {
                    this.eaImageLoader = new EAImageLoader();
                }
                this.eaImageLoader.setNativeAd((View)this.imageView, ad, "image_large_landscape", imageLoader);
                this.eaImageLoader.loadImage(false);
                this.imageView.setVisibility(0);
            }
        }
    }

    public void showVastPlayerView(final VASTPlayer vastPlayer) {
        VASTModel mVastModel = vastPlayer.getVastModel();
        Logger.debug("show vast player view %s", mVastModel.toString());
        if (mVastModel != null) {
            this.vastPlayerView = new EAVastPlayerView(this.getContext(), mVastModel){

                @Override
                protected void onMediaComplete() {
                    if (vastPlayer.listener != null) {
                        vastPlayer.listener.vastComplete();
                    }
                }
            };
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
            this.vastPlayerView.setLayoutParams((ViewGroup.LayoutParams)params);
            this.vastPlayerView.setAutoPlay(this.autoPlay);
            this.vastPlayerView.setVisibility(0);
            this.vastPlayerView.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.video_background_color));
            this.vastPlayerView.setOnClickListener(this.adClickListener);
            if (this.autoPlay) {
                this.vastPlayerView.activateButtons(false);
                this.vastPlayerView.setVolume(0);
            }
            Logger.debug("MEDIA VIEW DIMENSIONS  %s %s", this.getWidth(), this.getHeight());
            this.addView((View)this.vastPlayerView);
        }
    }

    public void clear() {
    }

    public boolean isAutoPlay() {
        return this.autoPlay;
    }

    public void setAutoPlay(boolean autoPlay) {
        this.autoPlay = autoPlay;
    }

    private final class AdClickListener
    implements View.OnClickListener {
        private AdClickListener() {
        }

        @TargetApi(value=15)
        public void onClick(View view) {
            if (EAMediaView.this.vastPlayerView != null) {
                EAMediaView.this.vastPlayerView.pause();
            }
            EAMediaView.this.callOnClick();
        }
    }
}

