/*
 * Decompiled with CFR 0.152.
 */
package eanative.android.util;

import android.content.res.Resources;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Pattern;

public class Utils {
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$");

    public static String bytesToHex(byte[] bytes) {
        StringBuilder sbuf = new StringBuilder();
        for (int idx = 0; idx < bytes.length; ++idx) {
            int intVal = bytes[idx] & 0xFF;
            if (intVal < 16) {
                sbuf.append("0");
            }
            sbuf.append(Integer.toHexString(intVal).toUpperCase());
        }
        return sbuf.toString();
    }

    public static byte[] getUTF8Bytes(String str) {
        try {
            return str.getBytes("UTF-8");
        }
        catch (Exception ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadFileAsString(String filename) throws IOException {
        int BUFLEN = 1024;
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(filename), 1024);
        try {
            int read;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            byte[] bytes = new byte[1024];
            boolean isUTF8 = false;
            int count = 0;
            while ((read = is.read(bytes)) != -1) {
                if (count == 0 && bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65) {
                    isUTF8 = true;
                    baos.write(bytes, 3, read - 3);
                } else {
                    baos.write(bytes, 0, read);
                }
                count += read;
            }
            String string2 = isUTF8 ? new String(baos.toByteArray(), "UTF-8") : new String(baos.toByteArray());
            return string2;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    public static String getIPAddress(boolean useIPv4) {
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface intf : interfaces) {
                ArrayList<InetAddress> addrs = Collections.list(intf.getInetAddresses());
                for (InetAddress addr : addrs) {
                    if (addr.isLoopbackAddress()) continue;
                    String sAddr = addr.getHostAddress().toUpperCase();
                    boolean isIPv4 = Utils.isIPv4Address(sAddr);
                    if (useIPv4) {
                        if (!isIPv4) continue;
                        return sAddr;
                    }
                    if (isIPv4) continue;
                    int delim = sAddr.indexOf(37);
                    return delim < 0 ? sAddr : sAddr.substring(0, delim);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static boolean isIPv4Address(String input) {
        return IPV4_PATTERN.matcher(input).matches();
    }

    public static int pxToDp(int px) {
        return (int)((float)px / Resources.getSystem().getDisplayMetrics().density);
    }

    public static int dpToPx(float dp) {
        return (int)(dp * Resources.getSystem().getDisplayMetrics().density);
    }

    public static Animation getAlphaAnimation(int startAlpha, int endAlpha) {
        AlphaAnimation a = new AlphaAnimation((float)startAlpha, (float)endAlpha);
        a.setDuration(1000L);
        a.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
            }
        });
        return a;
    }

    public static void fadeInView(View view) {
        Animation a = Utils.getAlphaAnimation(0, 1);
        view.startAnimation(a);
    }

    public static void fadeOutView(View view) {
        Animation a = Utils.getAlphaAnimation(1, 0);
        view.startAnimation(a);
    }
}

