/*
 * Decompiled with CFR 0.152.
 */
package eanative.android.util;

import android.util.Log;
import java.util.Locale;

public class Logger {
    static String TAG = "EANative";
    static final boolean DEBUG = Log.isLoggable((String)TAG, (int)2);

    public static void verbose(String format, Object ... args) {
        if (DEBUG) {
            Log.v((String)TAG, (String)Logger.buildMessage(format, args));
        }
    }

    public static void debug(String format, Object ... args) {
        if (DEBUG) {
            Log.d((String)TAG, (String)Logger.buildMessage(format, args));
        }
    }

    public static void info(String format, Object ... args) {
        Log.i((String)TAG, (String)Logger.buildMessage(format, args));
    }

    public static void warn(String format, Object ... args) {
        Log.w((String)TAG, (String)Logger.buildMessage(format, args));
    }

    public static void error(String format, Object ... args) {
        Log.e((String)TAG, (String)Logger.buildMessage(format, args));
    }

    public static void wtf(String format, Object ... args) {
        Log.wtf((String)TAG, (String)Logger.buildMessage(format, args));
    }

    public static void wtf(Throwable tr, String format, Object ... args) {
        Log.wtf((String)TAG, (String)Logger.buildMessage(format, args), (Throwable)tr);
    }

    private static String buildMessage(String format, Object ... args) {
        String msg = args == null ? format : String.format(Locale.US, format, args);
        StackTraceElement[] trace = new Throwable().fillInStackTrace().getStackTrace();
        String caller = "<unknown>";
        for (int i = 2; i < trace.length; ++i) {
            Class<?> clazz = trace[i].getClass();
            if (clazz.equals(Logger.class)) continue;
            String callingClass = trace[i].getClassName();
            callingClass = callingClass.substring(callingClass.lastIndexOf(46) + 1);
            callingClass = callingClass.substring(callingClass.lastIndexOf(36) + 1);
            caller = callingClass + "." + trace[i].getMethodName();
            break;
        }
        return String.format(Locale.US, "[%d] %s: %s", Thread.currentThread().getId(), caller, msg);
    }
}

