/*
 * Decompiled with CFR 0.152.
 */
package eanative.android.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Build;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import java.io.IOException;
import java.lang.ref.WeakReference;

public abstract class AndroidAdvertisingIDUtil {
    public abstract void onRetrievedID(String var1, boolean var2);

    public abstract void onFailedToRetrieveID();

    @SuppressLint(value={"NewApi"})
    public void getID(Context context) {
        AAIDTask aaidTask = new AAIDTask(this, context);
        if (Build.VERSION.SDK_INT > 10) {
            aaidTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        } else {
            aaidTask.execute(new Void[0]);
        }
    }

    private class AAIDTask
    extends AsyncTask<Void, Void, Pair<String, Boolean>> {
        WeakReference<AndroidAdvertisingIDUtil> aaidUtil;
        Context context;

        private AAIDTask(AndroidAdvertisingIDUtil aaidUtil, Context context) {
            this.aaidUtil = new WeakReference<AndroidAdvertisingIDUtil>(aaidUtil);
            this.context = context;
        }

        protected Pair<String, Boolean> doInBackground(Void ... params) {
            AdvertisingIdClient.Info adInfo = null;
            try {
                adInfo = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.context);
            }
            catch (IOException iOException) {
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
            catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
            }
            catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
                // empty catch block
            }
            if (adInfo == null) {
                return null;
            }
            return new Pair((Object)adInfo.getId(), (Object)adInfo.isLimitAdTrackingEnabled());
        }

        protected void onPostExecute(Pair<String, Boolean> aaidPair) {
            super.onPostExecute(aaidPair);
            AndroidAdvertisingIDUtil aaidUtil = (AndroidAdvertisingIDUtil)this.aaidUtil.get();
            if (aaidUtil != null) {
                if (aaidPair != null) {
                    aaidUtil.onRetrievedID((String)aaidPair.first, (Boolean)aaidPair.second);
                } else {
                    aaidUtil.onFailedToRetrieveID();
                }
            }
        }
    }
}

