/*
 * Decompiled with CFR 0.152.
 */
package eanative.android.events;

import eanative.android.events.EANativeEventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class EventDispatcher {
    private final Map<String, CopyOnWriteArrayList<EANativeEventListener>> mEventListeners = new HashMap<String, CopyOnWriteArrayList<EANativeEventListener>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEventListener(String event, EANativeEventListener listener) {
        Map<String, CopyOnWriteArrayList<EANativeEventListener>> map = this.mEventListeners;
        synchronized (map) {
            CopyOnWriteArrayList<EANativeEventListener> listeners = this.mEventListeners.get(event);
            if (listeners == null) {
                listeners = new CopyOnWriteArrayList();
            } else if (listeners.contains(listener)) {
                // empty if block
            }
            listeners.add(listener);
            this.mEventListeners.put(event, listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterEventListener(String event, EANativeEventListener listener) {
        Map<String, CopyOnWriteArrayList<EANativeEventListener>> map = this.mEventListeners;
        synchronized (map) {
            CopyOnWriteArrayList<EANativeEventListener> listeners = this.mEventListeners.get(event);
            if (listeners == null) {
                return;
            }
            listeners.remove(listener);
            if (listeners.size() == 0) {
                this.mEventListeners.remove(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dispatchEvent(String type, Object message) {
        try {
            CopyOnWriteArrayList<EANativeEventListener> listeners;
            Map<String, CopyOnWriteArrayList<EANativeEventListener>> map = this.mEventListeners;
            synchronized (map) {
                listeners = this.mEventListeners.get(type);
            }
            if (listeners == null) {
                return "";
            }
            for (EANativeEventListener listener : listeners) {
                listener.handleMessage(type, message);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }
}

