/*
 * Decompiled with CFR 0.152.
 */
package eanative.android;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import eanative.android.R;
import eanative.android.util.SystemUiHider;
import eanative.android.util.VideoEnabledWebChromeClient;
import eanative.android.util.VideoEnabledWebView;

public class EANativeActivity
extends Activity {
    private VideoEnabledWebView webView;
    private VideoEnabledWebChromeClient webChromeClient;
    private String contentURL;

    @SuppressLint(value={"SetJavaScriptEnabled"})
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_eanative);
        this.webView = (VideoEnabledWebView)this.findViewById(R.id.image_view);
        View nonVideoLayout = this.findViewById(R.id.nonVideoLayout);
        ViewGroup videoLayout = (ViewGroup)this.findViewById(R.id.videoLayout);
        final SystemUiHider mSystemUiHider = SystemUiHider.getInstance(this, (View)videoLayout, 6);
        mSystemUiHider.setup();
        this.webChromeClient = new VideoEnabledWebChromeClient(nonVideoLayout, videoLayout, (View)this.webView){

            public void onProgressChanged(WebView view, int progress) {
            }
        };
        this.webChromeClient.setOnToggledFullscreen(new VideoEnabledWebChromeClient.ToggledFullscreenCallback(){

            @Override
            @SuppressLint(value={"NewApi"})
            public void toggledFullscreen(boolean fullscreen) {
                if (fullscreen) {
                    WindowManager.LayoutParams attrs = EANativeActivity.this.getWindow().getAttributes();
                    attrs.flags |= 0x400;
                    attrs.flags |= 0x80;
                    EANativeActivity.this.getWindow().setAttributes(attrs);
                    if (Build.VERSION.SDK_INT >= 14) {
                        EANativeActivity.this.getWindow().getDecorView().setSystemUiVisibility(5894);
                    }
                    mSystemUiHider.hide();
                } else {
                    WindowManager.LayoutParams attrs = EANativeActivity.this.getWindow().getAttributes();
                    attrs.flags &= 0xFFFFFBFF;
                    attrs.flags &= 0xFFFFFF7F;
                    EANativeActivity.this.getWindow().setAttributes(attrs);
                    if (Build.VERSION.SDK_INT >= 14) {
                        EANativeActivity.this.getWindow().getDecorView().setSystemUiVisibility(0);
                    }
                    mSystemUiHider.show();
                }
            }
        });
        this.webView.setWebChromeClient(this.webChromeClient);
        this.webView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                view.loadUrl(url);
                return false;
            }
        });
        Bundle extras = this.getIntent().getExtras();
        this.contentURL = extras.getString("contentURL");
        this.webView.loadUrl(this.contentURL);
    }

    protected void onPause() {
        super.onPause();
        if (this.webView != null) {
            if (Build.VERSION.SDK_INT < 18) {
                this.webView.clearView();
            } else {
                this.webView.loadUrl("about:blank");
            }
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.webView != null) {
            this.webView.loadUrl(this.contentURL);
        }
    }
}

