package eanative.android.util;

import android.net.Uri;
import android.os.Handler;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.ImageView;

import com.android.volley.toolbox.ImageLoader;
import com.android.volley.toolbox.VolleyImageView;

import eanative.android.ad.AdData;
import eanative.android.events.EANativeEvent;
import eanative.android.events.EventDispatcher;

/**
 * Created by beni on 01/03/16.
 */
public class EAImageLoader extends EventDispatcher {
    private AdData adData;
    private String tagName;
    private View view;
    private ImageLoader imageLoader;
    private  Handler requestHandler;
    public EAImageLoader(){


    }
    public void setNativeAd(View view, AdData ad, String tagName, ImageLoader imageLoader) {
        this.view = view;
        this.adData = ad;
        this.tagName = tagName;
        this.imageLoader = imageLoader;
    }

    public void loadImage(Boolean doResize) {
        this.loadImage(doResize,0);
    }
    public void loadImage(final Boolean doResize, final int imagePosition) {
        Logger.debug("LOAD IMAGE %s, %s",doResize, this.view.isShown());
        if(this.view.isShown()){
            this.requestImage(doResize,imagePosition);
        }else {
            final ViewTreeObserver obs = this.view.getViewTreeObserver();
            final ViewTreeObserver.OnPreDrawListener onPreDrawListener = new ViewTreeObserver.OnPreDrawListener() {
                @Override
                public boolean onPreDraw() {
                    view.getViewTreeObserver().removeOnPreDrawListener(this);
                    requestImage(doResize, imagePosition);
                    return true;
                }
            };
            obs.addOnPreDrawListener(onPreDrawListener);
        }
    }
    protected void requestImage(final Boolean doResize, final int imagePosition){
        String imageURL = this.adData.getAdImage(this.tagName,
                this.view.getMeasuredWidth(),
                this.view.getMeasuredHeight(),  doResize,imagePosition);
        Logger.debug("REQUEST IMAGE %s, %s",imageURL,  imagePosition);
        VolleyImageView.ResponseObserver listener;
        listener = new VolleyImageView.ResponseObserver() {
            @Override
            public void onError() {
                if(doResize == false) {
                    if (EAImageLoader.this.requestHandler == null) {
                        EAImageLoader.this.requestHandler = new Handler();
                    }
                    EAImageLoader.this.requestHandler.post(new Runnable() {
                        @Override
                        public void run() {
                            EAImageLoader.this.requestImage(true, imagePosition);
                        }
                    });
                }
            }

            @Override
            public void onSuccess() {
                EAImageLoader.this.dispatchEvent(EANativeEvent.COMPLETE,EAImageLoader.this);
            }
        };

        if (this.view instanceof VolleyImageView) {
            ((VolleyImageView) this.view)
                    .setResponseObserver(listener);
            ((VolleyImageView) this.view).setImageUrl(imageURL,
                    this.imageLoader);


        } else if(this.view instanceof ImageView) {
            Logger.warn("You have to use  VolleyImageView for view: %s",
                    this.tagName);
            ((ImageView) this.view).setImageURI(Uri.parse(imageURL));
        }
    }
    public void clear(){
        if(this.requestHandler !=null){
            this.requestHandler.removeMessages(0);
        }
    }
    public View getView(){
        return this.view;
    }
}
