package eanative.android.model;

import java.util.Map;

public class EANativePlacementConfig {

	/**
	 * placement id given from native CMS console
	 */
	public String placementId = "";
	/**
	 * layout resource id
	 */
	public int layoutResourceId ;

	/**
	 * ad start position in a view list
	 */
	public int startAdPosition = 2;
	/**
	 * ad frequency in a view list
	 */
	public int adFrequency = 5;
	
	public String environment = "live";
	/**
	 * if you want to test with specific ad, you can set the ad-hash with this param
	 */
	public String testHash = "";
	/**
	 * specify if video teaser is enabled on this placement
	 */
	public boolean enableVastTeaser = true;
	/**
	 * additional query-string params
	 */
	public Map<String, String> queryStringParams;

	public VastTeaserConfig vastTeaserConfig = new VastTeaserConfig();

	/**
	 * specify the scale mode for the main image
	 */
	public ImagesScaleMode imagesScaleMode = new ImagesScaleMode();
	public EANativePlacementConfig(){
		
	}	
	public EANativePlacementConfig(String placementId){
		this.placementId = placementId;
	}	
	
	public class ImagesScaleMode{
		
		public final static String SCALE_CROP = "scalecrop";
		public final static String SCALE = "scale";
		public final static String SCALE_HEIGHT = "scaleh";
		
		public String image_portrait = SCALE_CROP;
		public String image_landscape= SCALE_CROP;
		public String image_large_landscape= SCALE_CROP;
		public String image_square= SCALE_CROP;
		public String brand_logo= SCALE_HEIGHT;
		
		public String getScaleMode(String imageName){
			try {
					return this.getClass().getField(imageName).get(this).toString();
			}catch(NoSuchFieldException e){
				return SCALE_CROP;
			}catch(IllegalAccessException e){
				return SCALE_CROP;
			}
		}
	}

	public class VastTeaserConfig {
		public String callToActionText = "Visit {brand_name}";
		public String elapsedTimeText = "Ad {m}:{s}";
	}
}
