package eanative.android;

import android.app.Activity;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Configuration;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Handler;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageButton;
import android.widget.RelativeLayout;
import android.widget.TextView;


import org.nexage.sourcekit.util.HttpTools;
import org.nexage.sourcekit.vast.VASTPlayer;
import org.nexage.sourcekit.vast.model.TRACKING_EVENTS_TYPE;
import org.nexage.sourcekit.vast.model.VASTModel;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;


import eanative.android.util.Logger;
import eanative.android.view.EAMediaView;
import eanative.android.view.EAVastPlayerView;

import static android.view.View.GONE;
import static android.view.View.VISIBLE;

public class VastTeaserActivity extends Activity{

    private static String TAG = "VASTActivity";

    // timer delays
    private static final long TOOLBAR_HIDE_DELAY = 3000;
    private static final long QUARTILE_TIMER_INTERVAL = 250;
    private static final long VIDEO_PROGRESS_TIMER_INTERVAL = 250;


    // timers
    private Timer mToolBarTimer;
    private Timer mTrackingEventTimer;
    private Handler durationHandler = new Handler();

    private LinkedList<Integer> mVideoProgressTracker = null;
    private final int mMaxProgressTrackingPoints = 20;

    private Handler mHandler;

    private VASTModel mVastModel = null;
    private HashMap<TRACKING_EVENTS_TYPE, List<String>> mTrackingEventMap;

    private RelativeLayout mOverlay;
    private RelativeLayout mButtonsView;
    private RelativeLayout mRootLayout;

    private TextView mInfoButton;
    private TextView mCountdown;
    private ImageButton mCloseButton;

    private boolean mIsVideoPaused = false;
    private boolean mIsPlayBackError = false;
    private boolean mIsProcessedImpressions = false;
    private boolean mIsCompleted = false;
    private boolean mIsToolbarVisible = true;
    private boolean mDoNotConsiderTouchUp = false;

    private int mCurrentVideoPosition;
    private int mQuartile = 0;

    private String elapsedTimeText;
    private VASTPlayer vastPlayer;
    private EAVastPlayerView vastPlayerView;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        int currentOrientation = this.getResources().getConfiguration().orientation;
        Logger.debug("currentOrientation:" + currentOrientation);

        if (currentOrientation != Configuration.ORIENTATION_LANDSCAPE) {
            Logger.debug(
                    "Orientation is not landscape.....forcing landscape");
            setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);

        }
        // hide title bar of application
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        // hide status bar of Android
        getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN,
                WindowManager.LayoutParams.FLAG_FULLSCREEN);

        setContentView(R.layout.activity_vast_teaser);

        Intent i = getIntent();
        mVastModel = (VASTModel) i
                .getSerializableExtra("eanative.android.vast.player.vastModel");

        elapsedTimeText = getIntent().getStringExtra("eanative.android.placement.ett");

        if (mVastModel == null) {
            Logger.debug("vastModel is null. Stopping activity.");
            finishVAST();
        } else {

            mHandler = new Handler();

            createUIComponents();

            hideSystemUI();
        }


    }

    @Override
    protected void onStart() {
        Logger.debug("entered onStart --(life cycle event)");
        super.onStart();

    }

    @Override
    protected void onResume() {
        Logger.debug("entered on onResume --(life cycle event)");
        super.onResume();

    }

    @Override
    protected void onStop() {
        Logger.debug("entered on onStop --(life cycle event)");
        super.onStop();
        //cleanActivityUp();
        //finishVAST();
    }

    @Override
    protected void onRestart() {
        Logger.debug("entered on onRestart --(life cycle event)");
        super.onRestart();

    }

    @Override
    protected void onPause() {
        Logger.debug("entered on onPause --(life cycle event)");
        super.onPause();

        if (vastPlayerView != null) {
            mCurrentVideoPosition = vastPlayerView.getCurrentPosition();
            this.vastPlayerView.pause();
        }

    }

    @Override
    protected void onDestroy() {
        Logger.debug("entered on onDestroy --(life cycle event)");
        super.onDestroy();

    }

    @Override
    public void onSaveInstanceState(Bundle savedInstanceState) {

        Logger.debug("entered onSaveInstanceState ");
        super.onSaveInstanceState(savedInstanceState);
    }

    @Override
    public void onRestoreInstanceState(Bundle savedInstanceState) {
        Logger.debug("in onRestoreInstanceState");
        super.onRestoreInstanceState(savedInstanceState);

    }
    public void onWindowFocusChanged(boolean hasFocus) {

        super.onWindowFocusChanged(hasFocus);

        if(hasFocus) {
            hideSystemUI();
        }
    }
    // This snippet hides the system bars.
    private void hideSystemUI() {
        // Set the IMMERSIVE flag.
        // Set the content to appear under the system bars so that the content
        // doesn't resize when the system bars hide and show.
        getWindow().getDecorView().setSystemUiVisibility(
                View.SYSTEM_UI_FLAG_LAYOUT_STABLE
                        | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION
                        | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
                        | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION // hide nav bar
                        | View.SYSTEM_UI_FLAG_FULLSCREEN // hide status bar
                        | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY// hide status bar
                        | View.SYSTEM_UI_FLAG_IMMERSIVE);
    }

    // This snippet shows the system bars. It does this by removing all the flags
// except for the ones that make the content appear under the system bars.
    private void showSystemUI() {
        getWindow().getDecorView().setSystemUiVisibility(
                View.SYSTEM_UI_FLAG_LAYOUT_STABLE
                        | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION
                        | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN);
    }
    private void createUIComponents() {

        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(
                RelativeLayout.LayoutParams.MATCH_PARENT,
                RelativeLayout.LayoutParams.MATCH_PARENT);

        this.mRootLayout = (RelativeLayout) findViewById(R.id.mRootLayout);

        this.createOverlay();
        this.createMediaPlayer();
        this.createInfoButton();
        this.setContentView(mRootLayout);
        this.createCloseButton();

    }



    private void createMediaPlayer() {

        Logger.debug("show vast player view %s",mVastModel.toString());
        if (mVastModel != null) {
            vastPlayerView = new EAVastPlayerView(getApplicationContext(),mVastModel){
                @Override
                protected void onMediaStart(){
                    showToolBar();
                    durationHandler.postDelayed(updateRemainingTime, 100);
                }
            };
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(
                    RelativeLayout.LayoutParams.MATCH_PARENT,
                    RelativeLayout.LayoutParams.MATCH_PARENT);
            vastPlayerView.setLayoutParams(params);
            this.mOverlay.addView(this.vastPlayerView,0);
        }

    }
    private void createCloseButton() {

        mCloseButton = (ImageButton) findViewById(R.id.mCloseButton);
        mCloseButton.setImageResource(R.drawable.arrow_back);
        mCloseButton.setVisibility(VISIBLE);
        mCloseButton.setOnTouchListener(new View.OnTouchListener() {
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                if (event.getActionMasked() == MotionEvent.ACTION_UP){
                    closeClicked();
                }
                return true;
            }
        });
        mCloseButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                closeClicked();
            }
        });
    }

    private void createOverlay() {

        mOverlay = (RelativeLayout) findViewById(R.id.mOverlay);
        mOverlay.setOnTouchListener(new View.OnTouchListener() {
            @Override
            public boolean onTouch(View v, MotionEvent event) {

                if (event.getActionMasked() == MotionEvent.ACTION_DOWN){
                    mDoNotConsiderTouchUp = !mIsToolbarVisible;
                    if(!mIsToolbarVisible){
                        showToolBar();
                    }
                }else{
                    if(!mDoNotConsiderTouchUp) {
                        hideToolBar();
                    }
                }
                return true;
            }
        });
        mButtonsView = (RelativeLayout) findViewById(R.id.mButtonsView);
    }

    private void createInfoButton() {

        String callToActionText = getIntent().getStringExtra("eanative.android.placement.cta");

        String clickThroughUrl = mVastModel.getVideoClicks().getClickThrough();

        mInfoButton = (TextView) findViewById(R.id.mInfoButton);
        mInfoButton.setText(callToActionText);
        if (clickThroughUrl != null && clickThroughUrl.length() > 0) {

            mInfoButton.setVisibility(VISIBLE);
            mInfoButton.setOnTouchListener(new View.OnTouchListener() {
                @Override
                public boolean onTouch(View v, MotionEvent event) {
                    if (event.getActionMasked() == MotionEvent.ACTION_UP){
                        infoClicked();
                    }
                    return true;
                }
            });
            mInfoButton.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    infoClicked();
                }
            });


        }else{
            mInfoButton.setVisibility(GONE);
        }

        mCountdown = (TextView) findViewById(R.id.mCountdown);
    }


    private void infoClicked() {
        Logger.debug("entered infoClicked:");

        activateButtons(false);

        boolean isPlaying = this.vastPlayerView.isPlaying();

        if (isPlaying) {
            vastPlayerView.pause();
            mCurrentVideoPosition = vastPlayerView.getCurrentPosition();
        }

        processClickThroughEvent();

    }

    private void activateButtons(boolean active) {
        Logger.debug("entered activateButtons:");

        mIsToolbarVisible = active;
        this.vastPlayerView.activateButtons(active);

        if (active) {
            mButtonsView.animate().alpha(1.0f);
        } else {
            mButtonsView.animate().alpha(0.0f);
        }
    }
    private void processClickThroughEvent() {
        Logger.debug("entered processClickThroughEvent:");

        if(VASTPlayer.lastListener!=null) {
            VASTPlayer.lastListener.vastClick();
        }

        String clickThroughUrl = mVastModel.getVideoClicks().getClickThrough();
        Logger.debug("clickThrough url: %s" , clickThroughUrl);


        // Before we send the app to the click through url, we will process ClickTracking URL's.
        List<String> urls = mVastModel.getVideoClicks().getClickTracking();
        fireUrls(urls);

        // Navigate to the click through url
        try {
            Uri uri = Uri.parse(clickThroughUrl);
            Intent intent = new Intent(Intent.ACTION_VIEW, uri);
            ResolveInfo resolvable = getPackageManager().resolveActivity(intent, PackageManager.GET_INTENT_FILTERS);
            if(resolvable == null) {
                Logger.debug( "Clickthrough error occured, uri unresolvable");
                if (mCurrentVideoPosition>=vastPlayerView.getCurrentPosition()*0.99) {
                    vastPlayerView.start();
                }
                activateButtons(true);
                return;
            } else {
                startActivity(intent);
            }
        } catch (NullPointerException e) {
            Logger.debug( e.getMessage(), e);
        }
    }
    private void closeClicked() {

        Logger.debug("entered closeClicked()");
        cleanActivityUp();

        if (!mIsPlayBackError) {
            //this.processEvent(TRACKING_EVENTS_TYPE.close);
        }

        finishVAST();

        Logger.debug("leaving closeClicked()");
    }
    @Override
    public void onBackPressed() {
        Logger.debug("entered onBackPressed");
        this.closeClicked();

    }
    private void cleanActivityUp() {

        this.vastPlayerView.cleanPlayerUp();

        this.stopToolBarTimer();
        this.durationHandler.removeCallbacks(this.updateRemainingTime);
        this.mRootLayout.removeAllViews();
        this.vastPlayerView = null;
    }

    private void processErrorEvent() {
        Logger.debug("entered processErrorEvent");

        List<String> errorUrls = mVastModel.getErrorUrl();
        fireUrls(errorUrls);

    }

    private void overlayClicked() {
        this.activateButtons(true);
        this.startToolBarTimer();
        Logger.debug("overlay clicked");
    }

    private void fireUrls(List<String> urls) {
        Logger.debug("entered fireUrls");

        if (urls != null) {

            for (String url : urls) {
                Logger.debug("\tfiring url:%s", url);
                HttpTools.httpGetURL(url);
            }

        }else {
            Logger.debug("\turl list is null");
        }



    }
    private void showToolBar(){
        this.activateButtons(true);
        this.startToolBarTimer();

    }
    private void hideToolBar(){
        activateButtons(false);
    }
    // Timers
    private void startToolBarTimer() {
        Logger.debug("entered startToolBarTimer");
        if(mQuartile==4) {
            // we are at the end of the video, we dont want ot ever hide the toolbar now
            return;
        }

        if (mIsToolbarVisible && vastPlayerView!= null && vastPlayerView.isPlaying()) {
            stopToolBarTimer();
            mToolBarTimer = new Timer();
            mToolBarTimer.schedule(new TimerTask() {
                @Override
                public void run() {
                    mHandler.post(new Runnable() {
                        public void run() {
                            Logger.debug("hiding buttons");
                            activateButtons(false);
                            mIsToolbarVisible = false;
                        }
                    });
                }
            }, TOOLBAR_HIDE_DELAY);
        }

        if (mIsVideoPaused) {
            activateButtons(true);
        }
    }

    private void stopToolBarTimer() {
        Logger.debug("entered stopToolBarTimer");
        if (mToolBarTimer != null) {
            mToolBarTimer.cancel();
            mToolBarTimer = null;
        }
    }

    private void finishVAST() {
        if(VASTPlayer.lastListener!=null) {
            VASTPlayer.lastListener.vastDismiss();
        }
        finish();
    }
    //handler to change seekBarTime
    private Runnable updateRemainingTime = new Runnable() {
        public void run() {
            if(vastPlayerView!=null) {
                int mediaDuration = vastPlayerView.getDuration();
                int mediaPosition = vastPlayerView.getCurrentPosition();

                int duration = (mediaDuration/1000 - mediaPosition/1000);
                int minutes = duration/60;
                int seconds = duration % 60;

                String countdownText = elapsedTimeText.replaceAll("\\{m\\}",String.valueOf(minutes))
                        .replaceAll("\\{s\\}", String.valueOf(seconds));
                mCountdown.setText(countdownText);

                //repeat yourself that again in 100 miliseconds
                durationHandler.postDelayed(this, 100);
            }
        }
    };

}
