/*
 * Decompiled with CFR 0.152.
 */
package eanative.android.ad;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.android.volley.VolleySingleton;
import com.android.volley.toolbox.ImageLoader;
import eanative.android.ad.AdData;
import eanative.android.events.EANativeAdListener;
import eanative.android.events.EANativeEvent;
import eanative.android.events.EANativeEventListener;
import eanative.android.events.EventDispatcher;
import eanative.android.util.EAImageLoader;
import eanative.android.util.Logger;
import eanative.android.view.EAMediaView;
import java.util.ArrayList;

public class EANativeAdViewBinder {
    private final Context context;
    private final int layoutId;

    public EANativeAdViewBinder(Context context, int layoutId) {
        this.context = context;
        this.layoutId = layoutId;
    }

    public View createView(View convertView, ViewGroup parent, final EANativeAdListener clickListener) {
        View view = convertView;
        if (view == null || !(view.getTag() instanceof AdViewHolder)) {
            view = LayoutInflater.from((Context)this.context).inflate(this.layoutId, parent, false);
            AdViewHolder holder = new AdViewHolder(view, this.context);
            holder.registerEventListener(EANativeEvent.AD_CLICKED, new EANativeEventListener(){

                @Override
                public void handleMessage(String event, Object message) {
                    clickListener.adClicked(message);
                }
            });
            holder.registerEventListener(EANativeEvent.BRAND_CLICKED, new EANativeEventListener(){

                @Override
                public void handleMessage(String event, Object message) {
                    clickListener.brandClicked(message);
                }
            });
            view.setOnClickListener(null);
            view.setTag((Object)holder);
        }
        return view;
    }

    public void clear(View view) {
        AdViewHolder holder = (AdViewHolder)view.getTag();
        if (holder != null) {
            holder.clear();
        }
    }

    public void bindAdData(View view, AdData adData, boolean isVideoTeaser) {
        Object tag = view.getTag();
        AdViewHolder holder = (AdViewHolder)tag;
        holder.setData(adData);
        holder.displayAsVideoTeaser(isVideoTeaser);
        adData.registerViewForInteraction(view);
    }

    static class MediaViewBinder
    implements BaseBinder {
        private final View mediaView;
        private final ImageLoader imageLoader;
        private String tagName;
        private int targetId;
        private EAImageLoader eaImageLoader;

        MediaViewBinder(View mediaView, String tagName, ImageLoader imageLoader) {
            this.mediaView = mediaView;
            this.imageLoader = imageLoader;
            this.tagName = tagName;
        }

        MediaViewBinder bindTo(int targetId) {
            this.targetId = targetId;
            return this;
        }

        @Override
        public void setData(AdData adData) {
            if (this.mediaView == null) {
                return;
            }
            String tagValue = adData.getAdTag(this.tagName);
            if (this.mediaView instanceof EAMediaView) {
                ((EAMediaView)this.mediaView).setNativeAd(adData, this.imageLoader);
            } else {
                if (this.eaImageLoader == null) {
                    this.eaImageLoader = new EAImageLoader();
                }
                this.eaImageLoader.setNativeAd(this.mediaView, adData, this.tagName, this.imageLoader);
                this.eaImageLoader.loadImage(false);
            }
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public void clear() {
            if (this.mediaView instanceof EAMediaView) {
                ((EAMediaView)this.mediaView).clear();
            } else if (this.eaImageLoader != null) {
                this.eaImageLoader.clear();
            }
        }
    }

    static class TextBinder
    implements BaseBinder {
        private final TextView textView;
        private String tagName;
        private int targetId;

        TextBinder(TextView textView, String tagName) {
            this.textView = textView;
            this.tagName = tagName;
        }

        TextBinder bindTo(int targetId) {
            this.targetId = targetId;
            return this;
        }

        @Override
        public void setData(AdData adData) {
            if (this.textView == null) {
                return;
            }
            String tagValue = adData.getAdTag(this.tagName);
            this.textView.setVisibility(tagValue.isEmpty() ? 8 : 0);
            this.textView.setText((CharSequence)tagValue);
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public void clear() {
        }
    }

    static interface BaseBinder {
        public void setData(AdData var1);

        public int getType();

        public void clear();
    }

    static class AdViewHolder
    extends EventDispatcher {
        private final ArrayList<BaseBinder> binders;
        private final Context context;
        private ImageLoader imageLoader;
        private AdClickListener adClickListener;
        private BrandClickListener brandClickListener;
        private View rootView;
        private AdData adData;

        AdViewHolder(View rootView, Context context) {
            this.context = context;
            this.rootView = rootView;
            this.adClickListener = new AdClickListener();
            this.brandClickListener = new BrandClickListener();
            this.binders = new ArrayList();
            this.imageLoader = VolleySingleton.getInstance(this.context).getImageLoader();
            ViewGroup adContainer = (ViewGroup)rootView;
            if (adContainer != null) {
                ArrayList<View> views = AdViewHolder.getAllViewsByTag(adContainer, "eanative_tag");
                for (int i = 0; i < views.size(); ++i) {
                    View tagView = views.get(i);
                    String tagName = (String)tagView.getTag();
                    tagName = tagName.substring(13);
                    BaseBinder binder = null;
                    if (tagView instanceof TextView) {
                        binder = this.createTextBinder((TextView)tagView, tagView.getId(), tagName);
                    } else if (tagView instanceof ImageView || tagView instanceof EAMediaView) {
                        binder = this.createMediaBinder(tagView, tagView.getId(), tagName, this.imageLoader);
                    }
                    if (binder != null) {
                        this.binders.add(binder);
                    }
                    Logger.debug(" tag view is clickable %s %s", tagName, tagView.isClickable());
                    if (!tagView.isClickable()) continue;
                    if (tagName.equals("brand_name") || tagName.equals("brand_logo")) {
                        tagView.setOnClickListener((View.OnClickListener)this.brandClickListener);
                        continue;
                    }
                    tagView.setOnClickListener((View.OnClickListener)this.adClickListener);
                }
            }
        }

        public static ArrayList<View> getAllViewsByTag(ViewGroup root, String tag) {
            ArrayList<View> views = new ArrayList<View>();
            int childCount = root.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                String tagObj;
                View child = root.getChildAt(i);
                if (child instanceof ViewGroup) {
                    views.addAll(AdViewHolder.getAllViewsByTag((ViewGroup)child, tag));
                }
                if ((tagObj = (String)child.getTag()) == null || tagObj.indexOf(tag) == -1) continue;
                views.add(child);
            }
            return views;
        }

        private MediaViewBinder createMediaBinder(View mediaView, int id, String tagName, ImageLoader imageLoader) {
            MediaViewBinder binder = new MediaViewBinder(mediaView, tagName, imageLoader);
            return binder.bindTo(id);
        }

        private TextBinder createTextBinder(TextView textView, int id, String tagName) {
            TextBinder binder = new TextBinder(textView, tagName);
            return binder.bindTo(id);
        }

        public void clear() {
            if (this.binders != null) {
                for (BaseBinder binder : this.binders) {
                    binder.clear();
                }
            }
        }

        public void displayAsVideoTeaser(boolean isVideoTeaser) {
            ArrayList<View> views = AdViewHolder.getAllViewsByTag((ViewGroup)this.rootView, "eanative_video_teaser_play_overlay");
            for (int i = 0; i < views.size(); ++i) {
                View tagView = views.get(i);
                tagView.setVisibility(isVideoTeaser ? 0 : 8);
            }
        }

        public void setData(AdData data) {
            if (this.adData != data) {
                this.adData = data;
                for (BaseBinder binder : this.binders) {
                    binder.setData(data);
                }
            }
        }

        private final class BrandClickListener
        implements View.OnClickListener {
            private BrandClickListener() {
            }

            public void onClick(View view) {
                AdViewHolder.this.dispatchEvent(EANativeEvent.BRAND_CLICKED, AdViewHolder.this.rootView);
            }
        }

        private final class AdClickListener
        implements View.OnClickListener {
            private AdClickListener() {
            }

            public void onClick(View view) {
                AdViewHolder.this.dispatchEvent(EANativeEvent.AD_CLICKED, AdViewHolder.this.rootView);
            }
        }
    }
}

