/*
 * Decompiled with CFR 0.152.
 */
package eanative.android;

import android.content.Context;
import android.widget.BaseAdapter;
import eanative.android.ad.EANativeAdPlacer;
import eanative.android.model.EANativeListAdapter;
import eanative.android.model.EANativeServerClient;
import eanative.android.util.Logger;

public class EANative {
    private static EANativeServerClient serverClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void initialize(Context context, String nativeAppKey) {
        if (serverClient == null) {
            Class<EANative> clazz = EANative.class;
            // MONITORENTER : eanative.android.EANative.class
            if (serverClient == null) {
                serverClient = new EANativeServerClient(context.getApplicationContext());
            }
            // MONITOREXIT : clazz
        }
        serverClient.setApplicationKey(nativeAppKey);
        serverClient.setActive(true);
    }

    public static void setTestMode(boolean testMode, String deviceId) {
        if (serverClient == null) {
            Logger.error("You have to call EANative.initialize method first", new Object[0]);
            return;
        }
        serverClient.setTestDevices(testMode, deviceId);
    }

    public static EANativeListAdapter createListAdapter(Context context, BaseAdapter originalAdapter) {
        if (serverClient == null) {
            Logger.error("You have to call EANative.initialize method first", new Object[0]);
            return null;
        }
        return new EANativeListAdapter(context, originalAdapter, serverClient);
    }

    public static EANativeAdPlacer createAdPlacer(Context context) {
        if (serverClient == null) {
            Logger.error("You have to call EANative.initialize method first", new Object[0]);
            return null;
        }
        return new EANativeAdPlacer(context, serverClient);
    }
}

