package eanative.android.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

import com.android.volley.toolbox.ImageLoader;
import com.android.volley.toolbox.VolleyImageView;
import com.facebook.ads.MediaView;

import org.nexage.sourcekit.vast.VASTPlayer;
import org.nexage.sourcekit.vast.model.VASTModel;

import eanative.android.R;
import eanative.android.ad.AdData;
import eanative.android.util.EAImageLoader;
import eanative.android.util.Logger;

/**
 * Created by beni on 29/02/16.
 */
public class EAMediaView extends RelativeLayout{
    private final AttributeSet attributes;
    private final AdClickListener adClickListener;
    protected MediaView fbMediaView;
    protected EAVastPlayerView vastPlayerView;
    protected VolleyImageView imageView;
    protected EAImageLoader eaImageLoader;
    private VASTPlayer vastPlayer;
    private EAImageGallery eaImageGallery;
    private boolean autoPlay = true;

    public EAMediaView(Context context) {
        this(context,null);
    }
    public EAMediaView(Context context,AttributeSet attrs) {
        super(context,attrs);
        this.attributes = attrs;
        this.adClickListener = new AdClickListener();
    }
    public void setNativeAd(AdData ad, ImageLoader imageLoader){

        if(fbMediaView!=null) {
            fbMediaView.setVisibility(GONE);
        }
        if(vastPlayerView!=null){
            vastPlayerView.setVisibility(GONE);
        }
        if(eaImageGallery!=null){
            eaImageGallery.setVisibility(GONE);
        }
        if(imageView!=null){
            imageView.setVisibility(GONE);
        }

        if(ad.getAdDSP().equals(AdData.TYPE_FACEBOOK)){
            if(fbMediaView == null){
                this.fbMediaView = new MediaView(this.getContext(),this.attributes);
                this.addView(this.fbMediaView);

            }
            fbMediaView.setNativeAd(ad.nativeFBAd);
            ad.nativeFBAd.registerViewForInteraction(fbMediaView);
            fbMediaView.setVisibility(VISIBLE);
        }else if(ad.isVideoTeaser()){
            if(vastPlayerView != null) {
                vastPlayerView.cleanPlayerUp();
                this.removeView(this.vastPlayerView);
                this.vastPlayerView = null;
            }

            String videoUrl = ad.getAdTag("video_url");

            // We can create VAST Player and pass the data

            if(vastPlayer == null) {
                vastPlayer = new VASTPlayer(this.getContext(),
                        new VASTPlayer.VASTPlayerListener() {

                            @Override
                            public void vastReady() {
                                Logger.debug("VAST Document is ready and we can play it now");

                                EAMediaView.this.showVastPlayerView(vastPlayer);
                            }

                            @Override
                            public void vastError(int error) {
                                String message = "Unable to play VAST Document: Error: " + error;
                                Logger.debug(message);
                                //processTeaserClick(adData, isExternal, brandClicked);
                            }

                            @Override
                            public void vastClick() {
                                Logger.debug("VAST click event fired");
                            }

                            @Override
                            public void vastComplete() {
                                Logger.debug("VAST complete event fired");
                            }

                            @Override
                            public void vastDismiss() {

                                Logger.debug("VAST dismiss event fired");
                                //processTeaserClick(adData, isExternal, brandClicked);
                            }
                        });
            }

            vastPlayer.loadVideoWithUrl(videoUrl);

        }else {
            String[] squareImages = ad.getAdImageTag("image_square");
            if(squareImages != null && squareImages.length>1){
                if(this.eaImageGallery == null){
                    this.eaImageGallery = new EAImageGallery(this.getContext());
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(
                            RelativeLayout.LayoutParams.MATCH_PARENT,
                            RelativeLayout.LayoutParams.MATCH_PARENT);
                    this.eaImageGallery.setLayoutParams(params);
                    this.eaImageGallery.setOnClickListener(this.adClickListener);
                    this.addView(this.eaImageGallery);
                }
                this.eaImageGallery.setNativeAd(ad,"image_square",imageLoader);
                this.eaImageGallery.setVisibility(VISIBLE);
            }else{
                if(this.imageView == null) {

                    this.imageView = new VolleyImageView(this.getContext());
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(
                            RelativeLayout.LayoutParams.MATCH_PARENT,
                            RelativeLayout.LayoutParams.MATCH_PARENT);
                    this.imageView.setLayoutParams(params);
                    this.imageView.setOnClickListener(this.adClickListener );
                    this.addView(this.imageView);
                }
                if(this.eaImageLoader == null){
                    this.eaImageLoader = new EAImageLoader();

                }
                this.eaImageLoader.setNativeAd(this.imageView,ad,"image_large_landscape",imageLoader);
                this.eaImageLoader.loadImage(false);
                this.imageView.setVisibility(VISIBLE);

            }
        }
    }
    public void showVastPlayerView(final VASTPlayer vastPlayer){
        VASTModel mVastModel = vastPlayer.getVastModel();
        Logger.debug("show vast player view %s",mVastModel.toString());
        if (mVastModel != null) {
            vastPlayerView = new EAVastPlayerView(EAMediaView.this.getContext(),mVastModel){
                @Override
                protected void onMediaComplete(){
                    if(vastPlayer.listener != null) {
                        vastPlayer.listener.vastComplete();
                    }
                }
            };
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(
                    RelativeLayout.LayoutParams.MATCH_PARENT,
                    RelativeLayout.LayoutParams.MATCH_PARENT);
            vastPlayerView.setLayoutParams(params);
            vastPlayerView.setAutoPlay(this.autoPlay);
            vastPlayerView.setVisibility(VISIBLE);
            vastPlayerView.setBackgroundColor(ContextCompat.getColor(this.getContext(),R.color.video_background_color));
            this.vastPlayerView.setOnClickListener(this.adClickListener);
            if(this.autoPlay == true){
                vastPlayerView.activateButtons(false);
                vastPlayerView.setVolume(0);
            }
            Logger.debug("MEDIA VIEW DIMENSIONS  %s %s",getWidth(),getHeight());
            this.addView(this.vastPlayerView);
        } else {

        }
    }
    public void clear(){

    }

    public boolean isAutoPlay() {
        return autoPlay;
    }

    public void setAutoPlay(boolean autoPlay) {
        this.autoPlay = autoPlay;
    }

    private final class AdClickListener implements View.OnClickListener {
        @TargetApi(Build.VERSION_CODES.ICE_CREAM_SANDWICH_MR1)
        public void onClick(View view) {
            if(EAMediaView.this.vastPlayerView != null){
                EAMediaView.this.vastPlayerView.pause();
            }
            EAMediaView.this.callOnClick();
        }
    }

}
