package eanative.android.model;

import android.content.Context;

import com.facebook.ads.AdListener;
import com.facebook.ads.NativeAd;

import eanative.android.ad.AdData;
import eanative.android.util.Logger;

import com.facebook.ads.Ad;

/**
 * Created by beni on 24/02/16.
 */
public class EANativeFBProxy {
    public static NativeAd loadFBNativeAd(Context context, String fbPlacementId, AdListener listener){

        NativeAd nativeAd = new NativeAd(context, fbPlacementId);
        nativeAd.setAdListener(listener);

        nativeAd.loadAd();
        return  nativeAd;
    }
    public static void convertFBAdToEANative(NativeAd fbAd, AdData adData){
        String titleForAd = fbAd.getAdTitle();
        NativeAd.Image coverImage = fbAd.getAdCoverImage();
        NativeAd.Image iconForAd = fbAd.getAdIcon();
        String textForAdBody = fbAd.getAdBody();
        String coverImageURL = coverImage.getUrl();
        adData.setAdTag("title",titleForAd);
        adData.setAdTag("image_landscape",coverImageURL);
        adData.setAdTag("image_portrait",coverImageURL);
        adData.setAdTag("image_large_landscape",coverImageURL);
        adData.setAdTag("cta",fbAd.getAdCallToAction());

        Logger.debug("IMAGE URL:%s",coverImageURL);
        adData.setAdTag("brand_logo",iconForAd.getUrl());
        adData.setAdTag("summary",textForAdBody);
        adData.nativeFBAd = fbAd;

    }
}
