package eanative.android.ad;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;

import java.util.HashMap;
import java.util.Set;
import java.util.WeakHashMap;

import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;

import org.json.JSONArray;
import org.json.JSONException;
import org.nexage.sourcekit.util.VASTLog;
import org.nexage.sourcekit.vast.VASTPlayer;
import org.nexage.sourcekit.vast.model.VASTModel;

import eanative.android.EANativeActivity;
import eanative.android.VastTeaserActivity;
import eanative.android.events.EANativeAdListener;
import eanative.android.events.EANativeEvent;
import eanative.android.events.EANativeEventListener;
import eanative.android.events.EventDispatcher;
import eanative.android.model.EANativePlacementConfig;
import eanative.android.model.EANativeServerClient;
import eanative.android.util.EANSettings;
import eanative.android.util.Logger;

public class EANativeAdPlacer extends EventDispatcher {
	protected final Context context;
	private final Handler impressionHandler;
	private final EANativeServerClient serverClient;
	private final WeakHashMap<View, AdData> adDataWeakMap;
	private final AdResponseListener adResponseListener;
	private JsonObjectRequest pendingRequest;
	private boolean isInitialRequest;
	private HashMap<Integer, AdData> ads;
	private EANativeAdViewBinder adViewBinder;
	private EANativeAdListener adClickListener;
	private EANativePlacementConfig placementConfig;
	private int lastAdPosition = 0;
	private int adsCount = 0;
	private int totalAdsToRequest = 0;
	private boolean aaidListenerAdded = false;
	private VASTPlayer newPlayer;

	private EANativeEventListener aaidProcessComplateHandler;

	@SuppressLint("UseSparseArrays")
	public EANativeAdPlacer(Context context, EANativeServerClient serverClient) {
		this.context = context;
		this.impressionHandler = new Handler();
		this.serverClient = serverClient;

		this.adDataWeakMap = new WeakHashMap<View, AdData>(8, 0.75F);
		this.ads = new HashMap<Integer, AdData>();
		this.adResponseListener = new AdResponseListener();

		this.adClickListener = new EANativeAdListener() {

			@Override
			public void handleMessage(String event, Object message) {

			}

			@Override
			public void brandClicked(Object view) {
				EANativeAdPlacer.this.onAdClick((View) view, true);
			}

			@Override
			public void adClicked(Object view) {
				EANativeAdPlacer.this.onAdClick((View) view, false);

			}
		};

	}

	public void registerAdViewBinder(EANativeAdViewBinder adViewBinder) {
		this.adViewBinder = adViewBinder;
	}

	public void clearPendingImpressions() {
		this.impressionHandler.removeMessages(0);
	}
	
	

	public void initPlacement(EANativePlacementConfig placementConfig) {
		this.placementConfig = placementConfig;
		this.registerAdViewBinder(new EANativeAdViewBinder(this.context,
				placementConfig.layoutResourceId));
	}
	public void initPlacement(String placementId, int layoutResId) {
		EANativePlacementConfig config = new EANativePlacementConfig(
				placementId);
		config.layoutResourceId = layoutResId;
		this.initPlacement(config);
	}
	public void initPlacement(String placementId, int layoutResId ,EANativePlacementConfig config) {
		if(config==null){
			this.initPlacement( placementId, layoutResId);
			return;
		}
		config.layoutResourceId = layoutResId;
		config.placementId = placementId;
		
		this.initPlacement(config);
	}
	public int getTotalAdsToRequest() {
		return this.totalAdsToRequest;
	}
	public void setTotalAdsToRequest(int adsToRequest) {
		this.totalAdsToRequest = adsToRequest;
		if(this.pendingRequest==null){
			if(this.totalAdsToRequest>this.adsCount){
				this.requestAds(0);
			}
		}
	}
		
	public void requestAds() {
		this.requestAds(1);
	}
	public void requestAds(int adsToRequest) {
		
		this.totalAdsToRequest +=adsToRequest;
		if (placementConfig == null || placementConfig.placementId == "") {
			Logger.error("EANativeAdPlacer.initialize have to be called before requesting ads");
			return;
		}
		if (this.pendingRequest != null) {
			this.pendingRequest.cancel();
			this.pendingRequest = null;
		}
		if(EANSettings.getSettings().aaidProcessFinished==true){
			this.isInitialRequest = true;
			this.pendingRequest = this.serverClient.requestAds(placementConfig,
					this.adResponseListener, this.AdResponseErrorListener);
		}else if(aaidListenerAdded==false){
			aaidListenerAdded = true;
			
			this.aaidProcessComplateHandler = new EANativeEventListener() {
				
				@Override
				public void handleMessage(String event, Object message) {
					if(EANativeAdPlacer.this.totalAdsToRequest>EANativeAdPlacer.this.adsCount){
						EANativeAdPlacer.this.requestAds(0);
					}
					
				}
			};
			EANSettings.getSettings().registerEventListener(EANativeEvent.AAID_PROCESS_COMPLETE,this.aaidProcessComplateHandler );
		}
	}

	public View getView(View convertView, ViewGroup parent) {
		return this.getView(this.getAdData(this.lastAdPosition), convertView,
				parent);
	}

	public View getView(int position, View convertView, ViewGroup parent) {
		AdData adData = this.getAdData(position);
		return this.getView(adData, convertView, parent);
	}

	public View getView(AdData adData, View convertView, ViewGroup parent) {
		if (adData == null) {
			return convertView;
		}
		View view = convertView;

		view = this.adViewBinder.createView(convertView, parent,
				this.adClickListener);

		AdData AdData = (AdData) adData;
		AdData oldAdData = (AdData) this.adDataWeakMap.get(view);

		if (oldAdData != AdData) {
			this.adDataWeakMap.put(view, AdData);

			this.adViewBinder.bindAdData(view, adData, this.isVideoTeaser(view));
			JSONArray trackers = adData.getImpressionTrackEvents();

			if(trackers!=null) {
				Logger.debug("trackers %s",trackers.toString());

				for (int i = 0; i < trackers.length(); i++) {
					String trackURL = "";
					try {
						trackURL = trackers.getString(i);
					} catch (JSONException e) {
					}
					if (!trackURL.isEmpty()) {
						this.serverClient.trackEvent(trackURL);
					}
				}
				adData.markImpressionsAsTracked();
			}
		}
		
		return view;
	}

	public synchronized  void clearAllAds() {
		if (this.ads != null){
			this.ads.clear();
		}
		
		
		if (this.adDataWeakMap != null) {
			Set<View> keyset = this.adDataWeakMap.keySet();
			
			for (View view : keyset) {
				if(view!=null){
					if (this.adViewBinder != null) {
						this.adViewBinder.clear(view);
					}
					view.setOnClickListener(null);
				}
			}
			this.adDataWeakMap.clear();
		}
		this.adsCount = 0;
		this.totalAdsToRequest = 0;
		if (this.pendingRequest != null) {
			this.pendingRequest.cancel();
			this.pendingRequest = null;
		}
		if(this.aaidProcessComplateHandler!=null){
			EANSettings.getSettings().unregisterEventListener(EANativeEvent.AAID_PROCESS_COMPLETE, this.aaidProcessComplateHandler);
		}

	}

	public void clearAd(View view) {
		if (view == null) {
			return;
		}
		AdData adData = (AdData) this.adDataWeakMap.get(view);
		if (adData != null) {
			this.adDataWeakMap.remove(view);
		}
		if (this.adViewBinder != null) {
			this.adViewBinder.clear(view);
		}
		view.setOnClickListener(null);
	}

	public boolean isVideoTeaser(View view) {
		AdData adData = (AdData) EANativeAdPlacer.this.adDataWeakMap.get(view);
		return adData.isVideoTeaser();
	}
	public void onAdClick(View view, final boolean brandClicked) {
		final AdData adData = EANativeAdPlacer.this.adDataWeakMap.get(view);

		if (adData == null) {
			return;
		}

		final String cta =  placementConfig.vastTeaserConfig.callToActionText
				.replaceAll("\\{brand_name\\}",adData.getAdTag("brand_name"));
		final String ett =  placementConfig.vastTeaserConfig.elapsedTimeText;
		final boolean isExternal = adData.getAdTag("content_type").equals("content_link");
		Logger.debug(" is video teaser %s",isVideoTeaser(view));
		if(!brandClicked && isVideoTeaser(view)){
			// Get file content
			String videoUrl = adData.getAdTag("video_url");

			// We can create VAST Player and pass the data
			newPlayer = new VASTPlayer(context,
					new VASTPlayer.VASTPlayerListener() {

						@Override
						public void vastReady() {
							Logger.debug("VAST Document is ready and we can play it now");
							Intent vastPlayerIntent = new Intent(context, VastTeaserActivity.class);
							vastPlayerIntent.putExtra("eanative.android.placement.cta", cta);
							vastPlayerIntent.putExtra("eanative.android.placement.ett", ett);

							final VASTModel mVastModel = newPlayer.getVastModel();
							if(mVastModel !=null) {
								vastPlayerIntent.putExtra("eanative.android.vast.player.vastModel", mVastModel);
								context.startActivity(vastPlayerIntent);
							}else{
								processTeaserClick(adData, isExternal, brandClicked);
							}
						}

						@Override
						public void vastError(int error) {
							String message = "Unable to play VAST Document: Error: " + error;
							Logger.debug(message);
							processTeaserClick(adData, isExternal, brandClicked);
						}

						@Override
						public void vastClick() {
							Logger.debug("VAST click event fired");
						}

						@Override
						public void vastComplete() {
							Logger.debug("VAST complete event fired");
						}

						@Override
						public void vastDismiss() {

							Logger.debug("VAST dismiss event fired");
							//processTeaserClick(adData, isExternal, brandClicked);
						}
					});

			newPlayer.loadVideoWithUrl(videoUrl);

		}else{
			this.processTeaserClick(adData,isExternal,brandClicked);
		}

		this.serverClient.trackEvent(adData.getTrackEvent(AdData.CLICK_TRACK));
	}
	private void processTeaserClick(AdData adData,boolean isExternal,boolean brandClicked){
		Intent intent = null;
		String url = "";

		if (brandClicked||isExternal ) {
			intent = new Intent(Intent.ACTION_VIEW);

			if(isExternal ){
				url = adData.getContentLink();
			}
			else{
				url = adData.getBrandLink();
			}
			if(url !=""){
				intent.setData(Uri.parse(url));
			}
		} else {
			intent = new Intent(EANativeAdPlacer.this.context,
					EANativeActivity.class);
			url = adData.getContentLink();
			intent.putExtra("contentURL", url);
		}
		Logger.debug("process teaser click %s",url);
		if(intent != null) {
			try {
				EANativeAdPlacer.this.context.startActivity(intent);
			} catch (Exception e) {
				Logger.error("Couldn't start activity for URL: %s %s",
						e.toString(), new Object[]{url});
			}
		}
	}
	private final Response.ErrorListener AdResponseErrorListener = new Response.ErrorListener() {
		public void onErrorResponse(VolleyError error) {
			Logger.warn("ERROR while trying to get ads: %s", error.getMessage());
			EANativeAdPlacer.this.pendingRequest = null;
		}
	};

	private final class AdResponseListener implements Response.Listener<AdData> {
		public void onResponse(AdData ad) {
			EANativeAdPlacer.this.pendingRequest = null;
			if (EANativeAdPlacer.this.isInitialRequest) {
				EANativeAdPlacer.this.clearPendingImpressions();
				EANativeAdPlacer.this.isInitialRequest = false;
			}

			EANativeAdPlacer.this.insertAd(ad);
			EANativeAdPlacer.this.dispatchEvent(EANativeEvent.ADS_LOADED,
					new EANativeEvent(ad));
			
			if(EANativeAdPlacer.this.totalAdsToRequest>EANativeAdPlacer.this.adsCount){
				EANativeAdPlacer.this.requestAds(0);
			}
		}
	}
	public int getLastAdPosition() {
		return this.lastAdPosition;
	}
	public int getNextAdPosition() {
		int position =  this.lastAdPosition;
		if(this.adsCount>0){
			position+=this.placementConfig.adFrequency+1;
		}else{
			position+=this.placementConfig.startAdPosition;
		}
		return position;
	}

	public AdData getAdData(int position) {
		return this.ads.get(position);
	}

	public int getItemViewType(int position) {
		if (this.lastAdPosition > 0) {
			if (this.isAd(position) == true) {
				return 1;
			}
		}
		return 0;
	}

	public int getAdjustedPosition(int position) {
		int requestPos = position;
		for (int key : this.ads.keySet()) {
			if (requestPos > key) {
				position--;
			}
		}
		return position;
	}

	public int getAdsCount() {
		return this.adsCount;
	}

	public int getViewTpeCount() {
		return 1;
	}

	public boolean isAd(int position) {
		if (this.ads.get(position) != null) {
			return true;
		}
		return false;
	}

	public void insertAd(AdData ad) {
		ad.setPlacementConfig(this.placementConfig);
		this.lastAdPosition = this.getNextAdPosition();
//		Logger.info("insert ad at %s",this.lastAdPosition);
		this.ads.put(this.lastAdPosition, ad);
		this.adsCount++;
	}

	public  EANativePlacementConfig getConfig() {
		return this.placementConfig;
	}

}
