/*
 * Decompiled with CFR 0.152.
 */
package org.nexage.sourcekit.vast.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.graphics.drawable.Drawable;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.nexage.sourcekit.util.Assets;
import org.nexage.sourcekit.util.HttpTools;
import org.nexage.sourcekit.util.VASTLog;
import org.nexage.sourcekit.vast.VASTPlayer;
import org.nexage.sourcekit.vast.model.TRACKING_EVENTS_TYPE;
import org.nexage.sourcekit.vast.model.VASTModel;

public class VASTActivity
extends Activity
implements MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener,
SurfaceHolder.Callback {
    private static String TAG = "VASTActivity";
    private static final double SKIP_INFO_PADDING_SCALE = 0.1;
    private static final double SKIP_INFO_SCALE = 0.15;
    private static final long TOOLBAR_HIDE_DELAY = 3000L;
    private static final long QUARTILE_TIMER_INTERVAL = 250L;
    private static final long VIDEO_PROGRESS_TIMER_INTERVAL = 250L;
    private Timer mToolBarTimer;
    private Timer mTrackingEventTimer;
    private Timer mStartVideoProgressTimer;
    private LinkedList<Integer> mVideoProgressTracker = null;
    private final int mMaxProgressTrackingPoints = 20;
    private Handler mHandler;
    private VASTModel mVastModel = null;
    private HashMap<TRACKING_EVENTS_TYPE, List<String>> mTrackingEventMap;
    private MediaPlayer mMediaPlayer;
    private SurfaceView mSurfaceView;
    private SurfaceHolder mSurfaceHolder;
    private RelativeLayout mOverlay;
    private RelativeLayout mRootLayout;
    private ImageButton mInfoButton;
    private ImageButton mPlayPauseButton;
    private ImageButton mCloseButton;
    private Drawable mPauseDrawable;
    private Drawable mPlayDrawable;
    private int mVideoHeight;
    private int mVideoWidth;
    private int mScreenWidth;
    private int mScreenHeight;
    private boolean mIsVideoPaused = false;
    private boolean mIsPlayBackError = false;
    private boolean mIsProcessedImpressions = false;
    private boolean mIsCompleted = false;
    private int mCurrentVideoPosition;
    private int mQuartile = 0;
    private ProgressBar mProgressBar;

    protected void onCreate(Bundle savedInstanceState) {
        VASTLog.d(TAG, "in onCreate");
        super.onCreate(savedInstanceState);
        int currentOrientation = this.getResources().getConfiguration().orientation;
        VASTLog.d(TAG, "currentOrientation:" + currentOrientation);
        if (currentOrientation != 2) {
            VASTLog.d(TAG, "Orientation is not landscape.....forcing landscape");
            this.setRequestedOrientation(0);
        } else {
            VASTLog.d(TAG, "orientation is landscape");
            Intent i = this.getIntent();
            this.mVastModel = (VASTModel)i.getSerializableExtra("com.nexage.android.vast.player.vastModel");
            if (this.mVastModel == null) {
                VASTLog.e(TAG, "vastModel is null. Stopping activity.");
                this.finishVAST();
            } else {
                this.hideTitleStatusBars();
                this.mHandler = new Handler();
                DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
                this.mScreenWidth = displayMetrics.widthPixels;
                this.mScreenHeight = displayMetrics.heightPixels;
                this.mTrackingEventMap = this.mVastModel.getTrackingUrls();
                this.createUIComponents();
            }
        }
    }

    protected void onStart() {
        VASTLog.d(TAG, "entered onStart --(life cycle event)");
        super.onStart();
    }

    protected void onResume() {
        VASTLog.d(TAG, "entered on onResume --(life cycle event)");
        super.onResume();
    }

    protected void onStop() {
        VASTLog.d(TAG, "entered on onStop --(life cycle event)");
        super.onStop();
    }

    protected void onRestart() {
        VASTLog.d(TAG, "entered on onRestart --(life cycle event)");
        super.onRestart();
        this.createMediaPlayer();
    }

    protected void onPause() {
        VASTLog.d(TAG, "entered on onPause --(life cycle event)");
        super.onPause();
        if (this.mMediaPlayer != null) {
            this.mCurrentVideoPosition = this.mMediaPlayer.getCurrentPosition();
        }
        this.cleanActivityUp();
    }

    protected void onDestroy() {
        VASTLog.d(TAG, "entered on onDestroy --(life cycle event)");
        super.onDestroy();
    }

    public void onSaveInstanceState(Bundle savedInstanceState) {
        VASTLog.d(TAG, "entered onSaveInstanceState ");
        super.onSaveInstanceState(savedInstanceState);
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        VASTLog.d(TAG, "in onRestoreInstanceState");
        super.onRestoreInstanceState(savedInstanceState);
    }

    private void hideTitleStatusBars() {
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
    }

    private void createUIComponents() {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        this.createRootLayout(params);
        this.createSurface(params);
        this.createMediaPlayer();
        this.createOverlay(params);
        int size = Math.min(this.mScreenWidth, this.mScreenHeight);
        size = (int)(0.15 * (double)size);
        this.createPlayPauseButton(size);
        this.createCloseButton(size);
        this.createInfoButton(size);
        this.setContentView((View)this.mRootLayout);
        this.createProgressBar();
    }

    private void createProgressBar() {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
        params.addRule(13);
        this.mProgressBar = new ProgressBar((Context)this);
        this.mProgressBar.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mRootLayout.addView((View)this.mProgressBar);
        this.mProgressBar.setVisibility(8);
    }

    private void showProgressBar() {
        this.mProgressBar.setVisibility(0);
    }

    private void hideProgressBar() {
        this.mProgressBar.setVisibility(8);
    }

    private void createRootLayout(RelativeLayout.LayoutParams params) {
        this.mRootLayout = new RelativeLayout((Context)this);
        this.mRootLayout.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mRootLayout.setPadding(0, 0, 0, 0);
        this.mRootLayout.setBackgroundColor(-16777216);
    }

    private void createSurface(RelativeLayout.LayoutParams params) {
        this.mSurfaceView = new SurfaceView((Context)this);
        this.mSurfaceView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mSurfaceHolder = this.mSurfaceView.getHolder();
        this.mSurfaceHolder.addCallback((SurfaceHolder.Callback)this);
        this.mSurfaceHolder.setType(3);
        this.mRootLayout.addView((View)this.mSurfaceView);
    }

    private void createMediaPlayer() {
        this.mMediaPlayer = new MediaPlayer();
        this.mMediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
        this.mMediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this);
        this.mMediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
        this.mMediaPlayer.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
        this.mMediaPlayer.setAudioStreamType(3);
    }

    private void createOverlay(RelativeLayout.LayoutParams params) {
        this.mOverlay = new RelativeLayout((Context)this);
        this.mOverlay.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mOverlay.setPadding(0, 0, 0, 0);
        this.mOverlay.setBackgroundColor(0);
        this.mOverlay.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VASTActivity.this.overlayClicked();
            }
        });
        this.mRootLayout.addView((View)this.mOverlay);
    }

    private void createInfoButton(int size) {
        String clickThroughUrl = this.mVastModel.getVideoClicks().getClickThrough();
        if (clickThroughUrl != null && clickThroughUrl.length() > 0) {
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(size, size);
            params.addRule(0, 22);
            this.mInfoButton = new ImageButton((Context)this);
            Drawable drawable2 = Assets.getDrawableFromBase64(this.getResources(), "iVBORw0KGgoAAAANSUhEUgAAAC0AAAAtCAYAAAA6GuKaAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJ bWFnZVJlYWR5ccllPAAAA2hpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdp bj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6 eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMy1jMDExIDY2LjE0 NTY2MSwgMjAxMi8wMi8wNi0xNDo1NjoyNyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJo dHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlw dGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEu MC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVz b3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1N Ok9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDpGQkU5MjA4OTBDMjA2ODExODA4M0YyQ0E4QjA4 M0I1MCIgeG1wTU06RG9jdW1lbnRJRD0ieG1wLmRpZDpDNDMxMTM3QjYxMjAxMUUzQjhCRkRDNTJC NjI0NTY5OCIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDpDNDMxMTM3QTYxMjAxMUUzQjhCRkRD NTJCNjI0NTY5OCIgeG1wOkNyZWF0b3JUb29sPSJBZG9iZSBQaG90b3Nob3AgQ1M2IChNYWNpbnRv c2gpIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6MDY4MDEx NzQwNzIwNjgxMTgwODNBRjJCNzQzNDlDQ0IiIHN0UmVmOmRvY3VtZW50SUQ9InhtcC5kaWQ6RkJF OTIwODkwQzIwNjgxMTgwODNGMkNBOEIwODNCNTAiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRm OlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz5stwd/AAADTUlEQVR42uyZXUgU URTHnU1NzI9Wi1y31jCiNfMjwhL6sqSHSOwhInoq+vA1qtdAeq8ee4p6KKynCvIhsEwLEgrKfFA3 MzMrWc20D63NaPvf+g8syyYz584oxV74McvOnHv+c++dueecMaLRaMq/1oyk6KRod0Xng7WgAqwB PrAAfAOjoAd0kqG5Fl0DjoA6kEuRA2Ccv9P5fyDmfBu4CG6CabFqJdomW0Fb9E97Dc6CWrAYpMVd 6wF5YD04Bbpo1w32CXz/xs7F88E5Ou0B+0GGTYcGb7CV/dwAPrdEF4IHdNQIMqWjFMMB8AUMgWqn RQdAL5gAOxwQG0uQS+Yr2OyUaC87fQ/KHBZssgg85qCUOSH6OpgGG1wSbFIABkAILNQRfZhr+KDL gk2q6O+8VLSasjFwS1PEaps2pym8SiK6kcarhIJLaT8O8m3YZYM3oNmu6CwwApo0RtnPDaSV/dmx Pc4bLrEjuo5GWxxYp4bwoYxwqVgWfQEMC3a7WHL4xkkX2t8BT/523hMXiswDG0EHAxxpqwftjAAl rQWUgyWJTnoShJl+8FQzelwO3oIPQvtnHMCVVkR7QTZ4oSm6BIRBRGj/jkefFdEZPE5oii4C/Rr2 n3nMsiI6GneUNHXjheC5Rh8z+o8XbU5nrobDHE5rSKMPc4QnrYj+xAuLNRwuA2ngpUYf5loOWxE9 yoegUsOhuuEpMKbRh0qQf4I+K6J/gEegmompVLSarWEN0bWgN+YtMqPoFGbKAY3RDlKwdHPKA9tA s9UHUbW7XNtHhU5V/WNQY5T3gExwzW4J4Qz4zvzQboDUwIxbEnOojL8PtEviaRVaToIrs5S1xIel NdJ06yQ72D1LgoOc3SadHDEV3AMf2aGbglXG0smQuEA3G18KBkG/YH1bRRV+bjPr3+RUsaaUI/AK rHNYsC+mRFbvdFksyCpThG8HwwHBO5nEqtLYLrcKkCqrvspRuQ+2C8WW82FTrYMz6VrV1GQvM+0o 87gToILv2ETXq/LvCnAItNAuDI4lKA1bQlpUT+XO1cAt12BEFmLQNcW42suUqYh26mvAJXCZxfc5 +3xRzGS4ktGZn9uwis1HQDdzvoegK/mhKCk6Kfo/Ef1LgAEA1OTZevb7RacAAAAASUVORK5CYII=");
            this.mInfoButton.setImageDrawable(drawable2);
            this.mInfoButton.setLayoutParams((ViewGroup.LayoutParams)params);
            this.mInfoButton.setScaleType(ImageView.ScaleType.CENTER_CROP);
            this.mInfoButton.setPadding(0, 0, 0, 0);
            this.mInfoButton.setBackgroundColor(0);
            this.mInfoButton.setEnabled(true);
            this.mInfoButton.setVisibility(0);
            this.mInfoButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    VASTActivity.this.infoClicked();
                }
            });
            this.mOverlay.addView((View)this.mInfoButton);
        }
    }

    private void createCloseButton(int size) {
        this.mCloseButton.setVisibility(0);
        this.mCloseButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VASTActivity.this.closeClicked();
            }
        });
    }

    private void createPlayPauseButton(int size) {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(size, size);
        params.addRule(9);
        this.mPauseDrawable = Assets.getDrawableFromBase64(this.getResources(), "iVBORw0KGgoAAAANSUhEUgAAAC0AAAAtCAYAAAA6GuKaAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJ bWFnZVJlYWR5ccllPAAAA2hpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdp bj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6 eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMy1jMDExIDY2LjE0 NTY2MSwgMjAxMi8wMi8wNi0xNDo1NjoyNyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJo dHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlw dGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEu MC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVz b3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1N Ok9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDpGOUU5MjA4OTBDMjA2ODExODA4M0YyQ0E4QjA4 M0I1MCIgeG1wTU06RG9jdW1lbnRJRD0ieG1wLmRpZDpDNDMxMTM3NzYxMjAxMUUzQjhCRkRDNTJC NjI0NTY5OCIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDpDNDMxMTM3NjYxMjAxMUUzQjhCRkRD NTJCNjI0NTY5OCIgeG1wOkNyZWF0b3JUb29sPSJBZG9iZSBQaG90b3Nob3AgQ1M2IChNYWNpbnRv c2gpIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6MDM4MDEx NzQwNzIwNjgxMTgwODNBRjJCNzQzNDlDQ0IiIHN0UmVmOmRvY3VtZW50SUQ9InhtcC5kaWQ6RjlF OTIwODkwQzIwNjgxMTgwODNGMkNBOEIwODNCNTAiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRm OlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz7tuMs8AAADCElEQVR42uzZW0gU URzHcddVu4hlFwvTsKToZhZRPlVQgdFDQReyQui1XgLBSirwQXqLwvC1EKIgrMgKgkIfoqALimFa CEWGLRSoWG5Cptt36Le0iO7OdQdhD3wY0XHmNztzzpzz30AkEkmbbi09bRq2VOhU6Dgtw6XjrMdW bMFq5CETP9GHdrzGc/Q7PVnAwegxG8dwEhvwB53owSBGkY18lGIpwmhGA17aTm2EtqECHzGGuziA BXH2z0QJatAT+dduocjO+a3+Qw4addLbWGfjpFk4jq8YxEEvQ+fjDYZwyOYdijUP1/UBVHsReiG6 0Is1LgSOVaPgZ90MbTyPrQhhmcuBo04r+BG3QtfpgGUeBY66hhEUOw1dauHWGRdVjuWTdLxd+ltu gk7+GQ+dhn6gISrLROh2XWDthN/nRf637QmOsd/MfvFe42uxF3X4bWLI/6XtxH2Nt9ewfh5LcIxm vaDO2J17VOrNdi+J04px1GM3Cu2ENj7l+3r1JrM9Vvhyq6GXYCVafJjEhfBBEzBLoVcZkyl0+zT7 bEOJ1dCLFTrkU+hezQrTrYTOVuiwT6GNeXgOglZCj2sb9Cl0MN7wOFXoIY2vc30KPR8DWliYDt2n bZFPoY2B4JM+ONOh32MEm3x6NDZrXWnp8TA6wiu9YJLdSjRytNp5I97BTh8ekaNasT+zGzqs1Xay Wi5OoDHecBsvtNF7r6BKtytRm6Ft5sQyBWaZLA5Va9+rTipMl3WrGkyEfoeOmJEn2kbVPzrUV6Zq Rm3kPC7ii9O6xx5NzKs8XGrNQTfazCw4zB70goJXehA4Gy3oxwq36x71Cn7KxcAFeIEfVhbOVk9S q+A3VbxxEnifyhLGYnajl2Wx6OLzGwZwzkb4bXiki2/CIq9rebEr7EsIq0zWpOe9VOWuoPabiULs UL94q7CdKlraOn/A4RdFBajAYZRpJT6i2VlEQ2qW5ufGIvkpbuDJVDM4r+vTk60rjbG2WFPLDI3L 39GluvWwGycKpL6SS4VOhU6FttX+CjAAgpoINtDHo/4AAAAASUVORK5CYII=");
        this.mPlayDrawable = Assets.getDrawableFromBase64(this.getResources(), "iVBORw0KGgoAAAANSUhEUgAAAC0AAAAtCAYAAAA6GuKaAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJ bWFnZVJlYWR5ccllPAAAA2hpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdp bj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6 eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMy1jMDExIDY2LjE0 NTY2MSwgMjAxMi8wMi8wNi0xNDo1NjoyNyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJo dHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlw dGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEu MC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVz b3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1N Ok9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDpGNEU5MjA4OTBDMjA2ODExODA4M0YyQ0E4QjA4 M0I1MCIgeG1wTU06RG9jdW1lbnRJRD0ieG1wLmRpZDo2MzBFQTlFNjYxMjAxMUUzQjhCRkRDNTJC NjI0NTY5OCIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDo2MzBFQTlFNTYxMjAxMUUzQjhCRkRD NTJCNjI0NTY5OCIgeG1wOkNyZWF0b3JUb29sPSJBZG9iZSBQaG90b3Nob3AgQ1M2IChNYWNpbnRv c2gpIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6MDI4MDEx NzQwNzIwNjgxMTgwODNBRjJCNzQzNDlDQ0IiIHN0UmVmOmRvY3VtZW50SUQ9InhtcC5kaWQ6RjRF OTIwODkwQzIwNjgxMTgwODNGMkNBOEIwODNCNTAiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRm OlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz77Lxw7AAADm0lEQVR42uyZXUgU URiG1dW1H0szrazwF9O0ItmEDBOW8qKopC66qKiIgiDKLkKCfgiJIArSLuyiQsoMIugiMAgqCylE CAMtgpJAS/JvLY2ldpXtPfQOLTK7e2bmjCj4wcOiO3O+d2bOfud7z0QHAoGo6RYxUdMwZkRPVsQq HCsOpIMlIIH/84I+0A1+TxXR88EWsAuUgWTgnHCMHwyDVvAINIFBK0mjTVaPRHAMVIJF4At4AdrB J+ABYuAFIBusBW6QD0ZAHajhUzAeQrRBtoOuwL94ANwgVuI8B9gA6nnud7DXRH5DosVTucyELaDY TEKyEjRxrFsg3g7RTtDAJBck76wMxznmE5CgWvRtDn5IkdhgdoBx3nmnKtGnKfiIDYI1KpjjugrR JRzsqo2CNU4xV0WkY8OVPFHD21h3i1hv9WI2mMVabDWaQRZYDUbNlLx9vHJ3hCvPB+/BfgU/0FXM WWVmeoia2gmaJRLlBP7HM1BmUXgja/gco6LXU8ROSdH+IOF+VpsVJkWXRJrboU68AjyStXOiaC0G wHmQZFC0gyvufaOixdR4KJkklGgtOjnfYwwIrwF9IE7ve71+OhVksHKoiEJwBzxlJygTbWzEsmVN wHIwF3xU3LtvZid4E+RFOLaLn5myopNEywp6bTAdDnAYtIBzbF31QmtZU2RFxwe5DrtCTMFq8BYU 63zvDVq4pJyL3wYrphfCLFwDn0NYNxFjsqK1q0y2SewQuAFqw9iuRDqfEdnp0Q98IEex2HHQAEo5 n8P5xAz+rr7J3ukeerw1CgW/BBfBcwNl0scpJCXaR+fsViBWzNdLoJHjykY5TbLHSJd3gKtZockV cQhUgxQTvcdS4ANnjC7jqcDLHkRG9BjFCtt0FxRY6PJOcqxcM86lDvziBYQ7Lo9JRBtbbrEtFe1o N3hs1m5l8jHVRki0jIbXqcByVfEGuKx4xLMcZOMkeMQCTq86Kx4xit6vmXWzOFTdVBCi33nDFsIF fljdFssC/eAdWGzDHZ5Hm/YHrFO5WSPs1yjosGCj9EgDrzgtttqxlyf27nrBT7BHgeBt4CvH22TX BqQgPWjjUHyWmhDr4m6riNeSC5gl0RoHQQ8Tt4JKJk8MMWfFlDrKWq6tmCcM+kbp6hFpY303nYiL rmSQDdcI/xa2LY2vNER0gHpwDwxM9puAiZFL4UX0fwvZWg6zU2unS/mgIpkq0TOv5GZET5X4K8AA /T7sDkDoeaAAAAAASUVORK5CYII=");
        this.mPlayPauseButton = new ImageButton((Context)this);
        this.mPlayPauseButton.setImageDrawable(this.mPauseDrawable);
        this.mPlayPauseButton.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mPlayPauseButton.setScaleType(ImageView.ScaleType.CENTER_CROP);
        this.mPlayPauseButton.setPadding(0, 0, 0, 0);
        this.mPlayPauseButton.setBackgroundColor(0);
        this.mPlayPauseButton.setEnabled(true);
        this.mPlayPauseButton.setVisibility(0);
        this.mPlayPauseButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VASTActivity.this.playPauseButtonClicked();
            }
        });
        this.mOverlay.addView((View)this.mPlayPauseButton);
    }

    private void infoClicked() {
        VASTLog.d(TAG, "entered infoClicked:");
        this.activateButtons(false);
        boolean isPlaying = this.mMediaPlayer.isPlaying();
        if (isPlaying) {
            this.mMediaPlayer.pause();
            this.mCurrentVideoPosition = this.mMediaPlayer.getCurrentPosition();
        }
        this.processClickThroughEvent();
    }

    private void activateButtons(boolean active) {
        VASTLog.d(TAG, "entered activateButtons:");
        if (active) {
            this.mOverlay.setVisibility(0);
        } else {
            this.mOverlay.setVisibility(8);
        }
    }

    private void processClickThroughEvent() {
        VASTLog.d(TAG, "entered processClickThroughEvent:");
        if (VASTPlayer.listener != null) {
            VASTPlayer.listener.vastClick();
        }
        String clickThroughUrl = this.mVastModel.getVideoClicks().getClickThrough();
        VASTLog.d(TAG, "clickThrough url: " + clickThroughUrl);
        List<String> urls = this.mVastModel.getVideoClicks().getClickTracking();
        this.fireUrls(urls);
        try {
            Uri uri = Uri.parse((String)clickThroughUrl);
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            ResolveInfo resolvable = this.getPackageManager().resolveActivity(intent, 32);
            if (resolvable == null) {
                VASTLog.e(TAG, "Clickthrough error occured, uri unresolvable");
                if ((double)this.mCurrentVideoPosition >= (double)this.mMediaPlayer.getCurrentPosition() * 0.99) {
                    this.mMediaPlayer.start();
                }
                this.activateButtons(true);
                return;
            }
            this.startActivity(intent);
        }
        catch (NullPointerException e) {
            VASTLog.e(TAG, e.getMessage(), e);
        }
    }

    private void closeClicked() {
        VASTLog.d(TAG, "entered closeClicked()");
        this.cleanActivityUp();
        if (!this.mIsPlayBackError) {
            this.processEvent(TRACKING_EVENTS_TYPE.close);
        }
        this.finishVAST();
        VASTLog.d(TAG, "leaving closeClicked()");
    }

    private void playPauseButtonClicked() {
        VASTLog.d(TAG, "entered playPauseClicked");
        if (this.mMediaPlayer == null) {
            VASTLog.e(TAG, "mMediaPlayer is null when playPauseButton was clicked");
            return;
        }
        boolean isPlaying = this.mMediaPlayer.isPlaying();
        VASTLog.d(TAG, "isPlaying:" + isPlaying);
        if (isPlaying) {
            this.processPauseSteps();
        } else if (this.mIsVideoPaused) {
            this.processPlaySteps();
            if (!this.mIsCompleted) {
                this.processEvent(TRACKING_EVENTS_TYPE.resume);
            }
        } else {
            this.processPlaySteps();
            this.mQuartile = 0;
            this.startQuartileTimer();
        }
    }

    private void processPauseSteps() {
        this.mIsVideoPaused = true;
        this.mMediaPlayer.pause();
        this.stopVideoProgressTimer();
        this.stopToolBarTimer();
        this.mPlayPauseButton.setImageDrawable(this.mPlayDrawable);
        if (!this.mIsCompleted) {
            this.processEvent(TRACKING_EVENTS_TYPE.pause);
        }
    }

    private void processPlaySteps() {
        this.mIsVideoPaused = false;
        this.mMediaPlayer.start();
        this.mPlayPauseButton.setImageDrawable(this.mPauseDrawable);
        this.startToolBarTimer();
        this.startVideoProgressTimer();
    }

    public void onBackPressed() {
        VASTLog.d(TAG, "entered onBackPressed");
        this.closeClicked();
    }

    public void surfaceCreated(SurfaceHolder holder) {
        VASTLog.d(TAG, "surfaceCreated -- (SurfaceHolder callback)");
        try {
            if (this.mMediaPlayer == null) {
                this.createMediaPlayer();
            }
            this.showProgressBar();
            this.mMediaPlayer.setDisplay(this.mSurfaceHolder);
            String url = this.mVastModel.getPickedMediaFileURL();
            VASTLog.d(TAG, "URL for media file:" + url);
            this.mMediaPlayer.setDataSource(url);
            this.mMediaPlayer.prepareAsync();
        }
        catch (Exception e) {
            VASTLog.e(TAG, e.getMessage(), e);
        }
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int arg1, int arg2, int arg3) {
        VASTLog.d(TAG, "entered surfaceChanged -- (SurfaceHolder callback)");
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        VASTLog.d(TAG, "entered surfaceDestroyed -- (SurfaceHolder callback)");
        this.cleanUpMediaPlayer();
    }

    public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
        VASTLog.d(TAG, "entered onVideoSizeChanged -- (MediaPlayer callback)");
        this.mVideoWidth = width;
        this.mVideoHeight = height;
        VASTLog.d(TAG, "video size: " + this.mVideoWidth + "x" + this.mVideoHeight);
    }

    public void onPrepared(MediaPlayer mp) {
        VASTLog.d(TAG, "entered onPrepared called --(MediaPlayer callback) ....about to play");
        this.calculateAspectRatio();
        this.mMediaPlayer.start();
        this.hideProgressBar();
        if (this.mIsVideoPaused) {
            VASTLog.d(TAG, "pausing video");
            this.mMediaPlayer.pause();
        } else {
            this.startVideoProgressTimer();
        }
        VASTLog.d(TAG, "current location in video:" + this.mCurrentVideoPosition);
        if (this.mCurrentVideoPosition > 0) {
            VASTLog.d(TAG, "seeking to location:" + this.mCurrentVideoPosition);
            this.mMediaPlayer.seekTo(this.mCurrentVideoPosition);
        }
        if (!this.mIsProcessedImpressions) {
            this.processImpressions();
        }
        this.startQuartileTimer();
        this.startToolBarTimer();
        if (!this.mMediaPlayer.isPlaying() && !this.mIsVideoPaused) {
            this.mMediaPlayer.start();
        }
    }

    private void calculateAspectRatio() {
        VASTLog.d(TAG, "entered calculateAspectRatio");
        if (this.mVideoWidth == 0 || this.mVideoHeight == 0) {
            VASTLog.w(TAG, "mVideoWidth or mVideoHeight is 0, skipping calculateAspectRatio");
            return;
        }
        VASTLog.d(TAG, "calculating aspect ratio");
        double widthRatio = 1.0 * (double)this.mScreenWidth / (double)this.mVideoWidth;
        double heightRatio = 1.0 * (double)this.mScreenHeight / (double)this.mVideoHeight;
        double scale = Math.min(widthRatio, heightRatio);
        int surfaceWidth = (int)(scale * (double)this.mVideoWidth);
        int surfaceHeight = (int)(scale * (double)this.mVideoHeight);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(surfaceWidth, surfaceHeight);
        params.addRule(13);
        this.mSurfaceView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mSurfaceHolder.setFixedSize(surfaceWidth, surfaceHeight);
        VASTLog.d(TAG, " screen size: " + this.mScreenWidth + "x" + this.mScreenHeight);
        VASTLog.d(TAG, " video size:  " + this.mVideoWidth + "x" + this.mVideoHeight);
        VASTLog.d(TAG, " widthRatio:   " + widthRatio);
        VASTLog.d(TAG, " heightRatio:   " + heightRatio);
        VASTLog.d(TAG, "surface size: " + surfaceWidth + "x" + surfaceHeight);
    }

    private void cleanActivityUp() {
        this.cleanUpMediaPlayer();
        this.stopQuartileTimer();
        this.stopVideoProgressTimer();
        this.stopToolBarTimer();
    }

    private void cleanUpMediaPlayer() {
        VASTLog.d(TAG, "entered cleanUpMediaPlayer ");
        if (this.mMediaPlayer != null) {
            if (this.mMediaPlayer.isPlaying()) {
                this.mMediaPlayer.stop();
            }
            this.mMediaPlayer.setOnCompletionListener(null);
            this.mMediaPlayer.setOnErrorListener(null);
            this.mMediaPlayer.setOnPreparedListener(null);
            this.mMediaPlayer.setOnVideoSizeChangedListener(null);
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
        }
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        VASTLog.e(TAG, "entered onError -- (MediaPlayer callback)");
        this.mIsPlayBackError = true;
        VASTLog.e(TAG, "Shutting down Activity due to Media Player errors: WHAT:" + what + ": EXTRA:" + extra + ":");
        this.processErrorEvent();
        this.closeClicked();
        return true;
    }

    private void processErrorEvent() {
        VASTLog.d(TAG, "entered processErrorEvent");
        List<String> errorUrls = this.mVastModel.getErrorUrl();
        this.fireUrls(errorUrls);
    }

    public void onCompletion(MediaPlayer mediaPlayer) {
        VASTLog.d(TAG, "entered onCOMPLETION -- (MediaPlayer callback)");
        this.stopVideoProgressTimer();
        this.stopToolBarTimer();
        this.mOverlay.setVisibility(0);
        this.mPlayPauseButton.setImageDrawable(this.mPlayDrawable);
        if (!this.mIsPlayBackError && !this.mIsCompleted) {
            this.mIsCompleted = true;
            this.processEvent(TRACKING_EVENTS_TYPE.complete);
            if (VASTPlayer.listener != null) {
                VASTPlayer.listener.vastComplete();
            }
        }
    }

    private void overlayClicked() {
        this.startToolBarTimer();
    }

    private void processImpressions() {
        VASTLog.d(TAG, "entered processImpressions");
        this.mIsProcessedImpressions = true;
        List<String> impressions = this.mVastModel.getImpressions();
        this.fireUrls(impressions);
    }

    private void fireUrls(List<String> urls) {
        VASTLog.d(TAG, "entered fireUrls");
        if (urls != null) {
            for (String url : urls) {
                VASTLog.v(TAG, "\tfiring url:" + url);
                HttpTools.httpGetURL(url);
            }
        } else {
            VASTLog.d(TAG, "\turl list is null");
        }
    }

    private void startToolBarTimer() {
        VASTLog.d(TAG, "entered startToolBarTimer");
        if (this.mQuartile == 4) {
            return;
        }
        if (this.mMediaPlayer != null && this.mMediaPlayer.isPlaying()) {
            this.stopToolBarTimer();
            this.mToolBarTimer = new Timer();
            this.mToolBarTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    VASTActivity.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            VASTLog.d(TAG, "hiding buttons");
                            VASTActivity.this.mOverlay.setVisibility(8);
                        }
                    });
                }
            }, 3000L);
            this.mOverlay.setVisibility(0);
        }
        if (this.mIsVideoPaused) {
            this.activateButtons(true);
        }
    }

    private void stopToolBarTimer() {
        VASTLog.d(TAG, "entered stopToolBarTimer");
        if (this.mToolBarTimer != null) {
            this.mToolBarTimer.cancel();
            this.mToolBarTimer = null;
        }
    }

    private void startQuartileTimer() {
        VASTLog.d(TAG, "entered startQuartileTimer");
        this.stopQuartileTimer();
        if (this.mIsCompleted) {
            VASTLog.d(TAG, "ending quartileTimer becuase the video has been replayed");
            return;
        }
        final int videoDuration = this.mMediaPlayer.getDuration();
        this.mTrackingEventTimer = new Timer();
        this.mTrackingEventTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                int percentage = 0;
                try {
                    int curPos = VASTActivity.this.mMediaPlayer.getCurrentPosition();
                    if (curPos == 0) {
                        return;
                    }
                    percentage = 100 * curPos / videoDuration;
                }
                catch (Exception e) {
                    VASTLog.w(TAG, "mediaPlayer.getCurrentPosition exception: " + e.getMessage());
                    this.cancel();
                    return;
                }
                if (percentage >= 25 * VASTActivity.this.mQuartile) {
                    if (VASTActivity.this.mQuartile == 0) {
                        VASTLog.i(TAG, "Video at start: (" + percentage + "%)");
                        VASTActivity.this.processEvent(TRACKING_EVENTS_TYPE.start);
                    } else if (VASTActivity.this.mQuartile == 1) {
                        VASTLog.i(TAG, "Video at first quartile: (" + percentage + "%)");
                        VASTActivity.this.processEvent(TRACKING_EVENTS_TYPE.firstQuartile);
                    } else if (VASTActivity.this.mQuartile == 2) {
                        VASTLog.i(TAG, "Video at midpoint: (" + percentage + "%)");
                        VASTActivity.this.processEvent(TRACKING_EVENTS_TYPE.midpoint);
                    } else if (VASTActivity.this.mQuartile == 3) {
                        VASTLog.i(TAG, "Video at third quartile: (" + percentage + "%)");
                        VASTActivity.this.processEvent(TRACKING_EVENTS_TYPE.thirdQuartile);
                        VASTActivity.this.stopQuartileTimer();
                    }
                    VASTActivity.this.mQuartile++;
                }
            }
        }, 0L, 250L);
    }

    private void stopQuartileTimer() {
        if (this.mTrackingEventTimer != null) {
            this.mTrackingEventTimer.cancel();
            this.mTrackingEventTimer = null;
        }
    }

    private void startVideoProgressTimer() {
        VASTLog.d(TAG, "entered startVideoProgressTimer");
        this.mStartVideoProgressTimer = new Timer();
        this.mVideoProgressTracker = new LinkedList();
        this.mStartVideoProgressTimer.schedule(new TimerTask(){
            int maxAmountInList = 19;

            @Override
            public void run() {
                if (VASTActivity.this.mMediaPlayer == null) {
                    return;
                }
                if (VASTActivity.this.mVideoProgressTracker.size() == this.maxAmountInList) {
                    int firstPosition = (Integer)VASTActivity.this.mVideoProgressTracker.getFirst();
                    int lastPosition = (Integer)VASTActivity.this.mVideoProgressTracker.getLast();
                    if (lastPosition > firstPosition) {
                        VASTLog.v(TAG, "video progressing (position:" + lastPosition + ")");
                        VASTActivity.this.mVideoProgressTracker.removeFirst();
                    } else {
                        VASTLog.e(TAG, "detected video hang");
                        VASTActivity.this.mIsPlayBackError = true;
                        VASTActivity.this.stopVideoProgressTimer();
                        VASTActivity.this.processErrorEvent();
                        VASTActivity.this.closeClicked();
                        VASTActivity.this.finishVAST();
                    }
                }
                try {
                    int curPos = VASTActivity.this.mMediaPlayer.getCurrentPosition();
                    VASTActivity.this.mVideoProgressTracker.addLast(curPos);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, 0L, 250L);
    }

    private void stopVideoProgressTimer() {
        VASTLog.d(TAG, "entered stopVideoProgressTimer");
        if (this.mStartVideoProgressTimer != null) {
            this.mStartVideoProgressTimer.cancel();
        }
    }

    private void processEvent(TRACKING_EVENTS_TYPE eventName) {
        VASTLog.i(TAG, "entered Processing Event: " + (Object)((Object)eventName));
        List<String> urls = this.mTrackingEventMap.get((Object)eventName);
        this.fireUrls(urls);
    }

    private void finishVAST() {
        VASTPlayer.listener.vastDismiss();
        this.finish();
    }
}

