/*
 * Decompiled with CFR 0.152.
 */
package eanative.android.ad;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.TextView;
import com.android.volley.VolleySingleton;
import com.android.volley.toolbox.ImageLoader;
import com.android.volley.toolbox.VolleyImageView;
import eanative.android.ad.AdData;
import eanative.android.events.EANativeAdListener;
import eanative.android.events.EANativeEvent;
import eanative.android.events.EANativeEventListener;
import eanative.android.events.EventDispatcher;
import eanative.android.util.Logger;
import java.util.ArrayList;

public class EANativeAdViewBinder {
    private final Context context;
    private final int layoutId;

    public EANativeAdViewBinder(Context context, int layoutId) {
        this.context = context;
        this.layoutId = layoutId;
    }

    public View createView(View convertView, ViewGroup parent, final EANativeAdListener clickListener) {
        View view = convertView;
        if (view == null || !(view.getTag() instanceof AdViewHolder)) {
            view = LayoutInflater.from((Context)this.context).inflate(this.layoutId, parent, false);
            AdViewHolder holder = new AdViewHolder(view, this.context);
            holder.registerEventListener(EANativeEvent.AD_CLICKED, new EANativeEventListener(){

                @Override
                public void handleMessage(String event, Object message) {
                    clickListener.adClicked(message);
                }
            });
            holder.registerEventListener(EANativeEvent.BRAND_CLICKED, new EANativeEventListener(){

                @Override
                public void handleMessage(String event, Object message) {
                    clickListener.brandClicked(message);
                }
            });
            view.setOnClickListener(null);
            view.setTag((Object)holder);
        }
        return view;
    }

    public void clear(View view) {
        AdViewHolder holder = (AdViewHolder)view.getTag();
        if (holder != null) {
            holder.clear();
        }
    }

    public void bindAdData(View view, AdData adData, boolean isVideoTeaser) {
        Object tag = view.getTag();
        AdViewHolder holder = (AdViewHolder)tag;
        holder.setData(adData);
        holder.displayAsVideoTeaser(isVideoTeaser);
    }

    static class ImageBinder
    implements BaseBinder {
        private final ImageView imageView;
        private int targetId;
        private String tagName;
        private AdData adData;
        private ImageLoader imageLoader;
        private Handler requestHandler;

        ImageBinder(ImageView imageView, String tagName, ImageLoader imageLoader) {
            this.imageView = imageView;
            this.tagName = tagName;
            this.imageLoader = imageLoader;
        }

        ImageBinder bindTo(int targetId) {
            this.targetId = targetId;
            return this;
        }

        @Override
        public void setData(AdData adData) {
            this.adData = adData;
            if (this.imageView == null) {
                return;
            }
            ViewTreeObserver vto = this.imageView.getViewTreeObserver();
            vto.addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    ImageBinder.this.imageView.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    ImageBinder.this.loadImage(false);
                    return true;
                }
            });
        }

        protected void loadImage(Boolean doResize) {
            String imageURL = this.adData.getAdImage(this.tagName, this.imageView.getMeasuredWidth(), this.imageView.getMeasuredHeight(), doResize);
            VolleyImageView.ResponseObserver listener = null;
            if (!doResize.booleanValue()) {
                listener = new VolleyImageView.ResponseObserver(){

                    @Override
                    public void onError() {
                        if (ImageBinder.this.requestHandler == null) {
                            ImageBinder.this.requestHandler = new Handler();
                        }
                        ImageBinder.this.requestHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                ImageBinder.this.loadImage(true);
                            }
                        });
                    }

                    @Override
                    public void onSuccess() {
                    }
                };
            }
            if (this.imageView instanceof VolleyImageView) {
                ((VolleyImageView)this.imageView).setResponseObserver(listener);
                ((VolleyImageView)this.imageView).setImageUrl(imageURL, this.imageLoader);
            } else {
                Logger.warn("You have to use  VolleyImageView for view: %s", this.tagName);
                this.imageView.setImageURI(Uri.parse((String)imageURL));
            }
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public void clear() {
            if (this.requestHandler != null) {
                this.requestHandler.removeMessages(0);
            }
        }
    }

    static class TextBinder
    implements BaseBinder {
        private final TextView textView;
        private String tagName;
        private int targetId;

        TextBinder(TextView textView, String tagName) {
            this.textView = textView;
            this.tagName = tagName;
        }

        TextBinder bindTo(int targetId) {
            this.targetId = targetId;
            return this;
        }

        @Override
        public void setData(AdData adData) {
            if (this.textView == null) {
                return;
            }
            String tagValue = adData.getAdTag(this.tagName);
            this.textView.setText((CharSequence)tagValue);
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public void clear() {
        }
    }

    static interface BaseBinder {
        public void setData(AdData var1);

        public int getType();

        public void clear();
    }

    static class AdViewHolder
    extends EventDispatcher {
        private final ArrayList<BaseBinder> binders;
        private final Context context;
        private ImageLoader imageLoader;
        private AdClickListener adClickListener;
        private BrandClickListener brandClickListener;
        private View rootView;
        private AdData adData;

        AdViewHolder(View rootView, Context context) {
            this.context = context;
            this.rootView = rootView;
            this.adClickListener = new AdClickListener();
            this.brandClickListener = new BrandClickListener();
            this.binders = new ArrayList();
            this.imageLoader = VolleySingleton.getInstance(this.context).getImageLoader();
            ViewGroup adContainer = (ViewGroup)rootView;
            if (adContainer != null) {
                ArrayList<View> views = AdViewHolder.getAllViewsByTag(adContainer, "eanative_tag");
                for (int i = 0; i < views.size(); ++i) {
                    View tagView = views.get(i);
                    String tagName = (String)tagView.getTag();
                    tagName = tagName.substring(13);
                    BaseBinder binder = null;
                    if (tagView instanceof TextView) {
                        binder = this.createTextBinder((TextView)tagView, tagView.getId(), tagName);
                    } else if (tagView instanceof ImageView) {
                        binder = this.createImageBinder((ImageView)tagView, tagView.getId(), tagName, this.imageLoader);
                    }
                    if (binder != null) {
                        this.binders.add(binder);
                    }
                    if (!tagView.isClickable()) continue;
                    if (tagName.equals("brand_name") || tagName.equals("brand_logo")) {
                        tagView.setOnClickListener((View.OnClickListener)this.brandClickListener);
                        continue;
                    }
                    tagView.setOnClickListener((View.OnClickListener)this.adClickListener);
                }
            }
        }

        public static ArrayList<View> getAllViewsByTag(ViewGroup root, String tag) {
            ArrayList<View> views = new ArrayList<View>();
            int childCount = root.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                String tagObj;
                View child = root.getChildAt(i);
                if (child instanceof ViewGroup) {
                    views.addAll(AdViewHolder.getAllViewsByTag((ViewGroup)child, tag));
                }
                if ((tagObj = (String)child.getTag()) == null || tagObj.indexOf(tag) == -1) continue;
                views.add(child);
            }
            return views;
        }

        private TextBinder createTextBinder(TextView textView, int id, String tagName) {
            TextBinder binder = new TextBinder(textView, tagName);
            return binder.bindTo(id);
        }

        private ImageBinder createImageBinder(ImageView imageView, int id, String tagName, ImageLoader imageLoader) {
            ImageBinder binder = new ImageBinder(imageView, tagName, imageLoader);
            return binder.bindTo(id);
        }

        public void clear() {
            if (this.binders != null) {
                for (BaseBinder binder : this.binders) {
                    binder.clear();
                }
            }
        }

        public void displayAsVideoTeaser(boolean isVideoTeaser) {
            ArrayList<View> views = AdViewHolder.getAllViewsByTag((ViewGroup)this.rootView, "eanative_video_teaser_play_overlay");
            for (int i = 0; i < views.size(); ++i) {
                View tagView = views.get(i);
                tagView.setVisibility(isVideoTeaser ? 0 : 8);
            }
        }

        public void setData(AdData data) {
            if (this.adData != data) {
                this.adData = data;
                for (BaseBinder binder : this.binders) {
                    binder.setData(data);
                }
            }
        }

        private final class BrandClickListener
        implements View.OnClickListener {
            private BrandClickListener() {
            }

            public void onClick(View view) {
                AdViewHolder.this.dispatchEvent(EANativeEvent.BRAND_CLICKED, AdViewHolder.this.rootView);
            }
        }

        private final class AdClickListener
        implements View.OnClickListener {
            private AdClickListener() {
            }

            public void onClick(View view) {
                AdViewHolder.this.dispatchEvent(EANativeEvent.AD_CLICKED, AdViewHolder.this.rootView);
            }
        }
    }
}

