/*
 * Decompiled with CFR 0.152.
 */
package eanative.android.ad;

import android.util.Base64;
import eanative.android.model.EANativePlacementConfig;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AdData {
    public static final int CLICK_TRACK = 1;
    public static final int EXPAND_TRACK = 2;
    public static final String[] IMAGES_PRIORITY = new String[]{"image_large_landscape", "image_landscape", "image_square", "image_portrait"};
    private String id;
    private String image_cdn_url;
    private String image_resize_url;
    private String contentURL;
    private String tracking_url;
    private JSONObject data;
    private JSONObject ad;
    private JSONObject adTags;
    private JSONObject config;
    private JSONObject user;
    private JSONObject adnxs;
    private EANativePlacementConfig placementConfig;
    private String clickTag;

    public AdData(JSONObject data) {
        this.data = data;
        try {
            this.contentURL = this.data.getString("link");
            this.config = this.data.getJSONObject("config");
            this.user = this.data.getJSONObject("user");
            this.image_cdn_url = this.config.getString("image_cdn_url");
            this.image_resize_url = this.config.getString("image_resize_url");
            this.tracking_url = this.config.getString("tracking_url");
            this.clickTag = this.config.getString("clickTag");
            this.ad = this.data.getJSONObject("ad").getJSONObject("settings");
            this.adTags = this.ad.getJSONObject("tags");
            this.adnxs = this.config.getJSONObject("adnxs");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void setPlacementConfig(EANativePlacementConfig placementConfig) {
        this.placementConfig = placementConfig;
    }

    public String getAdImage(String imageName, int w, int h, Boolean resizing) {
        String url = resizing != false ? this.image_resize_url : this.image_cdn_url;
        String imageHash = "";
        imageHash = this.getAdTag(imageName);
        if ((imageHash = imageHash.trim()).length() == 0) {
            List<String> images = Arrays.asList(IMAGES_PRIORITY);
            int imageIndex = images.indexOf(imageName);
            if (imageIndex != -1) {
                int imageLength = images.size();
                for (int i = imageIndex; i < imageLength; ++i) {
                    imageHash = this.getAdTag(images.get(i));
                    if ((imageHash = imageHash.trim()).length() != 0) break;
                }
            }
            if (imageHash.length() == 0) {
                return "";
            }
        }
        if (url != "") {
            String scaleMode = "scalecrop";
            if (this.placementConfig != null && this.placementConfig.imagesScaleMode != null) {
                scaleMode = this.placementConfig.imagesScaleMode.getScaleMode(imageName);
            }
            if (scaleMode.equals("scaleh")) {
                w = 0;
            }
            url = url.replaceAll("\\{image_hash\\}", imageHash).replaceAll("\\{wxh\\}", w + "x" + h).replaceAll("\\{scalemode\\}", scaleMode);
        }
        return url;
    }

    public String getAdTag(String tagName) {
        String tagValue = "";
        if (this.adTags != null) {
            try {
                JSONArray tagArray = this.adTags.getJSONArray(tagName);
                if (tagValue != null) {
                    tagValue = tagArray.get(0).toString();
                }
            }
            catch (JSONException e) {
                try {
                    tagValue = this.adTags.getString(tagName);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
        }
        return tagValue;
    }

    public String getTrackEvent(int type) {
        String url = this.tracking_url;
        JSONObject trackData = new JSONObject();
        JSONObject performance = null;
        try {
            performance = this.data.getJSONObject("performance");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            trackData.put("h", this.user.get("views_hash"));
            trackData.put("uid", this.user.get("uid"));
            trackData.put("ft", 3);
            trackData.put("ch", this.ad.get("ah"));
            trackData.put("pid", this.data.get("pid"));
            if (performance != null) {
                trackData.put("performance", (Object)performance);
            }
            JSONObject events = new JSONObject();
            JSONArray eventType = new JSONArray();
            JSONObject eventData = new JSONObject();
            eventData.put("es", 100);
            eventData.put("a", 1);
            eventType.put((Object)eventData);
            events.put("ev", (Object)eventType);
            trackData.put("type", (Object)events);
            if (this.adnxs != null) {
                Iterator iterator = this.adnxs.keys();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    try {
                        Object value = this.adnxs.get(key);
                        trackData.put(key, value);
                    }
                    catch (JSONException jSONException) {}
                }
            }
        }
        catch (JSONException events) {
            // empty catch block
        }
        String trackDataString = trackData.toString();
        byte[] trackDataByte = null;
        try {
            trackDataByte = trackDataString.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException eventData) {
            // empty catch block
        }
        String trk = Base64.encodeToString((byte[])trackDataByte, (int)10);
        url = url.replaceAll("\\{base64_encoded_data\\}", trk);
        return url;
    }

    public String getBrandLink() {
        String brand_url = this.getEncoded(this.getAdTag("brand_url"));
        if (brand_url != "") {
            return this.clickTag + brand_url;
        }
        return "";
    }

    public String getContentLink() {
        if (this.clickTag.length() > 0) {
            return this.clickTag + this.getEncoded(this.contentURL);
        }
        return this.contentURL;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.data.toString();
    }

    protected String getEncoded(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }
}

