/*
 * Decompiled with CFR 0.152.
 */
package eanative.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.scriptedpapers.mediabutton.MaterialPlayPauseButton;
import eanative.android.R;
import eanative.android.util.Logger;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.nexage.sourcekit.util.HttpTools;
import org.nexage.sourcekit.vast.VASTPlayer;
import org.nexage.sourcekit.vast.model.TRACKING_EVENTS_TYPE;
import org.nexage.sourcekit.vast.model.VASTModel;

public class VastTeaserActivity
extends Activity
implements MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener,
SurfaceHolder.Callback {
    private static String TAG = "VASTActivity";
    private static final long TOOLBAR_HIDE_DELAY = 3000L;
    private static final long QUARTILE_TIMER_INTERVAL = 250L;
    private static final long VIDEO_PROGRESS_TIMER_INTERVAL = 250L;
    private Timer mToolBarTimer;
    private Timer mTrackingEventTimer;
    private Timer mStartVideoProgressTimer;
    private Handler durationHandler = new Handler();
    private LinkedList<Integer> mVideoProgressTracker = null;
    private final int mMaxProgressTrackingPoints = 20;
    private Handler mHandler;
    private VASTModel mVastModel = null;
    private HashMap<TRACKING_EVENTS_TYPE, List<String>> mTrackingEventMap;
    private MediaPlayer mMediaPlayer;
    private SurfaceView mSurfaceView;
    private SurfaceHolder mSurfaceHolder;
    private RelativeLayout mOverlay;
    private RelativeLayout mButtonsView;
    private RelativeLayout mRootLayout;
    private TextView mInfoButton;
    private TextView mCountdown;
    private MaterialPlayPauseButton mPlayPauseButton;
    private ImageButton mCloseButton;
    private int mVideoHeight;
    private int mVideoWidth;
    private int mScreenWidth;
    private int mScreenHeight;
    private boolean mIsVideoPaused = false;
    private boolean mIsPlayBackError = false;
    private boolean mIsProcessedImpressions = false;
    private boolean mIsCompleted = false;
    private boolean mIsToolbarVisible = true;
    private boolean mDoNotConsiderTouchUp = false;
    private int mCurrentVideoPosition;
    private int mQuartile = 0;
    private ProgressBar mProgressBar;
    private String elapsedTimeText;
    private Runnable updateRemainingTime = new Runnable(){

        @Override
        public void run() {
            if (VastTeaserActivity.this.mMediaPlayer != null) {
                int mediaDuration = VastTeaserActivity.this.mMediaPlayer.getDuration();
                int mediaPosition = VastTeaserActivity.this.mMediaPlayer.getCurrentPosition();
                int duration = mediaDuration / 1000 - mediaPosition / 1000;
                int minutes = duration / 60;
                int seconds = duration % 60;
                String countdownText = VastTeaserActivity.this.elapsedTimeText.replaceAll("\\{m\\}", String.valueOf(minutes)).replaceAll("\\{s\\}", String.valueOf(seconds));
                VastTeaserActivity.this.mCountdown.setText((CharSequence)countdownText);
                VastTeaserActivity.this.durationHandler.postDelayed((Runnable)this, 100L);
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        int currentOrientation = this.getResources().getConfiguration().orientation;
        Logger.info("currentOrientation:" + currentOrientation, new Object[0]);
        if (currentOrientation != 2) {
            Logger.info("Orientation is not landscape.....forcing landscape", new Object[0]);
            this.setRequestedOrientation(0);
        }
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        this.setContentView(R.layout.activity_vast_teaser);
        Intent i = this.getIntent();
        this.mVastModel = (VASTModel)i.getSerializableExtra("eanative.android.vast.player.vastModel");
        this.elapsedTimeText = this.getIntent().getStringExtra("eanative.android.placement.ett");
        if (this.mVastModel == null) {
            Logger.info("vastModel is null. Stopping activity.", new Object[0]);
            this.finishVAST();
        } else {
            this.mHandler = new Handler();
            this.mTrackingEventMap = this.mVastModel.getTrackingUrls();
            this.createUIComponents();
            this.hideSystemUI();
        }
    }

    protected void onStart() {
        Logger.info("entered onStart --(life cycle event)", new Object[0]);
        super.onStart();
    }

    protected void onResume() {
        Logger.info("entered on onResume --(life cycle event)", new Object[0]);
        super.onResume();
    }

    protected void onStop() {
        Logger.info("entered on onStop --(life cycle event)", new Object[0]);
        super.onStop();
    }

    protected void onRestart() {
        Logger.info("entered on onRestart --(life cycle event)", new Object[0]);
        super.onRestart();
        this.createMediaPlayer();
    }

    protected void onPause() {
        Logger.info("entered on onPause --(life cycle event)", new Object[0]);
        super.onPause();
        if (this.mMediaPlayer != null) {
            this.mCurrentVideoPosition = this.mMediaPlayer.getCurrentPosition();
        }
        this.cleanActivityUp();
    }

    protected void onDestroy() {
        Logger.info("entered on onDestroy --(life cycle event)", new Object[0]);
        super.onDestroy();
    }

    public void onSaveInstanceState(Bundle savedInstanceState) {
        Logger.info("entered onSaveInstanceState ", new Object[0]);
        super.onSaveInstanceState(savedInstanceState);
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        Logger.info("in onRestoreInstanceState", new Object[0]);
        super.onRestoreInstanceState(savedInstanceState);
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        if (hasFocus) {
            this.hideSystemUI();
        }
    }

    private void hideSystemUI() {
        this.getWindow().getDecorView().setSystemUiVisibility(7942);
    }

    private void showSystemUI() {
        this.getWindow().getDecorView().setSystemUiVisibility(1792);
    }

    private void createUIComponents() {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        this.mRootLayout = (RelativeLayout)this.findViewById(R.id.mRootLayout);
        this.createSurface();
        this.createMediaPlayer();
        this.createOverlay();
        this.createPlayPauseButton();
        this.createInfoButton();
        this.setContentView((View)this.mRootLayout);
        this.createCloseButton();
        this.createProgressBar();
    }

    private void createProgressBar() {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
        params.addRule(13);
        this.mProgressBar = new ProgressBar((Context)this);
        this.mProgressBar.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mRootLayout.addView((View)this.mProgressBar);
        this.mProgressBar.setVisibility(8);
    }

    private void showProgressBar() {
        this.mProgressBar.setVisibility(0);
    }

    private void hideProgressBar() {
        this.mProgressBar.setVisibility(8);
    }

    private void createSurface() {
        this.mSurfaceView = (SurfaceView)this.findViewById(R.id.mSurfaceView);
        this.mSurfaceHolder = this.mSurfaceView.getHolder();
        this.mSurfaceHolder.addCallback((SurfaceHolder.Callback)this);
    }

    private void createMediaPlayer() {
        this.mMediaPlayer = new MediaPlayer();
        this.mMediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
        this.mMediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this);
        this.mMediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
        this.mMediaPlayer.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
        this.mMediaPlayer.setAudioStreamType(3);
    }

    private void createCloseButton() {
        this.mCloseButton = (ImageButton)this.findViewById(R.id.mCloseButton);
        this.mCloseButton.setImageResource(R.drawable.arrow_back);
        this.mCloseButton.setVisibility(0);
        this.mCloseButton.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getActionMasked() == 1) {
                    VastTeaserActivity.this.closeClicked();
                }
                return true;
            }
        });
        this.mCloseButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VastTeaserActivity.this.closeClicked();
            }
        });
    }

    private void createOverlay() {
        this.mOverlay = (RelativeLayout)this.findViewById(R.id.mOverlay);
        this.mOverlay.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getActionMasked() == 0) {
                    VastTeaserActivity.this.mDoNotConsiderTouchUp = !VastTeaserActivity.this.mIsToolbarVisible;
                    if (!VastTeaserActivity.this.mIsToolbarVisible) {
                        VastTeaserActivity.this.showToolBar();
                    }
                } else if (!VastTeaserActivity.this.mDoNotConsiderTouchUp) {
                    VastTeaserActivity.this.hideToolBar();
                }
                return true;
            }
        });
        this.mButtonsView = (RelativeLayout)this.findViewById(R.id.mButtonsView);
    }

    private void createInfoButton() {
        String callToActionText = this.getIntent().getStringExtra("eanative.android.placement.cta");
        String clickThroughUrl = this.mVastModel.getVideoClicks().getClickThrough();
        this.mInfoButton = (TextView)this.findViewById(R.id.mInfoButton);
        this.mInfoButton.setText((CharSequence)callToActionText);
        if (clickThroughUrl != null && clickThroughUrl.length() > 0) {
            this.mInfoButton.setVisibility(0);
            this.mInfoButton.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    if (event.getActionMasked() == 1) {
                        VastTeaserActivity.this.infoClicked();
                    }
                    return true;
                }
            });
            this.mInfoButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    VastTeaserActivity.this.infoClicked();
                }
            });
        } else {
            this.mInfoButton.setVisibility(8);
        }
        this.mCountdown = (TextView)this.findViewById(R.id.mCountdown);
    }

    private void createPlayPauseButton() {
        this.mPlayPauseButton = (MaterialPlayPauseButton)this.findViewById(R.id.mPlayPauseButton);
        this.mPlayPauseButton.setToPause();
        this.mPlayPauseButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VastTeaserActivity.this.playPauseButtonClicked();
            }
        });
    }

    private void infoClicked() {
        Logger.info("entered infoClicked:", new Object[0]);
        this.activateButtons(false);
        boolean isPlaying = this.mMediaPlayer.isPlaying();
        if (isPlaying) {
            this.mMediaPlayer.pause();
            this.mCurrentVideoPosition = this.mMediaPlayer.getCurrentPosition();
        }
        this.processClickThroughEvent();
    }

    private void activateButtons(boolean active) {
        Logger.info("entered activateButtons:", new Object[0]);
        this.mIsToolbarVisible = active;
        if (active) {
            this.mButtonsView.animate().alpha(1.0f);
        } else {
            this.mButtonsView.animate().alpha(0.0f);
        }
    }

    private void processClickThroughEvent() {
        Logger.info("entered processClickThroughEvent:", new Object[0]);
        if (VASTPlayer.listener != null) {
            VASTPlayer.listener.vastClick();
        }
        String clickThroughUrl = this.mVastModel.getVideoClicks().getClickThrough();
        Logger.info("clickThrough url: %s", clickThroughUrl);
        List<String> urls = this.mVastModel.getVideoClicks().getClickTracking();
        this.fireUrls(urls);
        try {
            Uri uri = Uri.parse((String)clickThroughUrl);
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            ResolveInfo resolvable = this.getPackageManager().resolveActivity(intent, 32);
            if (resolvable == null) {
                Logger.info("Clickthrough error occured, uri unresolvable", new Object[0]);
                if ((double)this.mCurrentVideoPosition >= (double)this.mMediaPlayer.getCurrentPosition() * 0.99) {
                    this.mMediaPlayer.start();
                }
                this.activateButtons(true);
                return;
            }
            this.startActivity(intent);
        }
        catch (NullPointerException e) {
            Logger.info(e.getMessage(), e);
        }
    }

    private void closeClicked() {
        Logger.info("entered closeClicked()", new Object[0]);
        this.cleanActivityUp();
        if (!this.mIsPlayBackError) {
            this.processEvent(TRACKING_EVENTS_TYPE.close);
        }
        this.finishVAST();
        Logger.info("leaving closeClicked()", new Object[0]);
    }

    private void playPauseButtonClicked() {
        Logger.info("entered playPauseClicked", new Object[0]);
        if (this.mMediaPlayer == null) {
            Logger.info("mMediaPlayer is null when playPauseButton was clicked", new Object[0]);
            return;
        }
        boolean isPlaying = this.mMediaPlayer.isPlaying();
        Logger.info("isPlaying:" + isPlaying, new Object[0]);
        if (isPlaying) {
            this.processPauseSteps();
        } else if (this.mIsVideoPaused) {
            this.processPlaySteps();
            if (!this.mIsCompleted) {
                this.processEvent(TRACKING_EVENTS_TYPE.resume);
            }
        } else {
            this.processPlaySteps();
            this.mQuartile = 0;
            this.startQuartileTimer();
        }
    }

    private void processPauseSteps() {
        this.mIsVideoPaused = true;
        this.mMediaPlayer.pause();
        this.stopVideoProgressTimer();
        this.stopToolBarTimer();
        this.mPlayPauseButton.setToPlay();
        if (!this.mIsCompleted) {
            this.processEvent(TRACKING_EVENTS_TYPE.pause);
        }
    }

    private void processPlaySteps() {
        this.mIsVideoPaused = false;
        this.mMediaPlayer.start();
        this.mPlayPauseButton.setToPause();
        this.startToolBarTimer();
        this.startVideoProgressTimer();
    }

    public void onBackPressed() {
        Logger.info("entered onBackPressed", new Object[0]);
        this.closeClicked();
    }

    public void surfaceCreated(SurfaceHolder holder) {
        Logger.info("surfaceCreated -- (SurfaceHolder callback)", new Object[0]);
        try {
            if (this.mMediaPlayer == null) {
                this.createMediaPlayer();
            }
            this.showProgressBar();
            this.mMediaPlayer.setDisplay(this.mSurfaceHolder);
            String url = this.mVastModel.getPickedMediaFileURL();
            Logger.info("URL for media file:" + url, new Object[0]);
            this.mMediaPlayer.setDataSource(url);
            this.mMediaPlayer.prepareAsync();
        }
        catch (Exception e) {
            Logger.info(e.getMessage(), e);
        }
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int arg1, int arg2, int arg3) {
        Logger.info("entered surfaceChanged -- (SurfaceHolder callback)", new Object[0]);
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        Logger.info("entered surfaceDestroyed -- (SurfaceHolder callback)", new Object[0]);
        this.cleanUpMediaPlayer();
    }

    public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
        Logger.info("entered onVideoSizeChanged -- (MediaPlayer callback)", new Object[0]);
        this.mVideoWidth = width;
        this.mVideoHeight = height;
        Logger.info("video size: " + this.mVideoWidth + "x" + this.mVideoHeight, new Object[0]);
    }

    public void onPrepared(MediaPlayer mp) {
        Logger.info("entered onPrepared called --(MediaPlayer callback) ....about to play", new Object[0]);
        this.calculateAspectRatio();
        this.mMediaPlayer.start();
        this.hideProgressBar();
        if (this.mIsVideoPaused) {
            Logger.info("pausing video", new Object[0]);
            this.mMediaPlayer.pause();
            this.mPlayPauseButton.setToPlay();
        } else {
            this.startVideoProgressTimer();
            this.mPlayPauseButton.setToPause();
        }
        Logger.info("current location in video:" + this.mCurrentVideoPosition, new Object[0]);
        if (this.mCurrentVideoPosition > 0) {
            Logger.info("seeking to location:" + this.mCurrentVideoPosition, new Object[0]);
            this.mMediaPlayer.seekTo(this.mCurrentVideoPosition);
        }
        if (!this.mIsProcessedImpressions) {
            this.processImpressions();
        }
        this.startQuartileTimer();
        this.startToolBarTimer();
        if (!this.mMediaPlayer.isPlaying() && !this.mIsVideoPaused) {
            this.mMediaPlayer.start();
        }
        this.mPlayPauseButton.setVisibility(0);
        this.durationHandler.postDelayed(this.updateRemainingTime, 100L);
    }

    private void calculateAspectRatio() {
        Logger.info("entered calculateAspectRatio", new Object[0]);
        if (this.mVideoWidth == 0 || this.mVideoHeight == 0) {
            Logger.info("mVideoWidth or mVideoHeight is 0, skipping calculateAspectRatio", new Object[0]);
            return;
        }
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        this.mScreenWidth = displayMetrics.widthPixels;
        this.mScreenHeight = displayMetrics.heightPixels;
        Logger.info("calculating aspect ratio", new Object[0]);
        double widthRatio = 1.0 * (double)this.mScreenWidth / (double)this.mVideoWidth;
        double heightRatio = 1.0 * (double)this.mScreenHeight / (double)this.mVideoHeight;
        double scale = Math.min(widthRatio, heightRatio);
        int surfaceWidth = (int)(scale * (double)this.mVideoWidth);
        int surfaceHeight = (int)(scale * (double)this.mVideoHeight);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(surfaceWidth, surfaceHeight);
        params.addRule(13);
        this.mSurfaceView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mSurfaceHolder.setFixedSize(surfaceWidth, surfaceHeight);
        Logger.info(" screen size: " + this.mScreenWidth + "x" + this.mScreenHeight, new Object[0]);
        Logger.info(" video size:  " + this.mVideoWidth + "x" + this.mVideoHeight, new Object[0]);
        Logger.info(" widthRatio:   " + widthRatio, new Object[0]);
        Logger.info(" heightRatio:   " + heightRatio, new Object[0]);
        Logger.info("surface size: " + surfaceWidth + "x" + surfaceHeight, new Object[0]);
    }

    private void cleanActivityUp() {
        this.cleanUpMediaPlayer();
        this.stopQuartileTimer();
        this.stopVideoProgressTimer();
        this.stopToolBarTimer();
        this.durationHandler.removeCallbacks(this.updateRemainingTime);
    }

    private void cleanUpMediaPlayer() {
        Logger.info("entered cleanUpMediaPlayer ", new Object[0]);
        if (this.mMediaPlayer != null) {
            if (this.mMediaPlayer.isPlaying()) {
                this.mMediaPlayer.stop();
            }
            this.mMediaPlayer.setOnCompletionListener(null);
            this.mMediaPlayer.setOnErrorListener(null);
            this.mMediaPlayer.setOnPreparedListener(null);
            this.mMediaPlayer.setOnVideoSizeChangedListener(null);
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
        }
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        Logger.info("entered onError -- (MediaPlayer callback)", new Object[0]);
        this.mIsPlayBackError = true;
        Logger.info("Shutting down Activity due to Media Player errors: WHAT:" + what + ": EXTRA:" + extra + ":", new Object[0]);
        this.processErrorEvent();
        this.closeClicked();
        return true;
    }

    private void processErrorEvent() {
        Logger.info("entered processErrorEvent", new Object[0]);
        List<String> errorUrls = this.mVastModel.getErrorUrl();
        this.fireUrls(errorUrls);
    }

    public void onCompletion(MediaPlayer mediaPlayer) {
        Logger.info("entered onCOMPLETION -- (MediaPlayer callback)", new Object[0]);
        this.stopVideoProgressTimer();
        this.stopToolBarTimer();
        this.mOverlay.setVisibility(0);
        this.mPlayPauseButton.setToPlay();
        if (!this.mIsPlayBackError && !this.mIsCompleted) {
            this.mIsCompleted = true;
            this.processEvent(TRACKING_EVENTS_TYPE.complete);
            if (VASTPlayer.listener != null) {
                VASTPlayer.listener.vastComplete();
            }
        }
    }

    private void overlayClicked() {
        this.activateButtons(true);
        this.startToolBarTimer();
        Logger.info("overlay clicked", new Object[0]);
    }

    private void processImpressions() {
        Logger.info("entered processImpressions", new Object[0]);
        this.mIsProcessedImpressions = true;
        List<String> impressions = this.mVastModel.getImpressions();
        this.fireUrls(impressions);
    }

    private void fireUrls(List<String> urls) {
        Logger.info("entered fireUrls", new Object[0]);
        if (urls != null) {
            for (String url : urls) {
                Logger.info("\tfiring url:%s", url);
                HttpTools.httpGetURL(url);
            }
        } else {
            Logger.info("\turl list is null", new Object[0]);
        }
    }

    private void showToolBar() {
        this.activateButtons(true);
        this.startToolBarTimer();
    }

    private void hideToolBar() {
        this.activateButtons(false);
    }

    private void startToolBarTimer() {
        Logger.info("entered startToolBarTimer", new Object[0]);
        if (this.mQuartile == 4) {
            return;
        }
        if (this.mIsToolbarVisible && this.mMediaPlayer != null && this.mMediaPlayer.isPlaying()) {
            this.stopToolBarTimer();
            this.mToolBarTimer = new Timer();
            this.mToolBarTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    VastTeaserActivity.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            Logger.info("hiding buttons", new Object[0]);
                            VastTeaserActivity.this.activateButtons(false);
                            VastTeaserActivity.this.mIsToolbarVisible = false;
                        }
                    });
                }
            }, 3000L);
        }
        if (this.mIsVideoPaused) {
            this.activateButtons(true);
        }
    }

    private void stopToolBarTimer() {
        Logger.info("entered stopToolBarTimer", new Object[0]);
        if (this.mToolBarTimer != null) {
            this.mToolBarTimer.cancel();
            this.mToolBarTimer = null;
        }
    }

    private void startQuartileTimer() {
        Logger.info("entered startQuartileTimer", new Object[0]);
        this.stopQuartileTimer();
        if (this.mIsCompleted) {
            Logger.info("ending quartileTimer because the video has been replayed", new Object[0]);
            return;
        }
        final int videoDuration = this.mMediaPlayer.getDuration();
        this.mTrackingEventTimer = new Timer();
        this.mTrackingEventTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                int percentage = 0;
                try {
                    int curPos = VastTeaserActivity.this.mMediaPlayer.getCurrentPosition();
                    if (curPos == 0) {
                        return;
                    }
                    percentage = 100 * curPos / videoDuration;
                }
                catch (Exception e) {
                    Logger.error("mediaPlayer.getCurrentPosition exception: %s", e.getMessage());
                    this.cancel();
                    return;
                }
                if (percentage >= 25 * VastTeaserActivity.this.mQuartile) {
                    if (VastTeaserActivity.this.mQuartile == 0) {
                        Logger.info("Video at start: (%s%%)", percentage);
                        VastTeaserActivity.this.processEvent(TRACKING_EVENTS_TYPE.start);
                    } else if (VastTeaserActivity.this.mQuartile == 1) {
                        Logger.info("Video at first quartile: (%s%%)", percentage);
                        VastTeaserActivity.this.processEvent(TRACKING_EVENTS_TYPE.firstQuartile);
                    } else if (VastTeaserActivity.this.mQuartile == 2) {
                        Logger.info("Video at midpoint: (%s%%)", percentage);
                        VastTeaserActivity.this.processEvent(TRACKING_EVENTS_TYPE.midpoint);
                    } else if (VastTeaserActivity.this.mQuartile == 3) {
                        Logger.info("Video at third quartile: (%s%%)", percentage);
                        VastTeaserActivity.this.processEvent(TRACKING_EVENTS_TYPE.thirdQuartile);
                        VastTeaserActivity.this.stopQuartileTimer();
                    }
                    VastTeaserActivity.this.mQuartile++;
                }
            }
        }, 0L, 250L);
    }

    private void stopQuartileTimer() {
        if (this.mTrackingEventTimer != null) {
            this.mTrackingEventTimer.cancel();
            this.mTrackingEventTimer = null;
        }
    }

    private void startVideoProgressTimer() {
        Logger.info("entered startVideoProgressTimer", new Object[0]);
        this.mStartVideoProgressTimer = new Timer();
        this.mVideoProgressTracker = new LinkedList();
        this.mStartVideoProgressTimer.schedule(new TimerTask(){
            int maxAmountInList = 19;

            @Override
            public void run() {
                if (VastTeaserActivity.this.mMediaPlayer == null) {
                    return;
                }
                if (VastTeaserActivity.this.mVideoProgressTracker.size() == this.maxAmountInList) {
                    int firstPosition = (Integer)VastTeaserActivity.this.mVideoProgressTracker.getFirst();
                    int lastPosition = (Integer)VastTeaserActivity.this.mVideoProgressTracker.getLast();
                    if (lastPosition > firstPosition) {
                        Logger.verbose("video progressing (position:" + lastPosition + ")", new Object[0]);
                        VastTeaserActivity.this.mVideoProgressTracker.removeFirst();
                    } else {
                        Logger.info("detected video hang", new Object[0]);
                        VastTeaserActivity.this.mIsPlayBackError = true;
                        VastTeaserActivity.this.stopVideoProgressTimer();
                        VastTeaserActivity.this.processErrorEvent();
                        VastTeaserActivity.this.closeClicked();
                        VastTeaserActivity.this.finishVAST();
                    }
                }
                try {
                    int curPos = VastTeaserActivity.this.mMediaPlayer.getCurrentPosition();
                    VastTeaserActivity.this.mVideoProgressTracker.addLast(curPos);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, 0L, 250L);
    }

    private void stopVideoProgressTimer() {
        Logger.info("entered stopVideoProgressTimer", new Object[0]);
        if (this.mStartVideoProgressTimer != null) {
            this.mStartVideoProgressTimer.cancel();
        }
    }

    private void processEvent(TRACKING_EVENTS_TYPE eventName) {
        Logger.info("entered Processing Event: " + (Object)((Object)eventName), new Object[0]);
        List<String> urls = this.mTrackingEventMap.get((Object)eventName);
        this.fireUrls(urls);
    }

    private void finishVAST() {
        VASTPlayer.listener.vastDismiss();
        this.finish();
    }
}

