package eanative.android.util;

import java.util.Locale;

import android.util.Log;

public class Logger {
	static String TAG = "EANative";
	static final boolean DEBUG = Log.isLoggable(TAG, 2);

	public static void verbose(String format, Object... args) {
		if (DEBUG) {
			Log.v(TAG, buildMessage(format, args));
		}
	}

	public static void debug(String format, Object... args) {
		if (DEBUG) {
			Log.d(TAG, buildMessage(format, args));
		}
	}

	public static void info(String format, Object... args) {
		Log.i(TAG, buildMessage(format, args));
	}

	public static void warn(String format, Object... args) {
		Log.w(TAG, buildMessage(format, args));
	}

	public static void error(String format, Object... args) {
		Log.e(TAG, buildMessage(format, args));
	}

	public static void wtf(String format, Object... args) {
		Log.wtf(TAG, buildMessage(format, args));
	}

	public static void wtf(Throwable tr, String format, Object... args) {
		Log.wtf(TAG, buildMessage(format, args), tr);
	}

	private static String buildMessage(String format, Object... args) {
		String msg = args == null ? format : String.format(Locale.US, format,
				args);
		StackTraceElement[] trace = new Throwable().fillInStackTrace()
				.getStackTrace();

		String caller = "<unknown>";
		for (int i = 2; i < trace.length; i++) {
			Class<?> clazz = trace[i].getClass();
			if (!clazz.equals(Logger.class)) {
				String callingClass = trace[i].getClassName();
				callingClass = callingClass.substring(callingClass
						.lastIndexOf('.') + 1);
				callingClass = callingClass.substring(callingClass
						.lastIndexOf('$') + 1);

				caller = callingClass + "." + trace[i].getMethodName();
				break;
			}
		}
		return String.format(Locale.US, "[%d] %s: %s",
				new Object[] { Long.valueOf(Thread.currentThread().getId()),
						caller, msg });
	}
}
