/* 
 * ***** BEGIN LICENSE BLOCK *****
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * ***** END LICENSE BLOCK ***** */

package eanative.android.events;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public  class EventDispatcher {
    
    private final Map<String, CopyOnWriteArrayList<EANativeEventListener>> mEventListeners
                  = new HashMap<String, CopyOnWriteArrayList<EANativeEventListener>>();

    public void registerEventListener(String event, EANativeEventListener listener) {
        synchronized (mEventListeners) {
            CopyOnWriteArrayList<EANativeEventListener> listeners = mEventListeners.get(event);
            if (listeners == null) {
                // create a CopyOnWriteArrayList so that we can modify it
                // concurrently with iterating through it in handleGeckoMessage.
                // Otherwise we could end up throwing a ConcurrentModificationException.
                listeners = new CopyOnWriteArrayList<EANativeEventListener>();
            } else if (listeners.contains(listener)) {
                
            }
            listeners.add(listener);
            mEventListeners.put(event, listeners);
        }
    }

    public void unregisterEventListener(String event, EANativeEventListener listener) {
        synchronized (mEventListeners) {
            CopyOnWriteArrayList<EANativeEventListener> listeners = mEventListeners.get(event);
            if (listeners == null) {
                return;
            }
            listeners.remove(listener);
            if (listeners.size() == 0) {
                mEventListeners.remove(event);
            }
        }
    }

    public String dispatchEvent(String type,Object message ) {
        try {
            
            CopyOnWriteArrayList<EANativeEventListener> listeners;
            synchronized (mEventListeners) {
                listeners = mEventListeners.get(type);
            }

            if (listeners == null)
                return "";

            for (EANativeEventListener listener : listeners) {
                listener.handleMessage(type, message);
                
            }

        } catch (Exception e) {
            
        }

        return "";
    }
}
