package eanative.android;

import eanative.android.util.Logger;
import eanative.android.util.SystemUiHider;
import eanative.android.util.VideoEnabledWebChromeClient;
import eanative.android.util.VideoEnabledWebView;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.WebView;
import android.webkit.WebViewClient;

/**
 * An example full-screen activity that shows and hides the system UI (i.e.
 * status bar and navigation/system bar) with user interaction.
 * 
 * @see eanative.android.util.SystemUiHider
 */
@SuppressWarnings("unused")
public class EANativeActivity extends Activity {
	
	private VideoEnabledWebView webView;
	private VideoEnabledWebChromeClient webChromeClient;
	private String contentURL;

	
	@SuppressLint("SetJavaScriptEnabled")
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		/*if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
		    WebView.setWebContentsDebuggingEnabled(true);
		}*/
		setContentView(R.layout.activity_eanative);

		webView = (VideoEnabledWebView) findViewById(R.id.image_view);

		// Initialize the VideoEnabledWebChromeClient and set event handlers
	    View nonVideoLayout = findViewById(R.id.nonVideoLayout); // Your own view, read class comments
	    ViewGroup videoLayout = (ViewGroup) findViewById(R.id.videoLayout); // Your own view, read class comments
	    
	    final SystemUiHider mSystemUiHider = SystemUiHider.getInstance(this, videoLayout,
	    		SystemUiHider.FLAG_HIDE_NAVIGATION);
		mSystemUiHider.setup();
		
	    webChromeClient = new VideoEnabledWebChromeClient(nonVideoLayout, videoLayout,  webView) // See all available constructors...
	    {
	        // Subscribe to standard events, such as onProgressChanged()...
	        @Override
	        public void onProgressChanged(WebView view, int progress)
	        {
	            // Your code...
	        }
	    };
	    webChromeClient.setOnToggledFullscreen(new VideoEnabledWebChromeClient.ToggledFullscreenCallback()
	    {
	        @SuppressLint("NewApi") @Override
	        public void toggledFullscreen(boolean fullscreen)
	        {
	            // Your code to handle the full-screen change, for example showing and hiding the title bar. Example:
	            if (fullscreen)
	            {
	                WindowManager.LayoutParams attrs = getWindow().getAttributes();
	                attrs.flags |= WindowManager.LayoutParams.FLAG_FULLSCREEN;
	                attrs.flags |= WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON;
	                
	                getWindow().setAttributes(attrs);
	                
	                if (Build.VERSION.SDK_INT >= 14)
	                {
	                    getWindow().getDecorView().setSystemUiVisibility(
	                    		View.SYSTEM_UI_FLAG_LAYOUT_STABLE
	                            | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION
	                            | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
	                            | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION
	                            | View.SYSTEM_UI_FLAG_FULLSCREEN
	                            | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY);
	                }
	                mSystemUiHider.hide();
	                
	            }
	            else
	            {
	                WindowManager.LayoutParams attrs = getWindow().getAttributes();
	                attrs.flags &= ~WindowManager.LayoutParams.FLAG_FULLSCREEN;
	                attrs.flags &= ~WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON;
	                getWindow().setAttributes(attrs);
	                if (Build.VERSION.SDK_INT >= 14)
	                {
	                    getWindow().getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_VISIBLE);
	                }
	                mSystemUiHider.show();
	            }

	        }
	    });
	    webView.setWebChromeClient(webChromeClient);
	    webView.setWebViewClient(new WebViewClient() {
	        public boolean shouldOverrideUrlLoading(WebView view, String url){
	            // do your handling codes here, which url is the requested url
	            // probably you need to open that url rather than redirect:
	            view.loadUrl(url);
	            return false; // then it is not handled by default action
	       }
	    });
		
		Bundle extras = getIntent().getExtras();
		contentURL = extras.getString("contentURL");

		//Logger.info("CONTENT URL: %s", contentURL);
		webView.loadUrl(contentURL);
			
	}

	@SuppressWarnings("deprecation")
	protected void onPause() {
		super.onPause();
		if (webView != null) {
			if (Build.VERSION.SDK_INT < 18) {
				   webView.clearView();
				} else {
				   webView.loadUrl("about:blank");
				}
		}
	}
	protected void onResume() {
		super.onResume();
		if (webView != null) {
			this.webView.loadUrl(this.contentURL);
		}
	}

}
