package eanative.android;



import eanative.android.ad.EANativeAdPlacer;
import eanative.android.model.EANativeListAdapter;
import eanative.android.model.EANativeServerClient;
import eanative.android.util.Logger;
import android.content.Context;
import android.widget.BaseAdapter;
public class EANative {

	private static EANativeServerClient serverClient;

	public static void initialize(Context context, String nativeAppKey)
	{
	    if (serverClient == null) {
	      synchronized (EANative.class)
	      {
	        if (serverClient == null) {
	        	serverClient = new EANativeServerClient(context.getApplicationContext());
	        }
	      }
	    }
	    serverClient.setApplicationKey(nativeAppKey);
	    serverClient.setActive(true);
	}
	/**
	 * 
	 * @param testMode - if true, the device will enter in test mode 
	 * @param deviceId
	 */
	public static void setTestMode(boolean testMode, String  deviceId){
		if(serverClient ==null){
			Logger.error("You have to call EANative.initialize method first");
			return;
		}
		serverClient.setTestDevices(testMode, deviceId);
	}
	
	public static  EANativeListAdapter createListAdapter(Context context, BaseAdapter originalAdapter){
		if(serverClient ==null){
			Logger.error("You have to call EANative.initialize method first");
			return null;
		}
		return new EANativeListAdapter(context, originalAdapter,serverClient);
	}
	public static EANativeAdPlacer createAdPlacer(Context context){
		if(serverClient ==null){
			Logger.error("You have to call EANative.initialize method first");
			return null;
		}
		return new EANativeAdPlacer(context, serverClient);
	}

}
