/*
 * Decompiled with CFR 0.152.
 */
package org.nexage.sourcekit.vast.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.nexage.sourcekit.util.VASTLog;
import org.nexage.sourcekit.util.XmlTools;
import org.nexage.sourcekit.vast.model.TRACKING_EVENTS_TYPE;
import org.nexage.sourcekit.vast.model.VASTMediaFile;
import org.nexage.sourcekit.vast.model.VideoClicks;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VASTModel
implements Serializable {
    private static String TAG = "VASTModel";
    private static final long serialVersionUID = 4318368258447283733L;
    private transient Document vastsDocument;
    private String pickedMediaFileURL = null;
    private static final String inlineLinearTrackingXPATH = "/VASTS/VAST/Ad/InLine/Creatives/Creative/Linear/TrackingEvents/Tracking";
    private static final String inlineNonLinearTrackingXPATH = "/VASTS/VAST/Ad/InLine/Creatives/Creative/NonLinearAds/TrackingEvents/Tracking";
    private static final String wrapperLinearTrackingXPATH = "/VASTS/VAST/Ad/Wrapper/Creatives/Creative/Linear/TrackingEvents/Tracking";
    private static final String wrapperNonLinearTrackingXPATH = "/VASTS/VAST/Ad/Wrapper/Creatives/Creative/NonLinearAds/TrackingEvents/Tracking";
    private static final String combinedTrackingXPATH = "/VASTS/VAST/Ad/InLine/Creatives/Creative/Linear/TrackingEvents/Tracking|/VASTS/VAST/Ad/InLine/Creatives/Creative/NonLinearAds/TrackingEvents/Tracking|/VASTS/VAST/Ad/Wrapper/Creatives/Creative/Linear/TrackingEvents/Tracking|/VASTS/VAST/Ad/Wrapper/Creatives/Creative/NonLinearAds/TrackingEvents/Tracking";
    private static final String mediaFileXPATH = "//MediaFile";
    private static final String durationXPATH = "//Duration";
    private static final String videoClicksXPATH = "//VideoClicks";
    private static final String impressionXPATH = "//Impression";
    private static final String errorUrlXPATH = "//Error";

    public VASTModel(Document vasts) {
        this.vastsDocument = vasts;
    }

    public Document getVastsDocument() {
        return this.vastsDocument;
    }

    public HashMap<TRACKING_EVENTS_TYPE, List<String>> getTrackingUrls() {
        HashMap<TRACKING_EVENTS_TYPE, List<String>> trackings;
        block6: {
            VASTLog.d(TAG, "getTrackingUrls");
            trackings = new HashMap<TRACKING_EVENTS_TYPE, List<String>>();
            XPath xpath = XPathFactory.newInstance().newXPath();
            try {
                NodeList nodes = (NodeList)xpath.evaluate(combinedTrackingXPATH, this.vastsDocument, XPathConstants.NODESET);
                TRACKING_EVENTS_TYPE key = null;
                if (nodes == null) break block6;
                for (int i = 0; i < nodes.getLength(); ++i) {
                    List<Object> tracking;
                    Node node = nodes.item(i);
                    NamedNodeMap attributes = node.getAttributes();
                    String eventName = attributes.getNamedItem("event").getNodeValue();
                    try {
                        key = TRACKING_EVENTS_TYPE.valueOf(eventName);
                    }
                    catch (IllegalArgumentException e) {
                        VASTLog.w(TAG, "Event:" + eventName + " is not valid. Skipping it.");
                        continue;
                    }
                    String trackingURL = XmlTools.getElementValue(node);
                    if (trackings.containsKey((Object)key)) {
                        tracking = trackings.get((Object)key);
                        tracking.add(trackingURL);
                        continue;
                    }
                    tracking = new ArrayList();
                    tracking.add(trackingURL);
                    trackings.put(key, tracking);
                }
            }
            catch (Exception e) {
                VASTLog.e(TAG, e.getMessage(), e);
                return null;
            }
        }
        return trackings;
    }

    public List<VASTMediaFile> getMediaFiles() {
        VASTLog.d(TAG, "getMediaFiles");
        ArrayList<VASTMediaFile> mediaFiles = new ArrayList<VASTMediaFile>();
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            NodeList nodes = (NodeList)xpath.evaluate(mediaFileXPATH, this.vastsDocument, XPathConstants.NODESET);
            if (nodes != null) {
                for (int i = 0; i < nodes.getLength(); ++i) {
                    VASTMediaFile mediaFile = new VASTMediaFile();
                    Node node = nodes.item(i);
                    NamedNodeMap attributes = node.getAttributes();
                    Node attributeNode = attributes.getNamedItem("apiFramework");
                    mediaFile.setApiFramework(attributeNode == null ? null : attributeNode.getNodeValue());
                    attributeNode = attributes.getNamedItem("bitrate");
                    mediaFile.setBitrate(attributeNode == null ? null : new BigInteger(attributeNode.getNodeValue()));
                    attributeNode = attributes.getNamedItem("delivery");
                    mediaFile.setDelivery(attributeNode == null ? null : attributeNode.getNodeValue());
                    attributeNode = attributes.getNamedItem("height");
                    mediaFile.setHeight(attributeNode == null ? null : new BigInteger(attributeNode.getNodeValue()));
                    attributeNode = attributes.getNamedItem("id");
                    mediaFile.setId(attributeNode == null ? null : attributeNode.getNodeValue());
                    attributeNode = attributes.getNamedItem("maintainAspectRatio");
                    mediaFile.setMaintainAspectRatio(attributeNode == null ? null : Boolean.valueOf(attributeNode.getNodeValue()));
                    attributeNode = attributes.getNamedItem("scalable");
                    mediaFile.setScalable(attributeNode == null ? null : Boolean.valueOf(attributeNode.getNodeValue()));
                    attributeNode = attributes.getNamedItem("type");
                    mediaFile.setType(attributeNode == null ? null : attributeNode.getNodeValue());
                    attributeNode = attributes.getNamedItem("width");
                    mediaFile.setWidth(attributeNode == null ? null : new BigInteger(attributeNode.getNodeValue()));
                    String mediaURL = XmlTools.getElementValue(node);
                    mediaFile.setValue(mediaURL);
                    mediaFiles.add(mediaFile);
                }
            }
        }
        catch (Exception e) {
            VASTLog.e(TAG, e.getMessage(), e);
            return null;
        }
        return mediaFiles;
    }

    public String getDuration() {
        VASTLog.d(TAG, "getDuration");
        String duration = null;
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            NodeList nodes = (NodeList)xpath.evaluate(durationXPATH, this.vastsDocument, XPathConstants.NODESET);
            if (nodes != null) {
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    duration = XmlTools.getElementValue(node);
                }
            }
        }
        catch (Exception e) {
            VASTLog.e(TAG, e.getMessage(), e);
            return null;
        }
        return duration;
    }

    public VideoClicks getVideoClicks() {
        VASTLog.d(TAG, "getVideoClicks");
        VideoClicks videoClicks = new VideoClicks();
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            NodeList nodes = (NodeList)xpath.evaluate(videoClicksXPATH, this.vastsDocument, XPathConstants.NODESET);
            if (nodes != null) {
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    NodeList childNodes = node.getChildNodes();
                    String value = null;
                    for (int childIndex = 0; childIndex < childNodes.getLength(); ++childIndex) {
                        Node child = childNodes.item(childIndex);
                        String nodeName = child.getNodeName();
                        if (nodeName.equalsIgnoreCase("ClickTracking")) {
                            value = XmlTools.getElementValue(child);
                            videoClicks.getClickTracking().add(value);
                            continue;
                        }
                        if (nodeName.equalsIgnoreCase("ClickThrough")) {
                            value = XmlTools.getElementValue(child);
                            videoClicks.setClickThrough(value);
                            continue;
                        }
                        if (!nodeName.equalsIgnoreCase("CustomClick")) continue;
                        value = XmlTools.getElementValue(child);
                        videoClicks.getCustomClick().add(value);
                    }
                }
            }
        }
        catch (Exception e) {
            VASTLog.e(TAG, e.getMessage(), e);
            return null;
        }
        return videoClicks;
    }

    public List<String> getImpressions() {
        VASTLog.d(TAG, "getImpressions");
        List<String> list = this.getListFromXPath(impressionXPATH);
        return list;
    }

    public List<String> getErrorUrl() {
        VASTLog.d(TAG, "getErrorUrl");
        List<String> list = this.getListFromXPath(errorUrlXPATH);
        return list;
    }

    private List<String> getListFromXPath(String xPath) {
        VASTLog.d(TAG, "getListFromXPath");
        ArrayList<String> list = new ArrayList<String>();
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            NodeList nodes = (NodeList)xpath.evaluate(xPath, this.vastsDocument, XPathConstants.NODESET);
            if (nodes != null) {
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    list.add(XmlTools.getElementValue(node));
                }
            }
        }
        catch (Exception e) {
            VASTLog.e(TAG, e.getMessage(), e);
            return null;
        }
        return list;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        VASTLog.d(TAG, "writeObject: about to write");
        oos.defaultWriteObject();
        String data = XmlTools.xmlDocumentToString(this.vastsDocument);
        oos.writeObject(data);
        VASTLog.d(TAG, "done writing");
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        VASTLog.d(TAG, "readObject: about to read");
        ois.defaultReadObject();
        String vastString = (String)ois.readObject();
        VASTLog.d(TAG, "vastString data is:\n" + vastString + "\n");
        this.vastsDocument = XmlTools.stringToDocument(vastString);
        VASTLog.d(TAG, "done reading");
    }

    public String getPickedMediaFileURL() {
        return this.pickedMediaFileURL;
    }

    public void setPickedMediaFileURL(String pickedMediaFileURL) {
        this.pickedMediaFileURL = pickedMediaFileURL;
    }
}

