package eanative.android.ad;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import eanative.android.model.EANativePlacementConfig;
import eanative.android.util.Logger;
import android.util.Base64;


public class AdData {
	public final static int CLICK_TRACK = 1;
	public final static int EXPAND_TRACK = 2;
	public final static String[] IMAGES_PRIORITY = {"image_large_landscape","image_landscape","image_square","image_portrait"};


    private String id;
	
	private String image_cdn_url;
	private String image_resize_url;
	private String contentURL;
	private String tracking_url;
	
	private JSONObject data;
	private JSONObject ad;
	private JSONObject adTags;
	private JSONObject config;
	private JSONObject user;
    private JSONObject adnxs;

    private EANativePlacementConfig placementConfig;
	private String clickTag;

	
	public AdData(JSONObject data) {
		this.data = data;
		
		try{
			this.contentURL = this.data.getString("link");
			this.config = this.data.getJSONObject("config");
			this.user= this.data.getJSONObject("user");
			
			this.image_cdn_url = this.config.getString("image_cdn_url");
			this.image_resize_url = this.config.getString("image_resize_url");
			this.tracking_url = this.config.getString("tracking_url");
			this.clickTag = this.config.getString("clickTag");
			
			
			
			this.ad = this.data.getJSONObject("ad").getJSONObject("settings");
			this.adTags = this.ad.getJSONObject("tags");
            this.adnxs = this.config.getJSONObject("adnxs");
		}catch(JSONException e){
			
		}
		/*if(this.ad !=null)
			Logger.info("JSON DATA %s", this.ad.toString());*/
		
	}
	
	public void setPlacementConfig(EANativePlacementConfig placementConfig) {
		this.placementConfig = placementConfig;
	}
	public String getAdImage(String imageName,int w,int h, Boolean resizing) {
		String url= resizing ? this.image_resize_url:this.image_cdn_url;
		
		String imageHash = ""; 
		
		imageHash = this.getAdTag(imageName);
		imageHash = imageHash.trim();
		
		if(imageHash.length()==0){
			
			List<String> images = Arrays.asList(IMAGES_PRIORITY);
			
			int imageIndex = images.indexOf(imageName); 
			if(imageIndex!=-1){
				for(int i = imageIndex, imageLength=images.size();i<imageLength;i++){
					imageHash = this.getAdTag(images.get(i));
					imageHash = imageHash.trim();
					if(imageHash.length()!=0){
						break;
					}
				}
			}
			if(imageHash.length()==0){
				return "";
			}
			
		}
		if(url !=""){
			String scaleMode = EANativePlacementConfig.ImagesScaleMode.SCALE_CROP;
			if(this.placementConfig !=null && this.placementConfig.imagesScaleMode!=null){
				scaleMode = this.placementConfig.imagesScaleMode.getScaleMode(imageName);
				
			}
			if(scaleMode.equals( EANativePlacementConfig.ImagesScaleMode.SCALE_HEIGHT)){
				w = 0;
			}
			//Logger.info("SCALE MOIDE: %s %s %d %d", scaleMode, imageName , w , h);
			url = url.replaceAll("\\{image_hash\\}", imageHash).replaceAll("\\{wxh\\}", w+"x"+h).replaceAll("\\{scalemode\\}", scaleMode);
		}
		return url;
	}
	public String getAdTag(String tagName) {
		String tagValue = "";
		if(this.adTags !=null){
			try{
				JSONArray tagArray = this.adTags.getJSONArray(tagName);
				if(tagValue !=null){
					tagValue = tagArray.get(0).toString();
				}
			}catch(JSONException e){	
				try{
					tagValue =  this.adTags.getString(tagName);
				}catch(JSONException er){	
					
				}
			}
			
				
		}
		return tagValue;
	}
	public String getTrackEvent(int type){
		String url=tracking_url;
		
		JSONObject trackData = new JSONObject();
		JSONObject performance = null;
		try{
			performance = this.data.getJSONObject("performance");
		}catch(JSONException e){};
		
		try{
			trackData.put("h", this.user.get("views_hash") );
			trackData.put("uid", this.user.get("uid") );
			trackData.put("ft", 3);
			trackData.put("ch", this.ad.get("ah"));
			trackData.put("pid", this.data.get("pid"));
			
			
			
			if(performance !=null){
				trackData.put("performance", performance);
			}
			
			JSONObject events  = new JSONObject();
			JSONArray eventType  = new JSONArray();
			JSONObject eventData = new JSONObject ();
			eventData.put("es", 100);
			eventData.put("a", 1);
			
			eventType.put(eventData);
			events.put("ev", eventType);			
			trackData.put("type", events);

            if(this.adnxs !=null) {
                Iterator<String> iterator = this.adnxs.keys();
                while (iterator.hasNext()) {
                    String key = iterator.next();
                    try {
                        Object value = this.adnxs.get(key);
                        trackData.put(key, value);
                    } catch (JSONException e) {
                    }
                }
            }
		}catch(JSONException e){
			
		}
		//Logger.info(" TRACK DATA: %s", trackData.toString());
		String trackDataString = trackData.toString();
		 byte[] trackDataByte = null;
	    try {
	    	trackDataByte = trackDataString.getBytes("UTF-8");
	    } catch (UnsupportedEncodingException e1) {
	    
	    }
	    
	    String trk = Base64.encodeToString(trackDataByte, Base64.DEFAULT|Base64.URL_SAFE|Base64.NO_WRAP) ;
	    
		url = url.replaceAll("\\{base64_encoded_data\\}", trk );
				
		return url;
	}
	public String getBrandLink(){
		String brand_url = this.getEncoded(this.getAdTag("brand_url"));
		if(brand_url!=""){
			return this.clickTag + brand_url;
		}
		return "";
	}
	public String getContentLink(){
		if(this.clickTag.length()>0) {
            return this.clickTag + this.getEncoded(this.contentURL);
        }
        return  this.contentURL;
	}
	public String getId() {
		return this.id;
	}
	public String toString(){
		return this.data.toString();
	}
	protected String getEncoded(String url){
		try{
			return URLEncoder.encode(url,"UTF-8");
		}catch(UnsupportedEncodingException e){
			return url;
		}
	}
}
