/*
 * Decompiled with CFR 0.152.
 */
package ds.rxcontacts;

import android.content.Context;
import android.database.Cursor;
import android.util.Log;
import ds.rxcontacts.Contact;
import ds.rxcontacts.ContactsHelper;
import ds.rxcontacts.Filter;
import ds.rxcontacts.RxContacts$$Lambda$1;
import ds.rxcontacts.RxContacts$$Lambda$4;
import ds.rxcontacts.RxContacts$$Lambda$5;
import ds.rxcontacts.Sorter;
import rx.Observable;
import rx.Subscriber;

public class RxContacts {
    private static RxContacts instance;
    boolean withPhones;
    boolean withEmails;
    private Sorter sorter;
    private Filter[] filter;
    private ContactsHelper helper;
    private Observable<Contact> profileObservable;
    private Observable<Contact> contactsObservable;

    public static RxContacts getInstance(Context ctx) {
        if (instance == null) {
            instance = new RxContacts(ctx);
        }
        RxContacts.instance.withPhones = false;
        RxContacts.instance.withEmails = false;
        RxContacts.instance.sorter = null;
        RxContacts.instance.filter = null;
        return instance;
    }

    private RxContacts(Context ctx) {
        this.helper = new ContactsHelper(ctx);
    }

    public Observable<Contact> getProfile() {
        if (this.profileObservable == null) {
            this.profileObservable = Observable.create((Observable.OnSubscribe)RxContacts$$Lambda$1.lambdaFactory$(this));
            this.profileObservable = this.profileObservable.cache();
        }
        return this.profileObservable;
    }

    public ContactsHelper getContactsHelper() {
        return this.helper;
    }

    public Observable<Contact> getContacts() {
        if (this.contactsObservable == null) {
            this.contactsObservable = Observable.create((Observable.OnSubscribe)RxContacts$$Lambda$4.lambdaFactory$(this)).onBackpressureBuffer().serialize();
        }
        return this.contactsObservable;
    }

    public Observable<Contact> getContactsFast() {
        return Observable.create((Observable.OnSubscribe)RxContacts$$Lambda$5.lambdaFactory$(this)).onBackpressureBuffer().serialize();
    }

    public RxContacts withPhones() {
        this.withPhones = true;
        return this;
    }

    public RxContacts withEmails() {
        this.withEmails = true;
        return this;
    }

    public RxContacts sort(Sorter sorter) {
        this.sorter = sorter;
        return this;
    }

    public RxContacts filter(Filter ... filter) {
        this.filter = filter;
        return this;
    }

    private void emit(String query, boolean withPhones, boolean withEmails, Sorter sorter, Filter[] filter, Subscriber<? super Contact> subscriber) {
        Cursor c = this.helper.getContactsCursor(query, sorter, filter);
        while (c.moveToNext()) {
            Contact contact = this.helper.fetchContact(c, withPhones, withEmails);
            if (subscriber.isUnsubscribed()) break;
            subscriber.onNext((Object)contact);
            if (!ContactsHelper.DEBUG) continue;
            Log.i((String)"emit", (String)(contact.toString() + " is subscribed=" + !subscriber.isUnsubscribed()));
        }
        c.close();
        subscriber.onCompleted();
    }

    private void emitFast(Subscriber<? super Contact> subscriber) {
        Cursor c = this.helper.getFastContactsCursor();
        int count = c.getCount();
        if (count != 0) {
            c.moveToNext();
            while (c.getPosition() < count) {
                Contact contact = this.helper.fetchContactFast(c);
                if (subscriber.isUnsubscribed()) break;
                subscriber.onNext((Object)contact);
                if (!ContactsHelper.DEBUG) continue;
                Log.i((String)"emit fast", (String)(contact.toString() + " is subscribed=" + !subscriber.isUnsubscribed()));
            }
        }
        c.close();
        subscriber.onCompleted();
    }

    private /* synthetic */ void lambda$getContactsFast$2(Subscriber subscriber) {
        this.emitFast((Subscriber<? super Contact>)subscriber);
    }

    private /* synthetic */ void lambda$getContacts$1(Subscriber subscriber) {
        this.emit(null, this.withPhones, this.withEmails, this.sorter, this.filter, (Subscriber<? super Contact>)subscriber);
    }

    private /* synthetic */ void lambda$getProfile$0(Subscriber subscriber) {
        Contact c = this.helper.getProfileContact();
        if (c != null) {
            subscriber.onNext((Object)c);
        }
        subscriber.onCompleted();
    }

    static /* synthetic */ void access$lambda$0(RxContacts rxContacts, Subscriber subscriber) {
        rxContacts.lambda$getProfile$0(subscriber);
    }

    static /* synthetic */ void access$lambda$1(RxContacts rxContacts, Subscriber subscriber) {
        rxContacts.lambda$getContacts$1(subscriber);
    }

    static /* synthetic */ void access$lambda$2(RxContacts rxContacts, Subscriber subscriber) {
        rxContacts.lambda$getContactsFast$2(subscriber);
    }
}

