/*
 * Decompiled with CFR 0.152.
 */
package ds.rxcontacts;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.ContactsContract;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import android.util.Patterns;
import ds.rxcontacts.Contact;
import ds.rxcontacts.Filter;
import ds.rxcontacts.Sorter;
import java.util.ArrayList;
import java.util.List;

public class ContactsHelper {
    private static final String TAG = "Contacts";
    public static boolean DEBUG = false;
    private static final String[] DATA_PROJECTION = new String[]{"data1", "mimetype"};
    private static final String[] DATA_PROJECTION_FULL = new String[]{"data1", "mimetype", "contact_id", "photo_thumb_uri"};
    private static final String[] CONTACTS_PROJECTION = new String[]{"_id", "display_name", "photo_thumb_uri", "has_phone_number"};
    Context context;
    ContentResolver resolver;

    public ContactsHelper(Context ctx) {
        this.context = ctx;
        this.resolver = this.context.getContentResolver();
    }

    @Nullable
    public Contact getProfileContact() {
        String filter = this.getAccountEmail();
        if (filter == null) {
            filter = this.getProfileName();
        }
        if (filter == null) {
            return null;
        }
        List<Contact> contacts = this.filter(filter, true, true, null, null);
        if (!contacts.isEmpty()) {
            return contacts.get(0);
        }
        return null;
    }

    @NonNull
    public List<Contact> filter(String query, boolean withPhones, boolean withEmails, Sorter sorter, Filter[] filter) {
        ArrayList<Contact> result = new ArrayList<Contact>();
        Cursor c = this.getContactsCursor(query, sorter, filter);
        while (c.moveToNext()) {
            Contact contact = this.fetchContact(c, withPhones, withEmails);
            result.add(contact);
        }
        c.close();
        if (DEBUG) {
            ContactsHelper.log(result);
        }
        return result;
    }

    public static String cleanPhone(String phone) {
        return phone.replaceAll("-|\\s|\\(|\\)|\\+", "");
    }

    @NonNull
    Contact fetchContact(Cursor c, boolean withPhones, boolean withEmails) {
        String id = c.getString(c.getColumnIndex("_id"));
        Contact contact = new Contact(id);
        contact.name = c.getString(c.getColumnIndex("display_name"));
        contact.photoUri = c.getString(c.getColumnIndex("photo_thumb_uri"));
        if (withPhones && c.getInt(c.getColumnIndex("has_phone_number")) > 0 || withEmails) {
            ArrayList<String> phones = new ArrayList<String>();
            ArrayList<String> emails = new ArrayList<String>();
            Cursor data = this.getDataCursor(id, withPhones, withEmails);
            while (data.moveToNext()) {
                String value = data.getString(data.getColumnIndex("data1"));
                String string = data.getString(data.getColumnIndex("mimetype"));
                int n = -1;
                switch (string.hashCode()) {
                    case -1569536764: {
                        if (!string.equals("vnd.android.cursor.item/email_v2")) break;
                        n = 0;
                        break;
                    }
                    case 684173810: {
                        if (!string.equals("vnd.android.cursor.item/phone_v2")) break;
                        n = 1;
                    }
                }
                switch (n) {
                    case 0: {
                        emails.add(value);
                        break;
                    }
                    case 1: {
                        phones.add(ContactsHelper.cleanPhone(value));
                    }
                }
            }
            contact.phones = phones;
            contact.emails = emails;
            data.close();
        }
        return contact;
    }

    Cursor getContactsCursor(String query, Sorter sorter, Filter[] filter) {
        Uri uri = query == null ? ContactsContract.Contacts.CONTENT_URI : Uri.withAppendedPath((Uri)ContactsContract.Contacts.CONTENT_FILTER_URI, (String)query);
        String order = sorter != null ? sorter.raw : null;
        String where = filter != null ? TextUtils.join((CharSequence)" AND ", (Object[])filter) : null;
        return this.resolver.query(uri, CONTACTS_PROJECTION, where, null, order);
    }

    Cursor getDataCursor(String contactId, boolean withPhones, boolean withEmails) {
        ArrayList<String> selections = new ArrayList<String>();
        ArrayList<String> args = new ArrayList<String>();
        args.add(contactId);
        String where = "mimetype=?";
        if (withPhones) {
            selections.add(where);
            args.add("vnd.android.cursor.item/phone_v2");
        }
        if (withEmails) {
            selections.add(where);
            args.add("vnd.android.cursor.item/email_v2");
        }
        Cursor data = this.resolver.query(ContactsContract.Data.CONTENT_URI, DATA_PROJECTION, String.format("%s=? AND (%s)", "contact_id", TextUtils.join((CharSequence)" OR ", selections)), args.toArray(new String[args.size()]), null);
        return data;
    }

    Cursor getFastContactsCursor() {
        String where = "mimetype=?";
        Object[] wheres = new String[]{where, where, where};
        String[] selectionArgs = new String[]{"vnd.android.cursor.item/name", "vnd.android.cursor.item/email_v2", "vnd.android.cursor.item/phone_v2"};
        String selection = TextUtils.join((CharSequence)" OR ", (Object[])wheres);
        Cursor data = this.resolver.query(ContactsContract.Data.CONTENT_URI, DATA_PROJECTION_FULL, selection, selectionArgs, "contact_id");
        return data;
    }

    @NonNull
    Contact fetchContactFast(Cursor c) {
        String id = c.getString(c.getColumnIndex("contact_id"));
        Contact contact = new Contact(id);
        ArrayList<String> phones = new ArrayList<String>();
        ArrayList<String> emails = new ArrayList<String>();
        String nextId = id;
        while (id.equals(nextId)) {
            String value = c.getString(c.getColumnIndex("data1"));
            String string = c.getString(c.getColumnIndex("mimetype"));
            int n = -1;
            switch (string.hashCode()) {
                case -1079224304: {
                    if (!string.equals("vnd.android.cursor.item/name")) break;
                    n = 0;
                    break;
                }
                case -1569536764: {
                    if (!string.equals("vnd.android.cursor.item/email_v2")) break;
                    n = 1;
                    break;
                }
                case 684173810: {
                    if (!string.equals("vnd.android.cursor.item/phone_v2")) break;
                    n = 2;
                }
            }
            switch (n) {
                case 0: {
                    contact.name = value;
                    contact.photoUri = c.getString(c.getColumnIndex("photo_thumb_uri"));
                    break;
                }
                case 1: {
                    emails.add(value);
                    break;
                }
                case 2: {
                    phones.add(ContactsHelper.cleanPhone(value));
                }
            }
            if (!c.moveToNext()) break;
            nextId = c.getString(c.getColumnIndex("contact_id"));
        }
        contact.phones = phones;
        contact.emails = emails;
        return contact;
    }

    private static void log(List<Contact> contacts) {
        Log.v((String)TAG, (String)"=== contacts ===");
        for (Contact c : contacts) {
            Log.v((String)TAG, (String)c.toString());
        }
    }

    @Nullable
    private String getAccountEmail() {
        Account[] accounts;
        AccountManager manager = AccountManager.get((Context)this.context);
        for (Account account : accounts = manager.getAccountsByType("com.google")) {
            Log.v((String)TAG, (String)("account:" + account.name));
            if (!Patterns.EMAIL_ADDRESS.matcher(account.name).matches()) continue;
            return account.name;
        }
        return null;
    }

    private String getProfileName() {
        Cursor c = this.resolver.query(ContactsContract.Profile.CONTENT_URI, null, null, null, null);
        String name = null;
        if (c.moveToFirst()) {
            String id = c.getString(c.getColumnIndex("_id"));
            name = c.getString(c.getColumnIndex("display_name"));
        }
        c.close();
        return name;
    }
}

