/*
 * Decompiled with CFR 0.152.
 */
package dragollla.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.ColorRes;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import dragollla.views.R;

public class TextButton
extends AppCompatTextView {
    private int mDefaultColor;
    private int mActiveColor;

    public TextButton(Context context) {
        super(context);
    }

    public TextButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, 0);
    }

    public TextButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrsSet, int defStyleAttr, int defStyleRes) {
        TypedArray baseAttrs = context.getTheme().obtainStyledAttributes(attrsSet, new int[]{16842904}, defStyleAttr, defStyleRes);
        try {
            this.mDefaultColor = baseAttrs.getColor(0, -16777216);
        }
        finally {
            baseAttrs.recycle();
        }
        TypedArray attrs = context.getTheme().obtainStyledAttributes(attrsSet, R.styleable.TextButton, defStyleAttr, defStyleRes);
        try {
            this.mActiveColor = attrs.getColor(R.styleable.TextButton_dr_active_color, this.mDefaultColor);
        }
        finally {
            attrs.recycle();
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.setTextColor(this.mActiveColor);
                break;
            }
            case 1: 
            case 3: {
                this.setTextColor(this.mDefaultColor);
            }
        }
        return super.onTouchEvent(event);
    }

    public void setDefaultColorRes(@ColorRes int colorId) {
        this.setDefaultColor(ContextCompat.getColor((Context)this.getContext(), (int)colorId));
    }

    public void setDefaultColor(int color) {
        this.mDefaultColor = color;
        this.setTextColor(color);
    }

    public int getDefaultColor() {
        return this.mDefaultColor;
    }

    public void setActiveColor(int color) {
        this.mActiveColor = color;
    }

    public void setActiveColorRes(@ColorRes int colorId) {
        this.setActiveColor(ContextCompat.getColor((Context)this.getContext(), (int)colorId));
    }

    public int getActiveColor() {
        return this.mActiveColor;
    }
}

