/*
 * Decompiled with CFR 0.152.
 */
package io.dotlearn.lrnplayer.loader.videodata;

import io.dotlearn.lrnplayer.loader.model.VideoDataRequest;
import io.dotlearn.lrnplayer.loader.model.VideoDataResponse;
import io.dotlearn.lrnplayer.loader.videodata.VideoService;
import io.dotlearn.lrnplayer.utils.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.HttpException;
import retrofit2.Response;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J%\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/dotlearn/lrnplayer/loader/videodata/VideoDataFetcher;", "", "videoService", "Lio/dotlearn/lrnplayer/loader/videodata/VideoService;", "(Lio/dotlearn/lrnplayer/loader/videodata/VideoService;)V", "fetch", "", "accessToken", "", "videoId", "callback", "Lio/dotlearn/lrnplayer/loader/videodata/VideoDataFetcher$VideoDataFetchCallback;", "fetch$lrnplayer_release", "VideoDataFetchCallback", "lrnplayer_release"})
public final class VideoDataFetcher {
    private final VideoService videoService;

    public final void fetch$lrnplayer_release(@NotNull String accessToken, @NotNull String videoId, @NotNull VideoDataFetchCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)accessToken, (String)"accessToken");
        Intrinsics.checkParameterIsNotNull((Object)videoId, (String)"videoId");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        Logger.INSTANCE.d("Fetching video data. AccessToken: " + accessToken + ". VideoId: " + videoId);
        this.videoService.serveVideo(new VideoDataRequest(accessToken, videoId)).enqueue((Callback)new Callback<VideoDataResponse>(callback){
            final /* synthetic */ VideoDataFetchCallback $callback;

            public void onFailure(@Nullable Call<VideoDataResponse> call, @Nullable Throwable t) {
                Logger.INSTANCE.e("Error fetching video data. Error: " + t);
                this.$callback.onVideoDataFetchError(new Exception(t));
            }

            public void onResponse(@NotNull Call<VideoDataResponse> call, @NotNull Response<VideoDataResponse> response) {
                Intrinsics.checkParameterIsNotNull(call, (String)"call");
                Intrinsics.checkParameterIsNotNull(response, (String)"response");
                Logger.INSTANCE.d("On video data response received");
                VideoDataResponse videoDataResponse = (VideoDataResponse)response.body();
                if (!response.isSuccessful() || videoDataResponse == null) {
                    HttpException exception = new HttpException(response);
                    Logger.INSTANCE.e("Response was not successful. Error: " + exception);
                    this.$callback.onVideoDataFetchError((Exception)exception);
                    return;
                }
                Logger.INSTANCE.d("VideoDataResponse: " + videoDataResponse);
                this.$callback.onVideoDataFetched(videoDataResponse);
            }
            {
                this.$callback = $captured_local_variable$0;
            }
        });
    }

    public VideoDataFetcher(@NotNull VideoService videoService) {
        Intrinsics.checkParameterIsNotNull((Object)videoService, (String)"videoService");
        this.videoService = videoService;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006H&J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH&\u00a8\u0006\n"}, d2={"Lio/dotlearn/lrnplayer/loader/videodata/VideoDataFetcher$VideoDataFetchCallback;", "", "onVideoDataFetchError", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onVideoDataFetched", "videoData", "Lio/dotlearn/lrnplayer/loader/model/VideoDataResponse;", "lrnplayer_release"})
    public static interface VideoDataFetchCallback {
        public void onVideoDataFetched(@NotNull VideoDataResponse var1);

        public void onVideoDataFetchError(@NotNull Exception var1);
    }
}

