/*
 * Decompiled with CFR 0.152.
 */
package io.dotlearn.lrnplayer.loader.download;

import android.os.AsyncTask;
import io.dotlearn.lrnplayer.loader.download.DownloadRequest;
import io.dotlearn.lrnplayer.utils.IoUtils;
import io.dotlearn.lrnplayer.utils.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.encryptor4j.Encryptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0002\u001a\u001bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u000fJ\r\u0010\u0010\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0011J5\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/dotlearn/lrnplayer/loader/download/Downloader;", "", "okHttpClient", "Lokhttp3/OkHttpClient;", "ioUtils", "Lio/dotlearn/lrnplayer/utils/IoUtils;", "(Lokhttp3/OkHttpClient;Lio/dotlearn/lrnplayer/utils/IoUtils;)V", "tasks", "Ljava/util/HashMap;", "", "Lio/dotlearn/lrnplayer/loader/download/Downloader$DownloadTask;", "Lkotlin/collections/HashMap;", "cancel", "", "downloadTag", "cancel$lrnplayer_release", "cancelAll", "cancelAll$lrnplayer_release", "download", "downloadUrl", "destFile", "Ljava/io/File;", "key", "callback", "Lio/dotlearn/lrnplayer/loader/download/Downloader$DownloadCallback;", "download$lrnplayer_release", "DownloadCallback", "DownloadTask", "lrnplayer_release"})
public final class Downloader {
    private final HashMap<String, DownloadTask> tasks;
    private final OkHttpClient okHttpClient;
    private final IoUtils ioUtils;

    public final void download$lrnplayer_release(@NotNull String downloadUrl, @NotNull File destFile, @NotNull String downloadTag, @NotNull String key, @NotNull DownloadCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)downloadUrl, (String)"downloadUrl");
        Intrinsics.checkParameterIsNotNull((Object)destFile, (String)"destFile");
        Intrinsics.checkParameterIsNotNull((Object)downloadTag, (String)"downloadTag");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        Logger.INSTANCE.d("Download url: " + downloadUrl + ". DestFile: " + destFile.getAbsolutePath() + ". Tag: " + downloadTag);
        DownloadRequest downloadRequest = new DownloadRequest(downloadUrl, destFile, downloadTag, key);
        DownloadTask downloadTask = new DownloadTask(downloadRequest, callback, this.okHttpClient, this.ioUtils);
        Map map = this.tasks;
        DownloadTask downloadTask2 = downloadTask;
        map.put(downloadTag, downloadTask2);
        downloadTask.execute(new Void[0]);
    }

    public final void cancel$lrnplayer_release(@NotNull String downloadTag) {
        Intrinsics.checkParameterIsNotNull((Object)downloadTag, (String)"downloadTag");
        Logger.INSTANCE.d("Cancelling task with tag: " + downloadTag);
        DownloadTask downloadTask = this.tasks.get(downloadTag);
        if (downloadTask != null) {
            downloadTask.cancel(true);
        }
        this.tasks.remove(downloadTag);
    }

    public final void cancelAll$lrnplayer_release() {
        Map $receiver$iv;
        Logger.INSTANCE.d("Cancelling all tasks");
        Map map = $receiver$iv = (Map)this.tasks;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            Logger.INSTANCE.d("Cancelling task with tag: " + (String)it.getKey());
            ((DownloadTask)((Object)it.getValue())).cancel(true);
        }
        this.tasks.clear();
    }

    public Downloader(@NotNull OkHttpClient okHttpClient, @NotNull IoUtils ioUtils) {
        Intrinsics.checkParameterIsNotNull((Object)okHttpClient, (String)"okHttpClient");
        Intrinsics.checkParameterIsNotNull((Object)ioUtils, (String)"ioUtils");
        this.okHttpClient = okHttpClient;
        this.ioUtils = ioUtils;
        this.tasks = new HashMap();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u0001B%\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ)\u0010\u000f\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u00052\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0011\"\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005H\u0014J\b\u0010\u0016\u001a\u00020\u0014H\u0014J%\u0010\u0017\u001a\u00020\u00142\u0016\u0010\u0018\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00030\u0011\"\u0004\u0018\u00010\u0003H\u0014\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/dotlearn/lrnplayer/loader/download/Downloader$DownloadTask;", "Landroid/os/AsyncTask;", "Ljava/lang/Void;", "", "Ljava/lang/Exception;", "Lkotlin/Exception;", "downloadRequest", "Lio/dotlearn/lrnplayer/loader/download/DownloadRequest;", "downloadCallback", "Lio/dotlearn/lrnplayer/loader/download/Downloader$DownloadCallback;", "okHttpClient", "Lokhttp3/OkHttpClient;", "ioUtils", "Lio/dotlearn/lrnplayer/utils/IoUtils;", "(Lio/dotlearn/lrnplayer/loader/download/DownloadRequest;Lio/dotlearn/lrnplayer/loader/download/Downloader$DownloadCallback;Lokhttp3/OkHttpClient;Lio/dotlearn/lrnplayer/utils/IoUtils;)V", "doInBackground", "params", "", "([Ljava/lang/Void;)Ljava/lang/Exception;", "onPostExecute", "", "e", "onPreExecute", "onProgressUpdate", "numbers", "([Ljava/lang/Long;)V", "lrnplayer_release"})
    private static final class DownloadTask
    extends AsyncTask<Void, Long, Exception> {
        private final DownloadRequest downloadRequest;
        private final DownloadCallback downloadCallback;
        private final OkHttpClient okHttpClient;
        private final IoUtils ioUtils;

        protected void onPreExecute() {
            Logger.INSTANCE.d("Starting video download");
            this.downloadCallback.onDownloadStarted(this.downloadRequest.getRequestTag());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Nullable
        protected Exception doInBackground(Void ... params) {
            void inputStream;
            Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
            Logger.INSTANCE.d("Downloading in the background");
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            OutputStream outputStream = null;
            try {
                void len;
                Key secretKey = this.ioUtils.getSecretKey(this.downloadRequest.getKey());
                Encryptor encryptor = new Encryptor(secretKey, "AES/CTR/NoPadding", 16);
                Request request = new Request.Builder().url(this.downloadRequest.getDownloadUrl()).build();
                Response response = this.okHttpClient.newCall(request).execute();
                ResponseBody responseBody = response.body();
                if (responseBody == null) {
                    Intrinsics.throwNpe();
                }
                inputStream.element = responseBody.byteStream();
                outputStream = encryptor.wrapOutputStream((OutputStream)new FileOutputStream(this.downloadRequest.getDestFile()));
                InputStream inputStream2 = (InputStream)inputStream.element;
                if (inputStream2 == null) {
                    Intrinsics.throwNpe();
                }
                long totalCount = inputStream2.available();
                byte[] buffer = new byte[8192];
                Ref.IntRef intRef = new Ref.IntRef();
                intRef.element = -1;
                long readLen = 0L;
                while (((Number)((Function0)new Function0<Integer>((Ref.IntRef)len, (Ref.ObjectRef)inputStream, buffer){
                    final /* synthetic */ Ref.IntRef $len;
                    final /* synthetic */ Ref.ObjectRef $inputStream;
                    final /* synthetic */ byte[] $buffer;

                    public final int invoke() {
                        this.$len.element = ((InputStream)this.$inputStream.element).read(this.$buffer);
                        return this.$len.element;
                    }
                    {
                        this.$len = intRef;
                        this.$inputStream = objectRef;
                        this.$buffer = byArray;
                        super(0);
                    }
                }).invoke()).intValue() != -1) {
                    outputStream.write(buffer, 0, len.element);
                    this.publishProgress(new Long[]{readLen += (long)len.element, totalCount});
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                Logger.INSTANCE.e("Error downloading video: " + e);
                Exception exception = e;
                return exception;
            }
            finally {
                Logger.INSTANCE.d("Closing streams");
                this.ioUtils.closeQuietly((InputStream)inputStream.element);
                this.ioUtils.closeQuietly(outputStream);
            }
            return null;
        }

        protected void onProgressUpdate(Long ... numbers) {
            Intrinsics.checkParameterIsNotNull((Object)numbers, (String)"numbers");
            Long l = numbers[0];
            long bytesTransferred = l != null ? l : 0L;
            Long l2 = numbers[1];
            long totalBytes = l2 != null ? l2 : 0L;
            this.downloadCallback.onDownloadProgressUpdate(this.downloadRequest.getRequestTag(), bytesTransferred, totalBytes);
            Logger.INSTANCE.d("On progress update. Transferred: " + bytesTransferred + ". Total: " + totalBytes);
        }

        protected void onPostExecute(@Nullable Exception e) {
            if (e == null) {
                Logger.INSTANCE.d("Download completed successfully");
                this.downloadCallback.onDownloadCompleted(this.downloadRequest.getRequestTag());
            } else {
                Logger.INSTANCE.d("Download completed with error");
                this.downloadCallback.onDownloadError(this.downloadRequest.getRequestTag(), e);
            }
        }

        public DownloadTask(@NotNull DownloadRequest downloadRequest, @NotNull DownloadCallback downloadCallback, @NotNull OkHttpClient okHttpClient, @NotNull IoUtils ioUtils) {
            Intrinsics.checkParameterIsNotNull((Object)downloadRequest, (String)"downloadRequest");
            Intrinsics.checkParameterIsNotNull((Object)downloadCallback, (String)"downloadCallback");
            Intrinsics.checkParameterIsNotNull((Object)okHttpClient, (String)"okHttpClient");
            Intrinsics.checkParameterIsNotNull((Object)ioUtils, (String)"ioUtils");
            this.downloadRequest = downloadRequest;
            this.downloadCallback = downloadCallback;
            this.okHttpClient = okHttpClient;
            this.ioUtils = ioUtils;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u001c\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\u0010\u0007\u001a\u00060\bj\u0002`\tH&J \u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH&J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u000f"}, d2={"Lio/dotlearn/lrnplayer/loader/download/Downloader$DownloadCallback;", "", "onDownloadCompleted", "", "downloadTag", "", "onDownloadError", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onDownloadProgressUpdate", "bytesTransferred", "", "totalBytes", "onDownloadStarted", "lrnplayer_release"})
    public static interface DownloadCallback {
        public void onDownloadStarted(@NotNull String var1);

        public void onDownloadProgressUpdate(@NotNull String var1, long var2, long var4);

        public void onDownloadError(@NotNull String var1, @NotNull Exception var2);

        public void onDownloadCompleted(@NotNull String var1);
    }
}

