/*
 * Decompiled with CFR 0.152.
 */
package io.dotlearn.lrnplayer.loader;

import io.dotlearn.lrnplayer.loader.VideoDb;
import io.dotlearn.lrnplayer.loader.di.Injector;
import io.dotlearn.lrnplayer.loader.download.Downloader;
import io.dotlearn.lrnplayer.loader.model.VideoDataResponse;
import io.dotlearn.lrnplayer.loader.model.VideoMetadata;
import io.dotlearn.lrnplayer.loader.videodata.VideoDataFetcher;
import io.dotlearn.lrnplayer.utils.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ0\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J(\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0014\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J%\u0010\u0015\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0016J(\u0010\u0017\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/dotlearn/lrnplayer/loader/VideoLoader;", "", "()V", "videoDataFetcher", "Lio/dotlearn/lrnplayer/loader/videodata/VideoDataFetcher;", "videoDownloader", "Lio/dotlearn/lrnplayer/loader/download/Downloader;", "cancel", "", "cancel$lrnplayer_release", "downloadVideo", "accessToken", "", "videoId", "videoData", "Lio/dotlearn/lrnplayer/loader/model/VideoDataResponse;", "key", "callback", "Lio/dotlearn/lrnplayer/loader/VideoLoader$VideoLoadCallback;", "fetchVideoData", "getStuff", "load", "load$lrnplayer_release", "loadVideo", "VideoLoadCallback", "lrnplayer_release"})
public final class VideoLoader {
    private static final VideoDataFetcher videoDataFetcher;
    private static final Downloader videoDownloader;
    public static final VideoLoader INSTANCE;

    public final void load$lrnplayer_release(@NotNull String accessToken, @NotNull String videoId, @NotNull VideoLoadCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)accessToken, (String)"accessToken");
        Intrinsics.checkParameterIsNotNull((Object)videoId, (String)"videoId");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        Logger.INSTANCE.d("Loading video. AccessToken: " + accessToken + ". VideoId: " + videoId);
        callback.onVideoLoadStarted();
        String key = this.getStuff(accessToken, videoId);
        this.loadVideo(accessToken, videoId, key, callback);
    }

    public final void cancel$lrnplayer_release() {
        videoDownloader.cancelAll$lrnplayer_release();
    }

    private final void loadVideo(String accessToken, String videoId, String key, VideoLoadCallback callback) {
        if (!VideoDb.INSTANCE.exist$lrnplayer_release(accessToken, videoId)) {
            Logger.INSTANCE.d("Video metadata and file is available on device");
            this.fetchVideoData(accessToken, videoId, key, callback);
        } else {
            Logger.INSTANCE.d("Video metadata or file is not available on the device");
            VideoDb.INSTANCE.load$lrnplayer_release(accessToken, videoId, key, new VideoDb.VideoLoadCallback(callback){
                final /* synthetic */ VideoLoadCallback $callback;

                public void onVideoLoaded(@NotNull VideoDb.VideoLoadResponse videoData) {
                    Intrinsics.checkParameterIsNotNull((Object)videoData, (String)"videoData");
                    this.$callback.onVideoLoaded(videoData.getMetadata(), videoData.getBytesBase64Encoded());
                }

                public void onVideoLoadError(@NotNull Exception e) {
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                    this.$callback.onVideoLoadError(e);
                }
                {
                    this.$callback = $captured_local_variable$0;
                }
            });
        }
    }

    private final void fetchVideoData(String accessToken, String videoId, String key, VideoLoadCallback callback) {
        Logger.INSTANCE.d("Fetching video data");
        videoDataFetcher.fetch$lrnplayer_release(accessToken, videoId, new VideoDataFetcher.VideoDataFetchCallback(accessToken, videoId, key, callback){
            final /* synthetic */ String $accessToken;
            final /* synthetic */ String $videoId;
            final /* synthetic */ String $key;
            final /* synthetic */ VideoLoadCallback $callback;

            public void onVideoDataFetched(@NotNull VideoDataResponse videoData) {
                Intrinsics.checkParameterIsNotNull((Object)videoData, (String)"videoData");
                VideoDb.INSTANCE.saveMetadata$lrnplayer_release(this.$accessToken, this.$videoId, videoData.getMetaData());
                VideoLoader.access$downloadVideo(VideoLoader.INSTANCE, this.$accessToken, this.$videoId, videoData, this.$key, this.$callback);
            }

            public void onVideoDataFetchError(@NotNull Exception e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.$callback.onVideoLoadError(e);
            }
            {
                this.$accessToken = $captured_local_variable$0;
                this.$videoId = $captured_local_variable$1;
                this.$key = $captured_local_variable$2;
                this.$callback = $captured_local_variable$3;
            }
        });
    }

    private final void downloadVideo(String accessToken, String videoId, VideoDataResponse videoData, String key, VideoLoadCallback callback) {
        videoDownloader.download$lrnplayer_release(videoData.getUrl(), VideoDb.INSTANCE.getFile$lrnplayer_release(accessToken, videoId), videoId, key, new Downloader.DownloadCallback(callback, accessToken, videoId, key){
            final /* synthetic */ VideoLoadCallback $callback;
            final /* synthetic */ String $accessToken;
            final /* synthetic */ String $videoId;
            final /* synthetic */ String $key;

            public void onDownloadStarted(@NotNull String downloadTag) {
                Intrinsics.checkParameterIsNotNull((Object)downloadTag, (String)"downloadTag");
                Logger.INSTANCE.d("Download started. Tag: " + downloadTag);
            }

            public void onDownloadProgressUpdate(@NotNull String downloadTag, long bytesTransferred, long totalBytes) {
                Intrinsics.checkParameterIsNotNull((Object)downloadTag, (String)"downloadTag");
                Logger.INSTANCE.d("Download progress update. Tag: " + downloadTag);
                this.$callback.onVideoLoadProgress(bytesTransferred, totalBytes);
            }

            public void onDownloadError(@NotNull String downloadTag, @NotNull Exception e) {
                Intrinsics.checkParameterIsNotNull((Object)downloadTag, (String)"downloadTag");
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                Logger.INSTANCE.d("Download error. Tag: " + downloadTag);
                this.$callback.onVideoLoadError(e);
            }

            public void onDownloadCompleted(@NotNull String downloadTag) {
                Intrinsics.checkParameterIsNotNull((Object)downloadTag, (String)"downloadTag");
                Logger.INSTANCE.d("Download completed. Tag: " + downloadTag);
                VideoLoader.access$loadVideo(VideoLoader.INSTANCE, this.$accessToken, this.$videoId, this.$key, this.$callback);
            }
            {
                this.$callback = $captured_local_variable$0;
                this.$accessToken = $captured_local_variable$1;
                this.$videoId = $captured_local_variable$2;
                this.$key = $captured_local_variable$3;
            }
        });
    }

    private final String getStuff(String accessToken, String videoId) {
        return accessToken + videoId;
    }

    private VideoLoader() {
    }

    static {
        VideoLoader videoLoader;
        INSTANCE = videoLoader = new VideoLoader();
        videoDataFetcher = Injector.INSTANCE.provideVideoDataFetcher$lrnplayer_release();
        videoDownloader = Injector.INSTANCE.provideDownloader$lrnplayer_release();
    }

    public static final /* synthetic */ void access$downloadVideo(VideoLoader $this, @NotNull String accessToken, @NotNull String videoId, @NotNull VideoDataResponse videoData, @NotNull String key, @NotNull VideoLoadCallback callback) {
        $this.downloadVideo(accessToken, videoId, videoData, key, callback);
    }

    public static final /* synthetic */ void access$loadVideo(VideoLoader $this, @NotNull String accessToken, @NotNull String videoId, @NotNull String key, @NotNull VideoLoadCallback callback) {
        $this.loadVideo(accessToken, videoId, key, callback);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006H&J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH&J\b\u0010\u000b\u001a\u00020\u0003H&J\u0018\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H&\u00a8\u0006\u0011"}, d2={"Lio/dotlearn/lrnplayer/loader/VideoLoader$VideoLoadCallback;", "", "onVideoLoadError", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onVideoLoadProgress", "bytesTransferred", "", "totalBytes", "onVideoLoadStarted", "onVideoLoaded", "metadata", "Lio/dotlearn/lrnplayer/loader/model/VideoMetadata;", "videoDataBase64Encoded", "", "lrnplayer_release"})
    public static interface VideoLoadCallback {
        public void onVideoLoadStarted();

        public void onVideoLoadProgress(long var1, long var3);

        public void onVideoLoaded(@NotNull VideoMetadata var1, @NotNull String var2);

        public void onVideoLoadError(@NotNull Exception var1);
    }
}

