/*
 * Decompiled with CFR 0.152.
 */
package io.dotlearn.lrnplayer.loader;

import android.os.AsyncTask;
import android.util.Base64;
import io.dotlearn.lrnplayer.loader.FileUtils;
import io.dotlearn.lrnplayer.loader.di.Injector;
import io.dotlearn.lrnplayer.loader.model.VideoMetadata;
import io.dotlearn.lrnplayer.utils.IoUtils;
import io.dotlearn.lrnplayer.utils.Logger;
import io.paperdb.Paper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import javax.crypto.CipherInputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.encryptor4j.Encryptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0003\u001d\u001e\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\fJ\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u001d\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u0010J\u001f\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u0013J-\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019J%\u0010\u001a\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u001cR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lio/dotlearn/lrnplayer/loader/VideoDb;", "", "()V", "fileUtils", "Lio/dotlearn/lrnplayer/loader/FileUtils;", "ioUtils", "Lio/dotlearn/lrnplayer/utils/IoUtils;", "exist", "", "accessToken", "", "videoId", "exist$lrnplayer_release", "getDbKey", "getFile", "Ljava/io/File;", "getFile$lrnplayer_release", "getMetadata", "Lio/dotlearn/lrnplayer/loader/model/VideoMetadata;", "getMetadata$lrnplayer_release", "load", "", "key", "callback", "Lio/dotlearn/lrnplayer/loader/VideoDb$VideoLoadCallback;", "load$lrnplayer_release", "saveMetadata", "videoMetadata", "saveMetadata$lrnplayer_release", "VideoLoadCallback", "VideoLoadResponse", "VideoLoadTask", "lrnplayer_release"})
public final class VideoDb {
    private static final IoUtils ioUtils;
    private static final FileUtils fileUtils;
    public static final VideoDb INSTANCE;

    @NotNull
    public final File getFile$lrnplayer_release(@NotNull String accessToken, @NotNull String videoId) {
        Intrinsics.checkParameterIsNotNull((Object)accessToken, (String)"accessToken");
        Intrinsics.checkParameterIsNotNull((Object)videoId, (String)"videoId");
        return fileUtils.getVideoFile$lrnplayer_release(accessToken, videoId);
    }

    public final void saveMetadata$lrnplayer_release(@NotNull String accessToken, @NotNull String videoId, @NotNull VideoMetadata videoMetadata) {
        Intrinsics.checkParameterIsNotNull((Object)accessToken, (String)"accessToken");
        Intrinsics.checkParameterIsNotNull((Object)videoId, (String)"videoId");
        Intrinsics.checkParameterIsNotNull((Object)videoMetadata, (String)"videoMetadata");
        Logger.INSTANCE.d("Saving video metadata");
        Paper.book().write(this.getDbKey(accessToken, videoId), (Object)videoMetadata);
    }

    @Nullable
    public final VideoMetadata getMetadata$lrnplayer_release(@NotNull String accessToken, @NotNull String videoId) {
        Intrinsics.checkParameterIsNotNull((Object)accessToken, (String)"accessToken");
        Intrinsics.checkParameterIsNotNull((Object)videoId, (String)"videoId");
        return (VideoMetadata)Paper.book().read(this.getDbKey(accessToken, videoId), null);
    }

    public final void load$lrnplayer_release(@NotNull String accessToken, @NotNull String videoId, @NotNull String key, @NotNull VideoLoadCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)accessToken, (String)"accessToken");
        Intrinsics.checkParameterIsNotNull((Object)videoId, (String)"videoId");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        VideoLoadTask task = new VideoLoadTask(accessToken, videoId, key, callback);
        task.execute(new Void[0]);
    }

    public final boolean exist$lrnplayer_release(@NotNull String accessToken, @NotNull String videoId) {
        Intrinsics.checkParameterIsNotNull((Object)accessToken, (String)"accessToken");
        Intrinsics.checkParameterIsNotNull((Object)videoId, (String)"videoId");
        return this.getFile$lrnplayer_release(accessToken, videoId).exists() && this.getMetadata$lrnplayer_release(accessToken, videoId) != null;
    }

    private final String getDbKey(String accessToken, String videoId) {
        return videoId;
    }

    private VideoDb() {
    }

    static {
        VideoDb videoDb;
        INSTANCE = videoDb = new VideoDb();
        ioUtils = Injector.INSTANCE.provideIoUtils$lrnplayer_release();
        fileUtils = Injector.INSTANCE.provideFileUtils$lrnplayer_release();
    }

    @NotNull
    public static final /* synthetic */ IoUtils access$getIoUtils$p(VideoDb $this) {
        VideoDb videoDb = $this;
        return ioUtils;
    }

    @NotNull
    public static final /* synthetic */ FileUtils access$getFileUtils$p(VideoDb $this) {
        VideoDb videoDb = $this;
        return fileUtils;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ'\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0016\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00020\r\"\u0004\u0018\u00010\u0002H\u0014\u00a2\u0006\u0002\u0010\u000eJ\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/dotlearn/lrnplayer/loader/VideoDb$VideoLoadTask;", "Landroid/os/AsyncTask;", "Ljava/lang/Void;", "Lio/dotlearn/lrnplayer/loader/VideoDb$VideoLoadResponse;", "accessToken", "", "videoId", "key", "callback", "Lio/dotlearn/lrnplayer/loader/VideoDb$VideoLoadCallback;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lio/dotlearn/lrnplayer/loader/VideoDb$VideoLoadCallback;)V", "doInBackground", "params", "", "([Ljava/lang/Void;)Lio/dotlearn/lrnplayer/loader/VideoDb$VideoLoadResponse;", "onPostExecute", "", "response", "lrnplayer_release"})
    public static final class VideoLoadTask
    extends AsyncTask<Void, Void, VideoLoadResponse> {
        private final String accessToken;
        private final String videoId;
        private final String key;
        private final VideoLoadCallback callback;

        @Nullable
        protected VideoLoadResponse doInBackground(Void ... params) {
            VideoLoadResponse videoLoadResponse;
            Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
            Logger.INSTANCE.d("Loading vectorized video file in the background");
            try {
                Key secretKey = VideoDb.access$getIoUtils$p(INSTANCE).getSecretKey(this.key);
                Encryptor encryptor = new Encryptor(secretKey, "AES/CTR/NoPadding", 16);
                File videoFile = VideoDb.access$getFileUtils$p(INSTANCE).getVideoFile$lrnplayer_release(this.accessToken, this.videoId);
                CipherInputStream fis = encryptor.wrapInputStream((InputStream)new FileInputStream(videoFile));
                IoUtils ioUtils = VideoDb.access$getIoUtils$p(INSTANCE);
                CipherInputStream cipherInputStream = fis;
                Intrinsics.checkExpressionValueIsNotNull((Object)cipherInputStream, (String)"fis");
                byte[] videoDataBytes = ioUtils.toByteArray(cipherInputStream);
                String videoDataBase64Encoded = Base64.encodeToString((byte[])videoDataBytes, (int)0);
                VideoMetadata videoMetadata = INSTANCE.getMetadata$lrnplayer_release(this.accessToken, this.videoId);
                if (videoMetadata == null) {
                    Intrinsics.throwNpe();
                }
                String string = videoDataBase64Encoded;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"videoDataBase64Encoded");
                videoLoadResponse = new VideoLoadResponse(videoMetadata, string);
            }
            catch (Exception e) {
                e.printStackTrace();
                Logger.INSTANCE.e("Error loading video: " + e);
                videoLoadResponse = null;
            }
            return videoLoadResponse;
        }

        protected void onPostExecute(@Nullable VideoLoadResponse response) {
            if (response != null) {
                Logger.INSTANCE.d("VideoLoadTask completed with success. Response: " + response);
                this.callback.onVideoLoaded(response);
            } else {
                Logger.INSTANCE.e("VideoLoadTask completed with error");
                this.callback.onVideoLoadError(new IOException("Failed to read vectorized video file"));
            }
        }

        public VideoLoadTask(@NotNull String accessToken, @NotNull String videoId, @NotNull String key, @NotNull VideoLoadCallback callback) {
            Intrinsics.checkParameterIsNotNull((Object)accessToken, (String)"accessToken");
            Intrinsics.checkParameterIsNotNull((Object)videoId, (String)"videoId");
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
            this.accessToken = accessToken;
            this.videoId = videoId;
            this.key = key;
            this.callback = callback;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006H&J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH&\u00a8\u0006\n"}, d2={"Lio/dotlearn/lrnplayer/loader/VideoDb$VideoLoadCallback;", "", "onVideoLoadError", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onVideoLoaded", "videoData", "Lio/dotlearn/lrnplayer/loader/VideoDb$VideoLoadResponse;", "lrnplayer_release"})
    public static interface VideoLoadCallback {
        public void onVideoLoaded(@NotNull VideoLoadResponse var1);

        public void onVideoLoadError(@NotNull Exception var1);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lio/dotlearn/lrnplayer/loader/VideoDb$VideoLoadResponse;", "", "metadata", "Lio/dotlearn/lrnplayer/loader/model/VideoMetadata;", "bytesBase64Encoded", "", "(Lio/dotlearn/lrnplayer/loader/model/VideoMetadata;Ljava/lang/String;)V", "getBytesBase64Encoded", "()Ljava/lang/String;", "getMetadata", "()Lio/dotlearn/lrnplayer/loader/model/VideoMetadata;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "lrnplayer_release"})
    public static final class VideoLoadResponse {
        @NotNull
        private final VideoMetadata metadata;
        @NotNull
        private final String bytesBase64Encoded;

        @NotNull
        public final VideoMetadata getMetadata() {
            return this.metadata;
        }

        @NotNull
        public final String getBytesBase64Encoded() {
            return this.bytesBase64Encoded;
        }

        public VideoLoadResponse(@NotNull VideoMetadata metadata, @NotNull String bytesBase64Encoded) {
            Intrinsics.checkParameterIsNotNull((Object)metadata, (String)"metadata");
            Intrinsics.checkParameterIsNotNull((Object)bytesBase64Encoded, (String)"bytesBase64Encoded");
            this.metadata = metadata;
            this.bytesBase64Encoded = bytesBase64Encoded;
        }

        @NotNull
        public final VideoMetadata component1() {
            return this.metadata;
        }

        @NotNull
        public final String component2() {
            return this.bytesBase64Encoded;
        }

        @NotNull
        public final VideoLoadResponse copy(@NotNull VideoMetadata metadata, @NotNull String bytesBase64Encoded) {
            Intrinsics.checkParameterIsNotNull((Object)metadata, (String)"metadata");
            Intrinsics.checkParameterIsNotNull((Object)bytesBase64Encoded, (String)"bytesBase64Encoded");
            return new VideoLoadResponse(metadata, bytesBase64Encoded);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ VideoLoadResponse copy$default(VideoLoadResponse videoLoadResponse, VideoMetadata videoMetadata, String string, int n, Object object) {
            if ((n & 1) != 0) {
                videoMetadata = videoLoadResponse.metadata;
            }
            if ((n & 2) != 0) {
                string = videoLoadResponse.bytesBase64Encoded;
            }
            return videoLoadResponse.copy(videoMetadata, string);
        }

        public String toString() {
            return "VideoLoadResponse(metadata=" + this.metadata + ", bytesBase64Encoded=" + this.bytesBase64Encoded + ")";
        }

        public int hashCode() {
            VideoMetadata videoMetadata = this.metadata;
            String string = this.bytesBase64Encoded;
            return (videoMetadata != null ? ((Object)videoMetadata).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof VideoLoadResponse)) break block3;
                    VideoLoadResponse videoLoadResponse = (VideoLoadResponse)object;
                    if (!Intrinsics.areEqual((Object)this.metadata, (Object)videoLoadResponse.metadata) || !Intrinsics.areEqual((Object)this.bytesBase64Encoded, (Object)videoLoadResponse.bytesBase64Encoded)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

