/*
 * Decompiled with CFR 0.152.
 */
package io.dotlearn.lrnplayer;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.ConsoleMessage;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.TextView;
import io.dotlearn.lrnplayer.LRNPlayerContract;
import io.dotlearn.lrnplayer.LRNPlayerWebInterface;
import io.dotlearn.lrnplayer.R;
import io.dotlearn.lrnplayer.error.LRNPlayerException;
import io.dotlearn.lrnplayer.error.LRNPlayerNotPreparedException;
import io.dotlearn.lrnplayer.listener.OnDownloadProgressListener;
import io.dotlearn.lrnplayer.listener.OnErrorListener;
import io.dotlearn.lrnplayer.listener.OnFullScreenToggledListener;
import io.dotlearn.lrnplayer.listener.OnGetCurrentPositionListener;
import io.dotlearn.lrnplayer.listener.OnMetadataLoadedListener;
import io.dotlearn.lrnplayer.listener.OnPlaybackCompletionListener;
import io.dotlearn.lrnplayer.listener.OnPreparedListener;
import io.dotlearn.lrnplayer.loader.VideoLoader;
import io.dotlearn.lrnplayer.loader.model.VideoMetadata;
import io.dotlearn.lrnplayer.utils.DisplayUtils;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002:\u0001VB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020$H\u0002J\u001a\u0010%\u001a\u00020&2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010'\u001a\u00020&2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\nH\u0002J\u0010\u0010*\u001a\u00020&2\u0006\u0010+\u001a\u00020,H\u0002J0\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020\u00152\u0006\u0010/\u001a\u00020\n2\u0006\u00100\u001a\u00020\n2\u0006\u00101\u001a\u00020\n2\u0006\u00102\u001a\u00020\nH\u0014J\u0006\u00103\u001a\u00020&J\b\u00104\u001a\u00020&H\u0016J\u0012\u00105\u001a\u00020&2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J \u00105\u001a\u00020&2\u0006\u00106\u001a\u00020\"2\u0006\u00107\u001a\u00020\"2\u0006\u00108\u001a\u000209H\u0016J\b\u0010:\u001a\u00020&H\u0016J\u0010\u0010;\u001a\u00020&2\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020&2\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010A\u001a\u00020&2\u0006\u0010B\u001a\u00020CH\u0016J\u0010\u0010D\u001a\u00020&2\u0006\u0010E\u001a\u00020FH\u0016J\u0010\u0010G\u001a\u00020&2\u0006\u0010H\u001a\u00020IH\u0016J\u0010\u0010J\u001a\u00020&2\u0006\u0010K\u001a\u00020LH\u0016J\u0010\u0010M\u001a\u00020&2\u0006\u0010N\u001a\u00020OH\u0016J\b\u0010P\u001a\u00020&H\u0003J\u0010\u0010Q\u001a\u00020&2\u0006\u0010R\u001a\u00020\nH\u0016J\u0010\u0010S\u001a\u00020&2\u0006\u0010T\u001a\u00020\"H\u0016J\b\u0010U\u001a\u00020&H\u0016R\u000e\u0010\f\u001a\u00020\u0001X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Lio/dotlearn/lrnplayer/LRNPlayerView;", "Landroid/widget/FrameLayout;", "Lio/dotlearn/lrnplayer/LRNPlayerContract$PlayerView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "containerView", "displayUtils", "Lio/dotlearn/lrnplayer/utils/DisplayUtils;", "downloadProgressTextView", "Landroid/widget/TextView;", "errorContainer", "Landroid/view/View;", "errorTextView", "isPrepared", "", "isWebViewLoaded", "prepareRequest", "Lio/dotlearn/lrnplayer/LRNPlayerView$PrepareRequest;", "progressContainer", "webInterface", "Lio/dotlearn/lrnplayer/LRNPlayerWebInterface;", "webView", "Landroid/webkit/WebView;", "calculateWidthAndHeight", "Lkotlin/Pair;", "checkIsPrepared", "actionName", "", "getWindowManager", "Landroid/view/WindowManager;", "init", "", "loadVideo", "videoWidth", "videoHeight", "onError", "e", "Lio/dotlearn/lrnplayer/error/LRNPlayerException;", "onLayout", "changed", "l", "t", "r", "b", "onPrepared", "pause", "prepare", "accessToken", "videoId", "onPrepareListener", "Lio/dotlearn/lrnplayer/listener/OnPreparedListener;", "release", "seekTo", "seekPos", "", "setOnCompletionListener", "completionListener", "Lio/dotlearn/lrnplayer/listener/OnPlaybackCompletionListener;", "setOnDownloadListener", "downloadProgressListener", "Lio/dotlearn/lrnplayer/listener/OnDownloadProgressListener;", "setOnErrorListener", "errorListener", "Lio/dotlearn/lrnplayer/listener/OnErrorListener;", "setOnFullScreenToggledListener", "fullScreenToggledListener", "Lio/dotlearn/lrnplayer/listener/OnFullScreenToggledListener;", "setOnGetCurrentPositionListener", "getCurrentPositionListener", "Lio/dotlearn/lrnplayer/listener/OnGetCurrentPositionListener;", "setOnMetadataLoadedListener", "metadataLoadedListener", "Lio/dotlearn/lrnplayer/listener/OnMetadataLoadedListener;", "setupWebView", "showDownloadProgress", "downloadPercentage", "showError", "errorMsg", "start", "PrepareRequest", "lrnplayer_release"})
public final class LRNPlayerView
extends FrameLayout
implements LRNPlayerContract.PlayerView {
    private WebView webView;
    private View progressContainer;
    private TextView downloadProgressTextView;
    private View errorContainer;
    private TextView errorTextView;
    private FrameLayout containerView;
    private boolean isPrepared;
    private boolean isWebViewLoaded;
    private PrepareRequest prepareRequest;
    private LRNPlayerWebInterface webInterface;
    private DisplayUtils displayUtils;
    private HashMap _$_findViewCache;

    private final void init(AttributeSet attrs, int defStyle) {
        View layoutView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_lrnplayer, (ViewGroup)this);
        View view = layoutView.findViewById(R.id.lrn_container);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"layoutView.findViewById(R.id.lrn_container)");
        this.containerView = (FrameLayout)view;
        View view2 = layoutView.findViewById(R.id.lrn_web_view);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"layoutView.findViewById(R.id.lrn_web_view)");
        this.webView = (WebView)view2;
        View view3 = layoutView.findViewById(R.id.progress_container);
        Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"layoutView.findViewById(R.id.progress_container)");
        this.progressContainer = view3;
        View view4 = layoutView.findViewById(R.id.download_progress_text_view);
        Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"layoutView.findViewById(\u2026nload_progress_text_view)");
        this.downloadProgressTextView = (TextView)view4;
        View view5 = layoutView.findViewById(R.id.error_container);
        Intrinsics.checkExpressionValueIsNotNull((Object)view5, (String)"layoutView.findViewById(R.id.error_container)");
        this.errorContainer = view5;
        View view6 = layoutView.findViewById(R.id.error_text_view);
        Intrinsics.checkExpressionValueIsNotNull((Object)view6, (String)"layoutView.findViewById(R.id.error_text_view)");
        this.errorTextView = (TextView)view6;
        this.displayUtils = new DisplayUtils(this.getWindowManager());
        this.webInterface = new LRNPlayerWebInterface(this);
        this.setupWebView();
    }

    private final WindowManager getWindowManager() {
        Object object = this.getContext().getSystemService("window");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.WindowManager");
        }
        return (WindowManager)object;
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "AddJavascriptInterface"})
    private final void setupWebView() {
        WebSettings webSettings;
        WebView webView = this.webView;
        if (webView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
        }
        WebSettings webSettings2 = webSettings = webView.getSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)webSettings2, (String)"webSettings");
        webSettings2.setJavaScriptEnabled(true);
        WebView webView2 = this.webView;
        if (webView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
        }
        LRNPlayerWebInterface lRNPlayerWebInterface = this.webInterface;
        if (lRNPlayerWebInterface == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webInterface");
        }
        webView2.addJavascriptInterface((Object)lRNPlayerWebInterface, "Android");
        WebView webView3 = this.webView;
        if (webView3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
        }
        webView3.setWebChromeClient(new WebChromeClient(this){
            final /* synthetic */ LRNPlayerView this$0;

            public boolean onConsoleMessage(@NotNull ConsoleMessage consoleMessage) {
                Intrinsics.checkParameterIsNotNull((Object)consoleMessage, (String)"consoleMessage");
                LRNPlayerView.access$getWebInterface$p(this.this$0).log("Line no: " + consoleMessage.lineNumber() + ',' + " Source id: " + consoleMessage.sourceId() + ',' + " Message: " + consoleMessage.message());
                return true;
            }
            {
                this.this$0 = $outer;
            }
        });
        WebView webView4 = this.webView;
        if (webView4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
        }
        webView4.setWebViewClient(new WebViewClient(this){
            final /* synthetic */ LRNPlayerView this$0;

            public void onPageFinished(@NotNull WebView view, @NotNull String url) {
                Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                LRNPlayerView.access$setWebViewLoaded$p(this.this$0, true);
                LRNPlayerView.access$prepare(this.this$0, LRNPlayerView.access$getPrepareRequest$p(this.this$0));
            }
            {
                this.this$0 = $outer;
            }
        });
        WebView webView5 = this.webView;
        if (webView5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
        }
        webView5.loadUrl("file:///android_asset/base.html");
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.prepare(this.prepareRequest);
    }

    @Override
    public void prepare(@NotNull String accessToken, @NotNull String videoId, @NotNull OnPreparedListener onPrepareListener) {
        Intrinsics.checkParameterIsNotNull((Object)accessToken, (String)"accessToken");
        Intrinsics.checkParameterIsNotNull((Object)videoId, (String)"videoId");
        Intrinsics.checkParameterIsNotNull((Object)onPrepareListener, (String)"onPrepareListener");
        LRNPlayerWebInterface lRNPlayerWebInterface = this.webInterface;
        if (lRNPlayerWebInterface == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webInterface");
        }
        lRNPlayerWebInterface.setPrepareListener$lrnplayer_release(onPrepareListener);
        PrepareRequest prepareRequest = new PrepareRequest(accessToken, videoId);
        if (ViewCompat.isLaidOut((View)((View)this))) {
            LRNPlayerWebInterface lRNPlayerWebInterface2 = this.webInterface;
            if (lRNPlayerWebInterface2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"webInterface");
            }
            lRNPlayerWebInterface2.log("View is laid out. Preparing");
            this.prepare(prepareRequest);
        } else {
            LRNPlayerWebInterface lRNPlayerWebInterface3 = this.webInterface;
            if (lRNPlayerWebInterface3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"webInterface");
            }
            lRNPlayerWebInterface3.log("View is not laid out. Scheduling video preparation...");
            this.prepareRequest = prepareRequest;
        }
    }

    private final void prepare(PrepareRequest prepareRequest) {
        if (prepareRequest != null) {
            if (this.isWebViewLoaded) {
                Pair<Integer, Integer> widthHeightPair = this.calculateWidthAndHeight();
                this.loadVideo(prepareRequest, ((Number)widthHeightPair.getFirst()).intValue(), ((Number)widthHeightPair.getSecond()).intValue());
                this.prepareRequest = null;
            } else {
                this.prepareRequest = prepareRequest;
            }
        }
    }

    private final Pair<Integer, Integer> calculateWidthAndHeight() {
        int videoHeight;
        DisplayUtils displayUtils = this.displayUtils;
        if (displayUtils == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"displayUtils");
        }
        int videoWidth = displayUtils.px2dp$lrnplayer_release(this.getWidth());
        DisplayUtils displayUtils2 = this.displayUtils;
        if (displayUtils2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"displayUtils");
        }
        int usableScreenHeight = displayUtils2.getUsableScreenHeight$lrnplayer_release();
        DisplayUtils displayUtils3 = this.displayUtils;
        if (displayUtils3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"displayUtils");
        }
        if ((videoHeight = displayUtils3.calculateHeightBasedOnWidthAndAspectRatio$lrnplayer_release(1.77777778, videoWidth)) > usableScreenHeight) {
            videoHeight = usableScreenHeight;
        }
        return new Pair((Object)videoWidth, (Object)videoHeight);
    }

    private final void loadVideo(PrepareRequest prepareRequest, int videoWidth, int videoHeight) {
        View view = this.progressContainer;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressContainer");
        }
        view.setVisibility(0);
        View view2 = this.errorContainer;
        if (view2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"errorContainer");
        }
        view2.setVisibility(8);
        TextView textView = this.downloadProgressTextView;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"downloadProgressTextView");
        }
        textView.setText((CharSequence)"0%");
        this.isPrepared = false;
        VideoLoader.INSTANCE.load$lrnplayer_release(prepareRequest.getAccessToken(), prepareRequest.getVideoId(), new VideoLoader.VideoLoadCallback(this, videoWidth, videoHeight){
            final /* synthetic */ LRNPlayerView this$0;
            final /* synthetic */ int $videoWidth;
            final /* synthetic */ int $videoHeight;

            public void onVideoLoadStarted() {
                LRNPlayerView.access$getWebInterface$p(this.this$0).log("onVideoLoadStarted()");
            }

            public void onVideoLoadProgress(long bytesTransferred, long totalBytes) {
                LRNPlayerView.access$getWebInterface$p(this.this$0).log("onVideoLoadProgress()");
                LRNPlayerView.access$getWebInterface$p(this.this$0).onDownloadProgress(bytesTransferred, totalBytes);
            }

            public void onVideoLoaded(@NotNull VideoMetadata metadata, @NotNull String videoDataBase64Encoded) {
                Intrinsics.checkParameterIsNotNull((Object)metadata, (String)"metadata");
                Intrinsics.checkParameterIsNotNull((Object)videoDataBase64Encoded, (String)"videoDataBase64Encoded");
                LRNPlayerView.access$getWebInterface$p(this.this$0).log("onVideoLoaded");
                String stringToLoad = StringsKt.trimMargin$default((String)("javascript:loadVideo(\"" + videoDataBase64Encoded + "\",\n                                \"" + this.$videoWidth + "\", \"" + this.$videoHeight + "\", false, false);"), null, (int)1, null);
                LRNPlayerView.access$getWebView$p(this.this$0).loadUrl(stringToLoad);
            }

            public void onVideoLoadError(@NotNull Exception e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                LRNPlayerView.access$getWebInterface$p(this.this$0).log("onVideoLoadError");
                LRNPlayerView.access$getWebInterface$p(this.this$0).onError(new LRNPlayerException(e.toString()));
            }
            {
                this.this$0 = $outer;
                this.$videoWidth = $captured_local_variable$1;
                this.$videoHeight = $captured_local_variable$2;
            }
        });
    }

    public final void onPrepared() {
        View view = this.progressContainer;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressContainer");
        }
        view.setVisibility(8);
        View view2 = this.errorContainer;
        if (view2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"errorContainer");
        }
        view2.setVisibility(8);
        this.isPrepared = true;
    }

    @Override
    public void start() {
        if (this.checkIsPrepared("start()")) {
            WebView webView = this.webView;
            if (webView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            }
            webView.loadUrl("javascript:play();");
        }
    }

    @Override
    public void pause() {
        if (this.checkIsPrepared("pause()")) {
            WebView webView = this.webView;
            if (webView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            }
            webView.loadUrl("javascript:pause();");
        }
    }

    @Override
    public void seekTo(long seekPos) {
        if (this.checkIsPrepared("seekTo()")) {
            WebView webView = this.webView;
            if (webView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            }
            webView.loadUrl("javascript:seekTo(\"" + seekPos + "\");");
        }
    }

    @Override
    public void setOnCompletionListener(@NotNull OnPlaybackCompletionListener completionListener) {
        Intrinsics.checkParameterIsNotNull((Object)completionListener, (String)"completionListener");
        LRNPlayerWebInterface lRNPlayerWebInterface = this.webInterface;
        if (lRNPlayerWebInterface == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webInterface");
        }
        lRNPlayerWebInterface.setCompletionListener$lrnplayer_release(completionListener);
    }

    @Override
    public void setOnErrorListener(@NotNull OnErrorListener errorListener) {
        Intrinsics.checkParameterIsNotNull((Object)errorListener, (String)"errorListener");
        LRNPlayerWebInterface lRNPlayerWebInterface = this.webInterface;
        if (lRNPlayerWebInterface == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webInterface");
        }
        lRNPlayerWebInterface.setErrorListener$lrnplayer_release(errorListener);
    }

    @Override
    public void setOnGetCurrentPositionListener(@NotNull OnGetCurrentPositionListener getCurrentPositionListener) {
        Intrinsics.checkParameterIsNotNull((Object)getCurrentPositionListener, (String)"getCurrentPositionListener");
        LRNPlayerWebInterface lRNPlayerWebInterface = this.webInterface;
        if (lRNPlayerWebInterface == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webInterface");
        }
        lRNPlayerWebInterface.setGetCurrentPositionListener$lrnplayer_release(getCurrentPositionListener);
    }

    @Override
    public void setOnDownloadListener(@NotNull OnDownloadProgressListener downloadProgressListener) {
        Intrinsics.checkParameterIsNotNull((Object)downloadProgressListener, (String)"downloadProgressListener");
        LRNPlayerWebInterface lRNPlayerWebInterface = this.webInterface;
        if (lRNPlayerWebInterface == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webInterface");
        }
        lRNPlayerWebInterface.setDownloadProgressListener$lrnplayer_release(downloadProgressListener);
    }

    @Override
    public void setOnMetadataLoadedListener(@NotNull OnMetadataLoadedListener metadataLoadedListener) {
        Intrinsics.checkParameterIsNotNull((Object)metadataLoadedListener, (String)"metadataLoadedListener");
        LRNPlayerWebInterface lRNPlayerWebInterface = this.webInterface;
        if (lRNPlayerWebInterface == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webInterface");
        }
        lRNPlayerWebInterface.setMetadataLoadedListener$lrnplayer_release(metadataLoadedListener);
    }

    @Override
    public void setOnFullScreenToggledListener(@NotNull OnFullScreenToggledListener fullScreenToggledListener) {
        Intrinsics.checkParameterIsNotNull((Object)fullScreenToggledListener, (String)"fullScreenToggledListener");
        LRNPlayerWebInterface lRNPlayerWebInterface = this.webInterface;
        if (lRNPlayerWebInterface == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webInterface");
        }
        lRNPlayerWebInterface.setFullScreenToggledListener$lrnplayer_release(fullScreenToggledListener);
    }

    @Override
    public void showError(@NotNull String errorMsg) {
        Intrinsics.checkParameterIsNotNull((Object)errorMsg, (String)"errorMsg");
        View view = this.progressContainer;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressContainer");
        }
        view.setVisibility(8);
        View view2 = this.errorContainer;
        if (view2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"errorContainer");
        }
        view2.setVisibility(0);
        TextView textView = this.errorTextView;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"errorTextView");
        }
        textView.setText((CharSequence)errorMsg);
    }

    @Override
    public void showDownloadProgress(int downloadPercentage) {
        String progressText = String.valueOf(downloadPercentage) + "%";
        TextView textView = this.downloadProgressTextView;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"downloadProgressTextView");
        }
        textView.setText((CharSequence)progressText);
    }

    @Override
    public void release() {
        VideoLoader.INSTANCE.cancel$lrnplayer_release();
        FrameLayout frameLayout = this.containerView;
        if (frameLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"containerView");
        }
        frameLayout.removeAllViews();
        WebView webView = this.webView;
        if (webView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
        }
        webView.clearHistory();
        WebView webView2 = this.webView;
        if (webView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
        }
        webView2.clearCache(false);
        WebView webView3 = this.webView;
        if (webView3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
        }
        webView3.loadUrl("about:blank");
        WebView webView4 = this.webView;
        if (webView4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
        }
        webView4.onPause();
        WebView webView5 = this.webView;
        if (webView5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
        }
        webView5.destroy();
    }

    private final void onError(LRNPlayerException e) {
        LRNPlayerWebInterface lRNPlayerWebInterface = this.webInterface;
        if (lRNPlayerWebInterface == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webInterface");
        }
        lRNPlayerWebInterface.onError(e);
    }

    private final boolean checkIsPrepared(String actionName) {
        if (!this.isPrepared) {
            this.onError(new LRNPlayerNotPreparedException("LRNPlayerView is not prepared. " + "Ensure that the Player is prepared before calling " + actionName));
            return false;
        }
        return true;
    }

    public LRNPlayerView(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.init(null, 0);
    }

    public LRNPlayerView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.init(attrs, 0);
    }

    public LRNPlayerView(@NotNull Context context, @NotNull AttributeSet attrs, int defStyle) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs, defStyle);
        this.init(attrs, defStyle);
    }

    @NotNull
    public static final /* synthetic */ LRNPlayerWebInterface access$getWebInterface$p(LRNPlayerView $this) {
        LRNPlayerWebInterface lRNPlayerWebInterface = $this.webInterface;
        if (lRNPlayerWebInterface == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webInterface");
        }
        return lRNPlayerWebInterface;
    }

    public static final /* synthetic */ void access$setWebInterface$p(LRNPlayerView $this, @NotNull LRNPlayerWebInterface lRNPlayerWebInterface) {
        $this.webInterface = lRNPlayerWebInterface;
    }

    public static final /* synthetic */ boolean access$isWebViewLoaded$p(LRNPlayerView $this) {
        return $this.isWebViewLoaded;
    }

    public static final /* synthetic */ void access$setWebViewLoaded$p(LRNPlayerView $this, boolean bl) {
        $this.isWebViewLoaded = bl;
    }

    public static final /* synthetic */ void access$prepare(LRNPlayerView $this, @Nullable PrepareRequest prepareRequest) {
        $this.prepare(prepareRequest);
    }

    @Nullable
    public static final /* synthetic */ PrepareRequest access$getPrepareRequest$p(LRNPlayerView $this) {
        return $this.prepareRequest;
    }

    public static final /* synthetic */ void access$setPrepareRequest$p(LRNPlayerView $this, @Nullable PrepareRequest prepareRequest) {
        $this.prepareRequest = prepareRequest;
    }

    @NotNull
    public static final /* synthetic */ WebView access$getWebView$p(LRNPlayerView $this) {
        WebView webView = $this.webView;
        if (webView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
        }
        return webView;
    }

    public static final /* synthetic */ void access$setWebView$p(LRNPlayerView $this, @NotNull WebView webView) {
        $this.webView = webView;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"Lio/dotlearn/lrnplayer/LRNPlayerView$PrepareRequest;", "", "accessToken", "", "videoId", "(Ljava/lang/String;Ljava/lang/String;)V", "getAccessToken", "()Ljava/lang/String;", "getVideoId", "lrnplayer_release"})
    public static final class PrepareRequest {
        @NotNull
        private final String accessToken;
        @NotNull
        private final String videoId;

        @NotNull
        public final String getAccessToken() {
            return this.accessToken;
        }

        @NotNull
        public final String getVideoId() {
            return this.videoId;
        }

        public PrepareRequest(@NotNull String accessToken, @NotNull String videoId) {
            Intrinsics.checkParameterIsNotNull((Object)accessToken, (String)"accessToken");
            Intrinsics.checkParameterIsNotNull((Object)videoId, (String)"videoId");
            this.accessToken = accessToken;
            this.videoId = videoId;
        }
    }
}

