/*
 * Decompiled with CFR 0.152.
 */
package org.dotlearn.lrncurriculum;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.dotlearn.lrncurriculum.data.local.CourseDb;
import org.dotlearn.lrncurriculum.data.local.LessonDb;
import org.dotlearn.lrncurriculum.data.local.SectionDb;
import org.dotlearn.lrncurriculum.data.local.VideoDb;
import org.dotlearn.lrncurriculum.data.remote.CourseLoader;
import org.dotlearn.lrncurriculum.data.remote.LessonLoader;
import org.dotlearn.lrncurriculum.data.remote.SectionLoader;
import org.dotlearn.lrncurriculum.data.remote.VideoLoader;
import org.dotlearn.lrncurriculum.di.Injector;
import org.dotlearn.lrncurriculum.models.Course;
import org.dotlearn.lrncurriculum.models.Lesson;
import org.dotlearn.lrncurriculum.models.Section;
import org.dotlearn.lrncurriculum.models.Video;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00162\u0006\u0010\u001a\u001a\u00020\u001bJ\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00162\u0006\u0010\u001e\u001a\u00020\u001bJ\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00162\u0006\u0010!\u001a\u00020\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/dotlearn/lrncurriculum/CurriculumSync;", "", "()V", "courseDb", "Lorg/dotlearn/lrncurriculum/data/local/CourseDb;", "courseLoader", "Lorg/dotlearn/lrncurriculum/data/remote/CourseLoader;", "lessonDb", "Lorg/dotlearn/lrncurriculum/data/local/LessonDb;", "lessonLoader", "Lorg/dotlearn/lrncurriculum/data/remote/LessonLoader;", "sectionDb", "Lorg/dotlearn/lrncurriculum/data/local/SectionDb;", "sectionLoader", "Lorg/dotlearn/lrncurriculum/data/remote/SectionLoader;", "videoDb", "Lorg/dotlearn/lrncurriculum/data/local/VideoDb;", "videoLoader", "Lorg/dotlearn/lrncurriculum/data/remote/VideoLoader;", "syncAll", "", "syncCourses", "", "Lorg/dotlearn/lrncurriculum/models/Course;", "syncLessons", "Lorg/dotlearn/lrncurriculum/models/Lesson;", "sectionId", "", "syncSections", "Lorg/dotlearn/lrncurriculum/models/Section;", "courseId", "syncVideos", "Lorg/dotlearn/lrncurriculum/models/Video;", "lessonId", "lrncurriculum_release"})
public final class CurriculumSync {
    private static final CourseDb courseDb;
    private static final CourseLoader courseLoader;
    private static final SectionDb sectionDb;
    private static final SectionLoader sectionLoader;
    private static final LessonDb lessonDb;
    private static final LessonLoader lessonLoader;
    private static final VideoDb videoDb;
    private static final VideoLoader videoLoader;
    public static final CurriculumSync INSTANCE;

    private final void syncAll() {
        List<Course> courses = this.syncCourses();
        for (Course course : courses) {
            List<Section> sections = this.syncSections(course.getId());
            for (Section section : sections) {
                List<Lesson> lessons = this.syncLessons(section.getId());
                for (Lesson lesson : lessons) {
                    this.syncVideos(lesson.getId());
                }
            }
        }
    }

    @NotNull
    public final List<Course> syncCourses() {
        List<Course> remoteCourses = courseLoader.loadAllCourses$lrncurriculum_release();
        courseDb.saveCourses$lrncurriculum_release(remoteCourses);
        return remoteCourses;
    }

    @NotNull
    public final List<Section> syncSections(@NotNull String courseId) {
        Intrinsics.checkParameterIsNotNull((Object)courseId, (String)"courseId");
        List<Section> remoteSections = sectionLoader.loadSectionsInCourse$lrncurriculum_release(courseId);
        sectionDb.saveSections$lrncurriculum_release(courseId, remoteSections);
        return remoteSections;
    }

    @NotNull
    public final List<Lesson> syncLessons(@NotNull String sectionId) {
        Intrinsics.checkParameterIsNotNull((Object)sectionId, (String)"sectionId");
        List<Lesson> remoteLessons = lessonLoader.loadLessonInSection$lrncurriculum_release(sectionId);
        lessonDb.saveLessons$lrncurriculum_release(sectionId, remoteLessons);
        return remoteLessons;
    }

    @NotNull
    public final List<Video> syncVideos(@NotNull String lessonId) {
        Intrinsics.checkParameterIsNotNull((Object)lessonId, (String)"lessonId");
        List<Video> remoteVideos = videoLoader.loadVideosInLesson$lrncurriculum_release(lessonId);
        videoDb.saveVideos(lessonId, remoteVideos);
        return remoteVideos;
    }

    private CurriculumSync() {
    }

    static {
        CurriculumSync curriculumSync;
        INSTANCE = curriculumSync = new CurriculumSync();
        courseDb = Injector.INSTANCE.provideCourseDb$lrncurriculum_release();
        sectionDb = Injector.INSTANCE.provideSectionDb$lrncurriculum_release();
        lessonDb = Injector.INSTANCE.provideLessonDb$lrncurriculum_release();
        videoDb = Injector.INSTANCE.provideVideoDb$lrncurriculum_release();
        courseLoader = Injector.INSTANCE.provideCourseLoader$lrncurriculum_release();
        sectionLoader = Injector.INSTANCE.provideSectionLoader$lrncurriculum_release();
        lessonLoader = Injector.INSTANCE.provideLessonLoader$lrncurriculum_release();
        videoLoader = Injector.INSTANCE.provideVideoLoader$lrncurriculum_release();
    }
}

