/*
 * Decompiled with CFR 0.152.
 */
package org.dotlearn.lrncurriculum;

import android.content.Context;
import io.paperdb.Paper;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.dotlearn.lrncurriculum.data.local.CourseDb;
import org.dotlearn.lrncurriculum.data.local.LessonDb;
import org.dotlearn.lrncurriculum.data.local.SectionDb;
import org.dotlearn.lrncurriculum.data.local.VideoDb;
import org.dotlearn.lrncurriculum.data.remote.CourseLoader;
import org.dotlearn.lrncurriculum.data.remote.LessonLoader;
import org.dotlearn.lrncurriculum.data.remote.SearchLoader;
import org.dotlearn.lrncurriculum.data.remote.SectionLoader;
import org.dotlearn.lrncurriculum.data.remote.VideoLoader;
import org.dotlearn.lrncurriculum.di.Injector;
import org.dotlearn.lrncurriculum.models.Course;
import org.dotlearn.lrncurriculum.models.Lesson;
import org.dotlearn.lrncurriculum.models.Section;
import org.dotlearn.lrncurriculum.models.Video;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00162\u0006\u0010\u001a\u001a\u00020\u001bJ\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00162\u0006\u0010\u001e\u001a\u00020\u001bJ\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00162\u0006\u0010!\u001a\u00020\u001bJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u001c\u0010&\u001a\b\u0012\u0004\u0012\u00020 0\u00162\u0006\u0010'\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/dotlearn/lrncurriculum/CurriculumProvider;", "", "()V", "courseDb", "Lorg/dotlearn/lrncurriculum/data/local/CourseDb;", "courseLoader", "Lorg/dotlearn/lrncurriculum/data/remote/CourseLoader;", "lessonDb", "Lorg/dotlearn/lrncurriculum/data/local/LessonDb;", "lessonLoader", "Lorg/dotlearn/lrncurriculum/data/remote/LessonLoader;", "searchLoader", "Lorg/dotlearn/lrncurriculum/data/remote/SearchLoader;", "sectionDb", "Lorg/dotlearn/lrncurriculum/data/local/SectionDb;", "sectionLoader", "Lorg/dotlearn/lrncurriculum/data/remote/SectionLoader;", "videoDb", "Lorg/dotlearn/lrncurriculum/data/local/VideoDb;", "videoLoader", "Lorg/dotlearn/lrncurriculum/data/remote/VideoLoader;", "getCourses", "", "Lorg/dotlearn/lrncurriculum/models/Course;", "getLessons", "Lorg/dotlearn/lrncurriculum/models/Lesson;", "sectionId", "", "getSections", "Lorg/dotlearn/lrncurriculum/models/Section;", "courseId", "getVideos", "Lorg/dotlearn/lrncurriculum/models/Video;", "lessonId", "init", "", "context", "Landroid/content/Context;", "searchVideos", "searchTerm", "lrncurriculum_release"})
public final class CurriculumProvider {
    private static CourseDb courseDb;
    private static CourseLoader courseLoader;
    private static SectionDb sectionDb;
    private static SectionLoader sectionLoader;
    private static LessonDb lessonDb;
    private static LessonLoader lessonLoader;
    private static VideoDb videoDb;
    private static VideoLoader videoLoader;
    private static SearchLoader searchLoader;
    public static final CurriculumProvider INSTANCE;

    public final void init(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Paper.init((Context)context);
        courseDb = Injector.INSTANCE.provideCourseDb$lrncurriculum_release();
        sectionDb = Injector.INSTANCE.provideSectionDb$lrncurriculum_release();
        lessonDb = Injector.INSTANCE.provideLessonDb$lrncurriculum_release();
        videoDb = Injector.INSTANCE.provideVideoDb$lrncurriculum_release();
        courseLoader = Injector.INSTANCE.provideCourseLoader$lrncurriculum_release();
        sectionLoader = Injector.INSTANCE.provideSectionLoader$lrncurriculum_release();
        lessonLoader = Injector.INSTANCE.provideLessonLoader$lrncurriculum_release();
        videoLoader = Injector.INSTANCE.provideVideoLoader$lrncurriculum_release();
        searchLoader = Injector.INSTANCE.provideSearchLoader$lrncurriculum_release();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Course> getCourses() {
        List<Course> list;
        List<Course> localCourses;
        CourseDb courseDb = CurriculumProvider.courseDb;
        if (courseDb == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"courseDb");
        }
        if ((localCourses = courseDb.getCourses$lrncurriculum_release()) == null) {
            void var2_2;
            CourseLoader courseLoader = CurriculumProvider.courseLoader;
            if (courseLoader == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"courseLoader");
            }
            List<Course> remoteCourses = courseLoader.loadAllCourses$lrncurriculum_release();
            CourseDb courseDb2 = CurriculumProvider.courseDb;
            if (courseDb2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"courseDb");
            }
            courseDb2.saveCourses$lrncurriculum_release(remoteCourses);
            list = var2_2;
        } else {
            list = localCourses;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Section> getSections(@NotNull String courseId) {
        List<Section> list;
        List<Section> localSections;
        Intrinsics.checkParameterIsNotNull((Object)courseId, (String)"courseId");
        SectionDb sectionDb = CurriculumProvider.sectionDb;
        if (sectionDb == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sectionDb");
        }
        if ((localSections = sectionDb.getSections$lrncurriculum_release(courseId)) == null) {
            void var3_3;
            SectionLoader sectionLoader = CurriculumProvider.sectionLoader;
            if (sectionLoader == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sectionLoader");
            }
            List<Section> remoteSections = sectionLoader.loadSectionsInCourse$lrncurriculum_release(courseId);
            SectionDb sectionDb2 = CurriculumProvider.sectionDb;
            if (sectionDb2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sectionDb");
            }
            sectionDb2.saveSections$lrncurriculum_release(courseId, remoteSections);
            list = var3_3;
        } else {
            list = localSections;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Lesson> getLessons(@NotNull String sectionId) {
        List<Lesson> list;
        List<Lesson> localLessons;
        Intrinsics.checkParameterIsNotNull((Object)sectionId, (String)"sectionId");
        LessonDb lessonDb = CurriculumProvider.lessonDb;
        if (lessonDb == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lessonDb");
        }
        if ((localLessons = lessonDb.getLessons$lrncurriculum_release(sectionId)) == null) {
            void var3_3;
            LessonLoader lessonLoader = CurriculumProvider.lessonLoader;
            if (lessonLoader == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"lessonLoader");
            }
            List<Lesson> remoteLessons = lessonLoader.loadLessonInSection$lrncurriculum_release(sectionId);
            LessonDb lessonDb2 = CurriculumProvider.lessonDb;
            if (lessonDb2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"lessonDb");
            }
            lessonDb2.saveLessons$lrncurriculum_release(sectionId, remoteLessons);
            list = var3_3;
        } else {
            list = localLessons;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Video> getVideos(@NotNull String lessonId) {
        List<Video> list;
        List<Video> localVideos;
        Intrinsics.checkParameterIsNotNull((Object)lessonId, (String)"lessonId");
        VideoDb videoDb = CurriculumProvider.videoDb;
        if (videoDb == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"videoDb");
        }
        if ((localVideos = videoDb.getVideos(lessonId)) == null) {
            void var3_3;
            VideoLoader videoLoader = CurriculumProvider.videoLoader;
            if (videoLoader == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"videoLoader");
            }
            List<Video> remoteVideos = videoLoader.loadVideosInLesson$lrncurriculum_release(lessonId);
            VideoDb videoDb2 = CurriculumProvider.videoDb;
            if (videoDb2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"videoDb");
            }
            videoDb2.saveVideos(lessonId, remoteVideos);
            list = var3_3;
        } else {
            list = localVideos;
        }
        return list;
    }

    @NotNull
    public final List<Video> searchVideos(@NotNull String searchTerm, @NotNull String courseId) {
        Intrinsics.checkParameterIsNotNull((Object)searchTerm, (String)"searchTerm");
        Intrinsics.checkParameterIsNotNull((Object)courseId, (String)"courseId");
        SearchLoader searchLoader = CurriculumProvider.searchLoader;
        if (searchLoader == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchLoader");
        }
        return searchLoader.loadVideosWithName$lrncurriculum_release(searchTerm, courseId);
    }

    private CurriculumProvider() {
    }

    static {
        CurriculumProvider curriculumProvider;
        INSTANCE = curriculumProvider = new CurriculumProvider();
    }
}

