package jsbridge.library;

import android.util.Log;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by domin on 5/30/16.
 */
public abstract class WebAppInterface {

    private WebView mWebView;
    private String mInjectedName;

    @JavascriptInterface
    public void invoke(String method, String params, int position){
        Log.w("WebAppInterface","*********************");
        try {
            JSONObject json = new JSONObject(params);
            JsCallback callback = null;
            if (position >= 0) {
                callback = new JsCallback(mWebView, mInjectedName, position);
            }
            invoke(method,json,callback);
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public abstract void invoke(String method, JSONObject params, JsCallback callback);

    public void setWebView(WebView webView) {
        this.mWebView = webView;
    }

    public void setInjectedName(String injectedName) {
        this.mInjectedName = injectedName;
    }

}
