package jsbridge.library;

import android.webkit.WebView;

import org.json.JSONObject;

/**
 * Created by domin on 5/30/16.
 */
public class JsCallback {

    private static final String TAG="JsCallback";

    private int mIndex;
    private WebView mWebView;
    private String mInjectedName;

    public JsCallback(WebView webView,String injectedName,int index){
        this.mWebView = webView;
        this.mInjectedName = injectedName;
        this.mIndex = index;
    }

    public void callback(final JSONObject response){
        if(mIndex >= 0) {
            mWebView.post(new Runnable() {
                @Override
                public void run() {
                    mWebView.loadUrl("javascript:" + mInjectedName + ".callback(" + response + "," + mIndex + ")");
                }
            });
        } else {
            throw new NullPointerException("this method no callback");
        }
    }
}
