package jsbridge.library;

import android.util.Log;
import android.webkit.WebChromeClient;
import android.webkit.WebView;

/**
 * Created by domin on 5/30/16.
 */
public class InjectedChromeClient extends WebChromeClient{
    private static final String TAG = "InjectedChromeClient";

    private String mInjectedJs;
    private boolean mIsInjectedJS;
    private String  mInjectedName;

    public InjectedChromeClient(String injectedName) {
        this.mInjectedName = injectedName;
        mInjectedJs = "javascript:var "+
                mInjectedName +" = {queue:[],invoke:function(method,params,callback){if(params == null){params = {\"params\" : null};}if(callback != null){Android_"+
                mInjectedName+".invoke(method,JSON.stringify(params),this.queue.length);this.queue[this.queue.length] = callback;} else {Android_"+
                mInjectedName+".invoke(method,JSON.stringify(params),-1);}},callback:function(res,position){this.queue[position].apply(this,arguments);}};";
    }

    @Override
    public void onProgressChanged(WebView view, int newProgress) {
        if (newProgress <= 25) {
            mIsInjectedJS = false;
        } else if (!mIsInjectedJS) {
            view.loadUrl(mInjectedJs);
            mIsInjectedJS = true;
            Log.w(TAG, " inject js interface completely on progress " + newProgress);

        }
        super.onProgressChanged(view, newProgress);
    }

    public String getInjectedName() {
        return mInjectedName;
    }
}
