/*
 * Decompiled with CFR 0.152.
 */
package com.martin.audiolib.record;

import android.content.Context;
import android.media.AudioRecord;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.text.TextUtils;
import com.martin.audiolib.AudioThreadManager;
import com.martin.audiolib.AudioUtilKt;
import com.martin.audiolib.record.BaserRecord;
import com.martin.audiolib.record.RecordWrapper;
import java.util.concurrent.Semaphore;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000C\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0010*\u0001\u0013\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u000bH$J\b\u0010\u0019\u001a\u00020\u0006H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u000bH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\bH$J\b\u0010\u001c\u001a\u00020\u000fH\u0002J\b\u0010\u001d\u001a\u00020\u000fH\u0016J\b\u0010\u001e\u001a\u00020\u0016H\u0002J\u001c\u0010\u001f\u001a\u00020\u00162\b\u0010 \u001a\u0004\u0018\u00010\u000b2\b\u0010!\u001a\u0004\u0018\u00010\bH$J\u000e\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u000fJ\u0010\u0010$\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u000bH\u0016J\b\u0010%\u001a\u00020\u0016H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014\u00a8\u0006&"}, d2={"Lcom/martin/audiolib/record/RecordWrapper;", "Lcom/martin/audiolib/record/BaserRecord;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "MAX_RECORD_TIME", "", "mAudioRecord", "Landroid/media/AudioRecord;", "mContext", "mFilePath", "", "mFileWriteSemaphore", "Ljava/util/concurrent/Semaphore;", "mHasError", "", "mIsRecording", "mStartRecordTime", "stopHandler", "com/martin/audiolib/record/RecordWrapper$stopHandler$1", "Lcom/martin/audiolib/record/RecordWrapper$stopHandler$1;", "doRecordStart", "", "doRecordStop", "getFileSuffix", "getRecordDuration", "getRecordPath", "initAudioRecord", "isAudioRecordRecording", "isRecording", "readAudioDataAndWrite2File", "readAudioDataAndWrite2FileImpl", "filePath", "audioRecord", "setHasError", "hasError", "startRecord", "stopRecord", "AudioLib_release"})
public abstract class RecordWrapper
extends BaserRecord {
    private final long MAX_RECORD_TIME;
    private Context mContext;
    private boolean mHasError;
    private AudioRecord mAudioRecord;
    private boolean mIsRecording;
    private String mFilePath;
    private Semaphore mFileWriteSemaphore;
    private long mStartRecordTime;
    private stopHandler.1 stopHandler;

    @Override
    public void startRecord(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (this.isRecording()) {
            return;
        }
        this.mIsRecording = true;
        this.mHasError = false;
        this.mFilePath = filePath;
        this.stopHandler.removeCallbacksAndMessages(null);
        this.stopHandler.sendEmptyMessageDelayed(0, this.MAX_RECORD_TIME);
        this.mStartRecordTime = SystemClock.uptimeMillis();
        AudioThreadManager.INSTANCE.execute(new Runnable(this){
            final /* synthetic */ RecordWrapper this$0;

            public final void run() {
                RecordWrapper.access$doRecordStart(this.this$0);
            }
            {
                this.this$0 = recordWrapper;
            }
        });
    }

    private final void doRecordStart() {
        if (TextUtils.isEmpty((CharSequence)this.mFilePath)) {
            this.mHasError = true;
            this.notifyRecordError("", 1, null);
            return;
        }
        this.mAudioRecord = this.initAudioRecord();
        if (this.mAudioRecord == null) {
            throw (Throwable)new RuntimeException("AudioRecord must be init");
        }
        try {
            AudioRecord audioRecord = this.mAudioRecord;
            Intrinsics.checkNotNull((Object)audioRecord);
            audioRecord.startRecording();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mHasError = true;
            String string = this.mFilePath;
            Intrinsics.checkNotNull((Object)string);
            this.notifyRecordError(string, 2, "no permission ---");
            return;
        }
        if (!this.isAudioRecordRecording()) {
            AudioUtilKt.log_e("start record failed, no record permission");
            this.mHasError = true;
            String string = this.mFilePath;
            Intrinsics.checkNotNull((Object)string);
            this.notifyRecordError(string, 2, "no permission ===");
            return;
        }
        AudioThreadManager.INSTANCE.execute(new Runnable(this){
            final /* synthetic */ RecordWrapper this$0;

            public final void run() {
                RecordWrapper.access$readAudioDataAndWrite2File(this.this$0);
            }
            {
                this.this$0 = recordWrapper;
            }
        });
    }

    @Override
    public void stopRecord() {
        this.stopHandler.removeCallbacksAndMessages(null);
        if (!this.isRecording()) {
            return;
        }
        AudioThreadManager.INSTANCE.execute(new Runnable(this){
            final /* synthetic */ RecordWrapper this$0;

            public final void run() {
                RecordWrapper.access$doRecordStop(this.this$0);
            }
            {
                this.this$0 = recordWrapper;
            }
        });
    }

    private final void doRecordStop() {
        if (this.isAudioRecordRecording()) {
            try {
                AudioRecord audioRecord = this.mAudioRecord;
                if (audioRecord != null) {
                    audioRecord.stop();
                }
                AudioRecord audioRecord2 = this.mAudioRecord;
                if (audioRecord2 != null) {
                    audioRecord2.release();
                }
                this.mFileWriteSemaphore.acquire();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!this.mHasError) {
                String string = this.mFilePath;
                Intrinsics.checkNotNull((Object)string);
                this.notifyRecordStop(string);
            }
        }
        this.mIsRecording = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAudioRecordRecording() {
        if (this.mAudioRecord == null) return false;
        AudioRecord audioRecord = this.mAudioRecord;
        Intrinsics.checkNotNull((Object)audioRecord);
        if (audioRecord.getState() != 1) return false;
        AudioRecord audioRecord2 = this.mAudioRecord;
        Intrinsics.checkNotNull((Object)audioRecord2);
        if (audioRecord2.getRecordingState() != 3) return false;
        return true;
    }

    @Override
    public boolean isRecording() {
        return this.mIsRecording;
    }

    @Override
    public long getRecordDuration() {
        return SystemClock.uptimeMillis() - this.mStartRecordTime;
    }

    @Override
    @Nullable
    public String getRecordPath() {
        return this.mFilePath;
    }

    private final void readAudioDataAndWrite2File() {
        this.readAudioDataAndWrite2FileImpl(this.mFilePath, this.mAudioRecord);
        this.mFileWriteSemaphore.release();
    }

    public final void setHasError(boolean hasError) {
        this.mHasError = hasError;
    }

    @Nullable
    protected abstract AudioRecord initAudioRecord();

    protected abstract void readAudioDataAndWrite2FileImpl(@Nullable String var1, @Nullable AudioRecord var2);

    @NotNull
    protected abstract String getFileSuffix();

    public RecordWrapper(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.MAX_RECORD_TIME = 300000L;
        this.mContext = context;
        this.mFileWriteSemaphore = new Semaphore(0);
        this.stopHandler = new Handler(){

            public void handleMessage(@NotNull Message msg) {
                Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            }
        };
    }

    public static final /* synthetic */ void access$doRecordStart(RecordWrapper $this) {
        $this.doRecordStart();
    }

    public static final /* synthetic */ void access$readAudioDataAndWrite2File(RecordWrapper $this) {
        $this.readAudioDataAndWrite2File();
    }

    public static final /* synthetic */ void access$doRecordStop(RecordWrapper $this) {
        $this.doRecordStop();
    }
}

