/*
 * Decompiled with CFR 0.152.
 */
package com.martin.audiolib.record;

import android.content.Context;
import android.media.AudioRecord;
import com.martin.audiolib.OpusTool;
import com.martin.audiolib.record.RecordWrapper;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J\u001c\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u0012H\u0014J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0018H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/martin/audiolib/record/OpusAudioRecord;", "Lcom/martin/audiolib/record/RecordWrapper;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "AUDIO_RECORD_READ_BUFFER_MIN_SIZE", "", "WRITE_OPUS_FILE_BUFFER_SIZE", "mAudioFormat", "mAudioSource", "mChannelCount", "mOpusTool", "Lcom/martin/audiolib/OpusTool;", "mSampleRateInHz", "recordBufferSize", "getFileSuffix", "", "initAudioRecord", "Landroid/media/AudioRecord;", "readAudioDataAndWrite2FileImpl", "", "filePath", "audioRecord", "writeAudioBufferToFile", "", "audioRecordBuffer", "Ljava/nio/ByteBuffer;", "writeFileBuffer", "forceFlush", "AudioLib_release"})
public final class OpusAudioRecord
extends RecordWrapper {
    private final int WRITE_OPUS_FILE_BUFFER_SIZE;
    private final int AUDIO_RECORD_READ_BUFFER_MIN_SIZE;
    private int mSampleRateInHz;
    private int mAudioSource;
    private int mChannelCount;
    private int mAudioFormat;
    private int recordBufferSize;
    private OpusTool mOpusTool;

    @Override
    @Nullable
    protected AudioRecord initAudioRecord() {
        this.recordBufferSize = AudioRecord.getMinBufferSize((int)this.mSampleRateInHz, (int)this.mChannelCount, (int)this.mAudioFormat);
        if (this.recordBufferSize <= 0) {
            this.recordBufferSize = 1280;
        }
        return new AudioRecord(this.mAudioSource, this.mSampleRateInHz, this.mChannelCount, this.mAudioFormat, this.recordBufferSize * 10);
    }

    @Override
    protected void readAudioDataAndWrite2FileImpl(@Nullable String filePath, @Nullable AudioRecord audioRecord) {
        boolean writeFileSucceed;
        ByteBuffer audioRecordBuffer;
        ByteBuffer writeFileBuffer;
        boolean readStarted;
        block7: {
            if (!OpusTool.Companion.isLoadSucceed()) {
                String string = filePath;
                if (string == null) {
                    string = "";
                }
                this.notifyRecordError(string, 3, "opus lib load failed");
                return;
            }
            if (!this.mOpusTool.startOpusRecord(filePath)) {
                String string = filePath;
                if (string == null) {
                    string = "";
                }
                this.notifyRecordError(string, 4, "start record failed");
                return;
            }
            String string = filePath;
            Intrinsics.checkNotNull((Object)string);
            this.notifyRecordStart(string);
            int readLength = 0;
            readStarted = false;
            writeFileBuffer = ByteBuffer.allocateDirect(this.WRITE_OPUS_FILE_BUFFER_SIZE);
            writeFileBuffer.order(ByteOrder.nativeOrder());
            writeFileBuffer.clear();
            int n = this.recordBufferSize;
            int n2 = this.AUDIO_RECORD_READ_BUFFER_MIN_SIZE;
            int n3 = 0;
            int audioRecordBufferSize = Math.max(n, n2);
            audioRecordBuffer = ByteBuffer.allocateDirect(audioRecordBufferSize);
            audioRecordBuffer.order(ByteOrder.nativeOrder());
            audioRecordBuffer.clear();
            writeFileSucceed = false;
            do {
                AudioRecord audioRecord2 = audioRecord;
                Intrinsics.checkNotNull((Object)audioRecord2);
                n3 = audioRecord2.read(audioRecordBuffer, audioRecordBuffer.limit());
                boolean bl = false;
                boolean bl2 = false;
                int it = n3;
                boolean bl3 = false;
                readLength = it;
                if (n3 <= 0) break block7;
                if (!readStarted) {
                    readStarted = true;
                }
                audioRecordBuffer.limit(readLength);
                audioRecordBuffer.rewind();
                ByteBuffer byteBuffer = audioRecordBuffer;
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"audioRecordBuffer");
                ByteBuffer byteBuffer2 = writeFileBuffer;
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"writeFileBuffer");
                writeFileSucceed = this.writeAudioBufferToFile(byteBuffer, byteBuffer2, false);
                audioRecordBuffer.clear();
            } while (writeFileSucceed);
            this.setHasError(true);
            this.notifyRecordError(filePath, 4, "write opus frame error");
        }
        if (readStarted && !writeFileSucceed) {
            ByteBuffer byteBuffer = audioRecordBuffer;
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"audioRecordBuffer");
            ByteBuffer byteBuffer3 = writeFileBuffer;
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer3, (String)"writeFileBuffer");
            this.writeAudioBufferToFile(byteBuffer, byteBuffer3, true);
        }
        this.mOpusTool.stopOpusRecord();
    }

    private final boolean writeAudioBufferToFile(ByteBuffer audioRecordBuffer, ByteBuffer writeFileBuffer, boolean forceFlush) {
        if (!forceFlush) {
            while (audioRecordBuffer.hasRemaining()) {
                int audioBufferOldLimit = -1;
                if (audioRecordBuffer.remaining() > writeFileBuffer.remaining()) {
                    audioBufferOldLimit = audioRecordBuffer.limit();
                    audioRecordBuffer.limit(audioRecordBuffer.position() + writeFileBuffer.remaining());
                }
                writeFileBuffer.put(audioRecordBuffer);
                if (writeFileBuffer.limit() == writeFileBuffer.position()) {
                    writeFileBuffer.flip();
                    boolean succeed = this.mOpusTool.writeOpusFrame(writeFileBuffer, writeFileBuffer.limit());
                    if (!succeed) {
                        return false;
                    }
                    writeFileBuffer.clear();
                }
                if (audioBufferOldLimit <= 0) continue;
                audioRecordBuffer.limit(audioBufferOldLimit);
            }
        } else if (writeFileBuffer.position() > 0) {
            writeFileBuffer.flip();
            this.mOpusTool.writeOpusFrame(writeFileBuffer, writeFileBuffer.limit());
            writeFileBuffer.rewind();
        }
        return true;
    }

    @Override
    @NotNull
    protected String getFileSuffix() {
        return "opus";
    }

    public OpusAudioRecord(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.WRITE_OPUS_FILE_BUFFER_SIZE = 1920;
        this.AUDIO_RECORD_READ_BUFFER_MIN_SIZE = 4096;
        this.mSampleRateInHz = 16000;
        this.mAudioSource = 1;
        this.mChannelCount = 16;
        this.mAudioFormat = 2;
        this.mOpusTool = new OpusTool();
    }
}

