/*
 * Decompiled with CFR 0.152.
 */
package com.martin.audiolib.play;

import android.media.AudioTrack;
import android.os.Handler;
import android.os.HandlerThread;
import android.text.TextUtils;
import android.util.Log;
import com.martin.audiolib.AudioUtilKt;
import com.martin.audiolib.OpusTool;
import com.martin.audiolib.play.BasePlay;
import com.martin.audiolib.play.OpusAudioPlayer;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u001e*\u0001\"\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010$\u001a\u00020%J\u0010\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020\fH\u0002J\b\u0010(\u001a\u00020\u000eH\u0016J\b\u0010)\u001a\u00020\u0004H\u0016J\b\u0010*\u001a\u00020\u0010H\u0016J\b\u0010+\u001a\u00020\u0004H\u0016J\u0010\u0010,\u001a\u00020%2\u0006\u0010-\u001a\u00020\u0004H\u0002J\b\u0010.\u001a\u00020\fH\u0002J\b\u0010/\u001a\u00020\fH\u0002J\b\u00100\u001a\u00020\fH\u0002J\b\u00101\u001a\u00020\fH\u0016J\u0010\u00101\u001a\u00020\f2\b\u00102\u001a\u0004\u0018\u00010\u0010J\u0018\u00101\u001a\u00020\f2\b\u00102\u001a\u0004\u0018\u00010\u00102\u0006\u00103\u001a\u00020\u000eJ\b\u00104\u001a\u00020\fH\u0016J\b\u00105\u001a\u00020%H\u0016J \u00106\u001a\u00020%2\u0006\u00107\u001a\u00020\u00102\u0006\u00108\u001a\u00020\u00042\u0006\u00109\u001a\u00020\u000eH\u0016J\u0018\u00106\u001a\u00020%2\u0006\u00107\u001a\u00020\u00102\u0006\u00109\u001a\u00020\u000eH\u0016J\b\u0010:\u001a\u00020\fH\u0002J\b\u0010;\u001a\u00020%H\u0016J\u0010\u0010<\u001a\u00020%2\u0006\u00108\u001a\u00020\u0004H\u0002J\u0010\u0010=\u001a\u00020%2\u0006\u00108\u001a\u00020\u0004H\u0002J\u0010\u0010>\u001a\u00020%2\u0006\u0010?\u001a\u00020\u0004H\u0016J\b\u0010@\u001a\u00020%H\u0016J\u000e\u0010A\u001a\u00020%2\u0006\u0010-\u001a\u00020\u0004J\b\u0010B\u001a\u00020%H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010#\u00a8\u0006C"}, d2={"Lcom/martin/audiolib/play/OpusAudioPlayer;", "Lcom/martin/audiolib/play/BasePlay;", "()V", "AUDIO_FORMAT", "", "AUDIO_PLAY_BUFFER_MIN_SIZE", "CHANNEL_OUT_COUNT", "SAMPLE_RATE", "mAudioTrack", "Landroid/media/AudioTrack;", "mCurrentSourceMode", "mDecodeFinished", "", "mDecodePos", "", "mFilePath", "", "mFileReadSemaphore", "Ljava/util/concurrent/Semaphore;", "mHandlerControl", "Landroid/os/Handler;", "mHandlerPlay", "mHandlerThreadControl", "Landroid/os/HandlerThread;", "mHandlerThreadPlay", "mHasError", "mOpusTool", "Lcom/martin/audiolib/OpusTool;", "mPlayBufferSize", "mPlayComplete", "mState", "Ljava/util/concurrent/atomic/AtomicInteger;", "mUniqueId", "playBackPosUpdateListener", "com/martin/audiolib/play/OpusAudioPlayer$playBackPosUpdateListener$1", "Lcom/martin/audiolib/play/OpusAudioPlayer$playBackPosUpdateListener$1;", "cleanUp", "", "doPause", "needNotify", "getCurrentPosition", "getDuration", "getPlayPath", "getState", "initAudioTrack", "mode", "isAudioTrackPaused", "isAudioTrackPlaying", "isAudioTrackValid", "isPlaying", "path", "id", "isSupportSeekTo", "pause", "play", "url", "targetPosition", "tagId", "releaseAudioTrack", "resume", "seekByPosition", "seekOpusFile", "seekTo", "process", "stop", "switchMode", "writeFileToAudioTrack", "AudioLib_release"})
public final class OpusAudioPlayer
extends BasePlay {
    private final int SAMPLE_RATE;
    private final int CHANNEL_OUT_COUNT;
    private final int AUDIO_FORMAT;
    private final int AUDIO_PLAY_BUFFER_MIN_SIZE;
    private String mFilePath;
    private boolean mHasError;
    private boolean mPlayComplete;
    private AudioTrack mAudioTrack;
    private int mPlayBufferSize;
    private Semaphore mFileReadSemaphore = new Semaphore(0);
    private AtomicInteger mState = new AtomicInteger(0);
    private OpusTool mOpusTool;
    private volatile long mDecodePos;
    private boolean mDecodeFinished;
    private long mUniqueId;
    private int mCurrentSourceMode = 3;
    private playBackPosUpdateListener.1 playBackPosUpdateListener = new AudioTrack.OnPlaybackPositionUpdateListener(){

        public void onMarkerReached(@Nullable AudioTrack track) {
        }

        public void onPeriodicNotification(@Nullable AudioTrack track) {
        }
    };
    private HandlerThread mHandlerThreadPlay = new HandlerThread("audio_play");
    private HandlerThread mHandlerThreadControl = new HandlerThread("audio_control");
    private Handler mHandlerPlay;
    private Handler mHandlerControl;

    private final void initAudioTrack(int mode) {
        this.mPlayBufferSize = AudioTrack.getMinBufferSize((int)this.SAMPLE_RATE, (int)this.CHANNEL_OUT_COUNT, (int)this.AUDIO_FORMAT);
        if (this.mPlayBufferSize <= 0) {
            this.mPlayBufferSize = this.AUDIO_PLAY_BUFFER_MIN_SIZE;
        }
        AudioTrack audioTrack = this.mAudioTrack = new AudioTrack(mode, this.SAMPLE_RATE, this.CHANNEL_OUT_COUNT, this.AUDIO_FORMAT, this.mPlayBufferSize, 1);
        if (audioTrack != null) {
            audioTrack.setPlaybackPositionUpdateListener((AudioTrack.OnPlaybackPositionUpdateListener)this.playBackPosUpdateListener);
        }
        this.mCurrentSourceMode = mode;
    }

    public final void switchMode(int mode) {
        if (mode == this.mCurrentSourceMode) {
            return;
        }
        this.mHandlerControl.post(new Runnable(this, mode){
            final /* synthetic */ OpusAudioPlayer this$0;
            final /* synthetic */ int $mode;

            public final void run() {
                AudioTrack audioTrack = OpusAudioPlayer.access$getMAudioTrack$p(this.this$0);
                if (audioTrack != null) {
                    audioTrack.release();
                }
                OpusAudioPlayer.access$initAudioTrack(this.this$0, this.$mode);
                AudioTrack audioTrack2 = OpusAudioPlayer.access$getMAudioTrack$p(this.this$0);
                Intrinsics.checkNotNull((Object)audioTrack2);
                if (audioTrack2.getState() == 1) {
                    AudioTrack audioTrack3 = OpusAudioPlayer.access$getMAudioTrack$p(this.this$0);
                    Intrinsics.checkNotNull((Object)audioTrack3);
                    audioTrack3.play();
                    OpusAudioPlayer.access$getMHandlerPlay$p(this.this$0).post(new Runnable(this){
                        final /* synthetic */ switchMode.1 this$0;

                        public final void run() {
                            OpusAudioPlayer.access$writeFileToAudioTrack(this.this$0.this$0);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                } else {
                    this.this$0.stop();
                }
            }
            {
                this.this$0 = opusAudioPlayer;
                this.$mode = n;
            }
        });
    }

    @Override
    public void play(@NotNull String url, long tagId) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.play(url, 0, tagId);
    }

    @Override
    public void play(@NotNull String url, int targetPosition, long tagId) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.cleanUp();
        this.initAudioTrack(this.mCurrentSourceMode);
        this.mHandlerControl.post(new Runnable(this, url, tagId, targetPosition){
            final /* synthetic */ OpusAudioPlayer this$0;
            final /* synthetic */ String $url;
            final /* synthetic */ long $tagId;
            final /* synthetic */ int $targetPosition;

            public final void run() {
                block10: {
                    if (TextUtils.isEmpty((CharSequence)this.$url)) {
                        return;
                    }
                    if (!OpusTool.Companion.isLoadSucceed()) {
                        OpusAudioPlayer.access$setMHasError$p(this.this$0, true);
                        this.this$0.stop();
                        this.this$0.notifyError(this.$url, 3, "opus lib load failed");
                        return;
                    }
                    OpusAudioPlayer.access$setMFilePath$p(this.this$0, this.$url);
                    if (!AudioUtilKt.isFileExists(OpusAudioPlayer.access$getMFilePath$p(this.this$0))) {
                        Log.e((String)AudioUtilKt.getTAG(), (String)"play file not exist");
                        OpusAudioPlayer.access$setMHasError$p(this.this$0, true);
                        this.this$0.stop();
                        String string = OpusAudioPlayer.access$getMFilePath$p(this.this$0);
                        Intrinsics.checkNotNull((Object)string);
                        this.this$0.notifyError(string, 10, "[play] file not exist");
                        return;
                    }
                    OpusAudioPlayer.access$setMUniqueId$p(this.this$0, this.$tagId);
                    OpusAudioPlayer.access$setMFilePath$p(this.this$0, new File(OpusAudioPlayer.access$getMFilePath$p(this.this$0)).getAbsolutePath());
                    if (OpusAudioPlayer.access$getMOpusTool$p(this.this$0) == null) {
                        OpusAudioPlayer.access$setMOpusTool$p(this.this$0, new OpusTool());
                    }
                    OpusTool opusTool = OpusAudioPlayer.access$getMOpusTool$p(this.this$0);
                    Intrinsics.checkNotNull((Object)opusTool);
                    if (!opusTool.isOpusFileFormat(OpusAudioPlayer.access$getMFilePath$p(this.this$0))) {
                        OpusAudioPlayer.access$setMHasError$p(this.this$0, true);
                        this.this$0.stop();
                        String string = OpusAudioPlayer.access$getMFilePath$p(this.this$0);
                        Intrinsics.checkNotNull((Object)string);
                        this.this$0.notifyError(string, 11, "file is not opus file, can not play...");
                        return;
                    }
                    OpusAudioPlayer.access$getMState$p(this.this$0).set(2);
                    String string = OpusAudioPlayer.access$getMFilePath$p(this.this$0);
                    Intrinsics.checkNotNull((Object)string);
                    this.this$0.notifyPreparing(string);
                    OpusTool opusTool2 = OpusAudioPlayer.access$getMOpusTool$p(this.this$0);
                    if (opusTool2 == null) break block10;
                    OpusTool opusTool3 = opusTool2;
                    boolean bl = false;
                    boolean bl2 = false;
                    OpusTool it = opusTool3;
                    boolean bl3 = false;
                    if (!it.openFile(OpusAudioPlayer.access$getMFilePath$p(this.this$0))) {
                        OpusAudioPlayer.access$setMHasError$p(this.this$0, true);
                        this.this$0.stop();
                        String string2 = OpusAudioPlayer.access$getMFilePath$p(this.this$0);
                        Intrinsics.checkNotNull((Object)string2);
                        this.this$0.notifyError(string2, 12, "open file error...");
                        return;
                    }
                    OpusAudioPlayer.access$getMState$p(this.this$0).set(3);
                    String string3 = OpusAudioPlayer.access$getMFilePath$p(this.this$0);
                    Intrinsics.checkNotNull((Object)string3);
                    this.this$0.notifyPrepared(string3);
                    if (this.$targetPosition > 0) {
                        AudioTrack audioTrack = OpusAudioPlayer.access$getMAudioTrack$p(this.this$0);
                        if (audioTrack != null) {
                            audioTrack.pause();
                        }
                        OpusAudioPlayer.access$seekByPosition(this.this$0, (int)((float)this.$targetPosition * 1.0f / (float)100 * (float)this.this$0.getDuration()));
                    } else {
                        AudioTrack audioTrack = OpusAudioPlayer.access$getMAudioTrack$p(this.this$0);
                        if (audioTrack != null) {
                            audioTrack.play();
                        }
                        OpusAudioPlayer.access$getMHandlerPlay$p(this.this$0).post(new Runnable(this){
                            final /* synthetic */ play.1 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public final void run() {
                                OpusAudioPlayer.access$writeFileToAudioTrack(this.this$0.this$0);
                            }
                        });
                    }
                }
            }
            {
                this.this$0 = opusAudioPlayer;
                this.$url = string;
                this.$tagId = l;
                this.$targetPosition = n;
            }
        });
    }

    @Override
    public void pause() {
        this.mHandlerControl.post(new Runnable(this){
            final /* synthetic */ OpusAudioPlayer this$0;

            public final void run() {
                OpusAudioPlayer.access$doPause(this.this$0, true);
            }
            {
                this.this$0 = opusAudioPlayer;
            }
        });
    }

    @Override
    public void resume() {
        this.mHandlerControl.post(new Runnable(this){
            final /* synthetic */ OpusAudioPlayer this$0;

            public final void run() {
                if (!OpusAudioPlayer.access$isAudioTrackPaused(this.this$0)) {
                    return;
                }
                AudioTrack audioTrack = OpusAudioPlayer.access$getMAudioTrack$p(this.this$0);
                if (audioTrack != null) {
                    audioTrack.play();
                }
                OpusAudioPlayer.access$getMHandlerPlay$p(this.this$0).post(new Runnable(this){
                    final /* synthetic */ resume.1 this$0;

                    public final void run() {
                        OpusAudioPlayer.access$writeFileToAudioTrack(this.this$0.this$0);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = opusAudioPlayer;
            }
        });
    }

    @Override
    public void stop() {
        this.mHandlerControl.post(new Runnable(this){
            final /* synthetic */ OpusAudioPlayer this$0;

            public final void run() {
                boolean result = OpusAudioPlayer.access$releaseAudioTrack(this.this$0);
                OpusAudioPlayer.access$getMState$p(this.this$0).set(0);
                if (result) {
                    if (OpusAudioPlayer.access$getMHasError$p(this.this$0)) {
                        return;
                    }
                    if (OpusAudioPlayer.access$getMPlayComplete$p(this.this$0)) {
                        String string = OpusAudioPlayer.access$getMFilePath$p(this.this$0);
                        Intrinsics.checkNotNull((Object)string);
                        this.this$0.notifyComplete(string);
                        return;
                    }
                    String string = OpusAudioPlayer.access$getMFilePath$p(this.this$0);
                    Intrinsics.checkNotNull((Object)string);
                    this.this$0.notifyStop(string);
                }
            }
            {
                this.this$0 = opusAudioPlayer;
            }
        });
    }

    @Override
    public boolean isSupportSeekTo() {
        return true;
    }

    @Override
    public void seekTo(int process) {
        this.mHandlerControl.post(new Runnable(this, process){
            final /* synthetic */ OpusAudioPlayer this$0;
            final /* synthetic */ int $process;

            public final void run() {
                OpusAudioPlayer.access$seekByPosition(this.this$0, (int)((float)this.$process * 1.0f / (float)100 * (float)this.this$0.getDuration()));
            }
            {
                this.this$0 = opusAudioPlayer;
                this.$process = n;
            }
        });
    }

    @Override
    @NotNull
    public String getPlayPath() {
        String string = this.mFilePath;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    public int getDuration() {
        if (this.mOpusTool != null) {
            OpusTool opusTool = this.mOpusTool;
            Intrinsics.checkNotNull((Object)opusTool);
            return (int)opusTool.getDuration();
        }
        return 0;
    }

    @Override
    public long getCurrentPosition() {
        return OpusTool.Companion.convertPcm2NormalDuration(this.mDecodePos);
    }

    @Override
    public boolean isPlaying() {
        return this.mState.get() == 4 && this.isAudioTrackPlaying();
    }

    public final boolean isPlaying(@Nullable String path) {
        return this.isPlaying() && TextUtils.equals((CharSequence)path, (CharSequence)this.mFilePath);
    }

    public final boolean isPlaying(@Nullable String path, long id) {
        return this.isPlaying() && TextUtils.equals((CharSequence)path, (CharSequence)this.mFilePath) && this.mUniqueId == id;
    }

    @Override
    public int getState() {
        return this.mState.get();
    }

    public final void cleanUp() {
        this.releaseAudioTrack();
        this.mFilePath = "";
        this.mUniqueId = 0L;
        this.mHasError = false;
        this.mPlayComplete = false;
        this.mDecodeFinished = false;
        this.mHandlerPlay.removeCallbacksAndMessages(null);
        this.mHandlerControl.removeCallbacksAndMessages(null);
    }

    private final boolean releaseAudioTrack() {
        block9: {
            AudioTrack audioTrack = this.mAudioTrack;
            if (audioTrack == null) break block9;
            AudioTrack audioTrack2 = audioTrack;
            boolean bl = false;
            boolean bl2 = false;
            AudioTrack $this$run = audioTrack2;
            boolean bl3 = false;
            if (this.isAudioTrackValid()) {
                switch ($this$run.getPlayState()) {
                    case 3: {
                        try {
                            $this$run.flush();
                            $this$run.stop();
                            $this$run.release();
                            this.mFileReadSemaphore.acquire();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        return true;
                    }
                    case 2: {
                        try {
                            $this$run.flush();
                            $this$run.stop();
                            $this$run.release();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final void doPause(boolean needNotify) {
        if (this.isAudioTrackPlaying()) {
            try {
                AudioTrack audioTrack = this.mAudioTrack;
                Intrinsics.checkNotNull((Object)audioTrack);
                audioTrack.pause();
                this.mState.set(5);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.mHasError = true;
            }
            try {
                this.mFileReadSemaphore.acquire();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!this.mHasError && this.isAudioTrackPaused()) {
                if (needNotify) {
                    String string = this.mFilePath;
                    Intrinsics.checkNotNull((Object)string);
                    this.notifyPause(string);
                }
            } else if (this.mHasError) {
                this.stop();
                String string = this.mFilePath;
                Intrinsics.checkNotNull((Object)string);
                this.notifyError(string, 14, "");
            }
        }
    }

    private final void seekByPosition(int targetPosition) {
        if (this.isAudioTrackValid()) {
            AudioTrack audioTrack = this.mAudioTrack;
            Intrinsics.checkNotNull((Object)audioTrack);
            switch (audioTrack.getPlayState()) {
                case 2: {
                    this.seekOpusFile(targetPosition);
                    this.resume();
                    break;
                }
                case 3: {
                    this.doPause(false);
                    this.seekOpusFile(targetPosition);
                    this.resume();
                    break;
                }
            }
        }
    }

    private final void seekOpusFile(int targetPosition) {
        int n = 0;
        boolean bl = false;
        int position = Math.max(targetPosition, n);
        if (this.mDecodeFinished) {
            OpusTool opusTool = this.mOpusTool;
            Intrinsics.checkNotNull((Object)opusTool);
            opusTool.closeFile();
            OpusTool opusTool2 = this.mOpusTool;
            Intrinsics.checkNotNull((Object)opusTool2);
            opusTool2.openFile(this.mFilePath);
            this.mDecodeFinished = false;
        }
        OpusTool opusTool = this.mOpusTool;
        Intrinsics.checkNotNull((Object)opusTool);
        if (opusTool.getPcmDuration() <= 0L) {
            this.mHasError = true;
            String string = this.mFilePath;
            Intrinsics.checkNotNull((Object)string);
            this.notifyError(string, 13, "audio duration is 0");
            this.stop();
            return;
        }
        long pcmDuration = (long)((float)position * 48.0f);
        OpusTool opusTool3 = this.mOpusTool;
        Intrinsics.checkNotNull((Object)opusTool3);
        if (pcmDuration > opusTool3.getPcmDuration()) {
            pcmDuration = 0L;
        }
        float f = (float)pcmDuration * 1.0f;
        OpusTool opusTool4 = this.mOpusTool;
        Intrinsics.checkNotNull((Object)opusTool4);
        float progress = f / (float)opusTool4.getPcmDuration();
        OpusTool opusTool5 = this.mOpusTool;
        Intrinsics.checkNotNull((Object)opusTool5);
        opusTool5.seekFile(progress);
    }

    private final void writeFileToAudioTrack() {
        ByteBuffer readOpusBuffer = ByteBuffer.allocateDirect(this.mPlayBufferSize);
        readOpusBuffer.order(ByteOrder.nativeOrder());
        int[] readOpusArgs = new int[3];
        int size = 0;
        boolean isFirstRead = true;
        boolean finished = false;
        int count = 0;
        this.mState.set(4);
        String string = this.mFilePath;
        Intrinsics.checkNotNull((Object)string);
        this.notifyStart(string);
        while (this.isAudioTrackPlaying()) {
            OpusTool opusTool = this.mOpusTool;
            Intrinsics.checkNotNull((Object)opusTool);
            opusTool.readFile(readOpusBuffer, this.mPlayBufferSize, readOpusArgs);
            size = readOpusArgs[0];
            this.mDecodePos = readOpusArgs[1];
            boolean bl = finished = readOpusArgs[2] == 1;
            if (size > 0) {
                if (isFirstRead) {
                    isFirstRead = false;
                }
                readOpusBuffer.rewind();
                byte[] data = new byte[size];
                readOpusBuffer.get(data);
                try {
                    AudioTrack audioTrack = this.mAudioTrack;
                    Intrinsics.checkNotNull((Object)audioTrack);
                    audioTrack.write(data, 0, size);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (++count >= 3) {
                    String string2 = this.mFilePath;
                    Intrinsics.checkNotNull((Object)string2);
                    this.notifyProgress(string2, this.getCurrentPosition(), this.getDuration());
                    count = 0;
                }
            }
            if (!finished) continue;
            this.mDecodeFinished = true;
            AudioTrack audioTrack = this.mAudioTrack;
            Intrinsics.checkNotNull((Object)audioTrack);
            audioTrack.setNotificationMarkerPosition(1);
            OpusTool opusTool2 = this.mOpusTool;
            Intrinsics.checkNotNull((Object)opusTool2);
            opusTool2.closeFile();
            this.mState.set(0);
            String string3 = this.mFilePath;
            Intrinsics.checkNotNull((Object)string3);
            this.notifyComplete(string3);
            break;
        }
        this.mFileReadSemaphore.release();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAudioTrackValid() {
        if (this.mAudioTrack == null) return false;
        AudioTrack audioTrack = this.mAudioTrack;
        Intrinsics.checkNotNull((Object)audioTrack);
        if (audioTrack.getState() != 1) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAudioTrackPlaying() {
        if (!this.isAudioTrackValid()) return false;
        AudioTrack audioTrack = this.mAudioTrack;
        Intrinsics.checkNotNull((Object)audioTrack);
        if (audioTrack.getPlayState() != 3) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAudioTrackPaused() {
        if (!this.isAudioTrackValid()) return false;
        AudioTrack audioTrack = this.mAudioTrack;
        Intrinsics.checkNotNull((Object)audioTrack);
        if (audioTrack.getPlayState() != 2) return false;
        return true;
    }

    public OpusAudioPlayer() {
        this.SAMPLE_RATE = 48000;
        this.CHANNEL_OUT_COUNT = 4;
        this.AUDIO_FORMAT = 2;
        this.AUDIO_PLAY_BUFFER_MIN_SIZE = 3840;
        this.mHandlerThreadPlay.start();
        this.mHandlerThreadControl.start();
        this.mHandlerPlay = new Handler(this.mHandlerThreadPlay.getLooper());
        this.mHandlerControl = new Handler(this.mHandlerThreadControl.getLooper());
    }

    public static final /* synthetic */ AudioTrack access$getMAudioTrack$p(OpusAudioPlayer $this) {
        return $this.mAudioTrack;
    }

    public static final /* synthetic */ void access$setMAudioTrack$p(OpusAudioPlayer $this, AudioTrack audioTrack) {
        $this.mAudioTrack = audioTrack;
    }

    public static final /* synthetic */ void access$initAudioTrack(OpusAudioPlayer $this, int mode) {
        $this.initAudioTrack(mode);
    }

    public static final /* synthetic */ Handler access$getMHandlerPlay$p(OpusAudioPlayer $this) {
        return $this.mHandlerPlay;
    }

    public static final /* synthetic */ void access$setMHandlerPlay$p(OpusAudioPlayer $this, Handler handler) {
        $this.mHandlerPlay = handler;
    }

    public static final /* synthetic */ void access$writeFileToAudioTrack(OpusAudioPlayer $this) {
        $this.writeFileToAudioTrack();
    }

    public static final /* synthetic */ boolean access$getMHasError$p(OpusAudioPlayer $this) {
        return $this.mHasError;
    }

    public static final /* synthetic */ void access$setMHasError$p(OpusAudioPlayer $this, boolean bl) {
        $this.mHasError = bl;
    }

    public static final /* synthetic */ String access$getMFilePath$p(OpusAudioPlayer $this) {
        return $this.mFilePath;
    }

    public static final /* synthetic */ void access$setMFilePath$p(OpusAudioPlayer $this, String string) {
        $this.mFilePath = string;
    }

    public static final /* synthetic */ long access$getMUniqueId$p(OpusAudioPlayer $this) {
        return $this.mUniqueId;
    }

    public static final /* synthetic */ void access$setMUniqueId$p(OpusAudioPlayer $this, long l) {
        $this.mUniqueId = l;
    }

    public static final /* synthetic */ OpusTool access$getMOpusTool$p(OpusAudioPlayer $this) {
        return $this.mOpusTool;
    }

    public static final /* synthetic */ void access$setMOpusTool$p(OpusAudioPlayer $this, OpusTool opusTool) {
        $this.mOpusTool = opusTool;
    }

    public static final /* synthetic */ AtomicInteger access$getMState$p(OpusAudioPlayer $this) {
        return $this.mState;
    }

    public static final /* synthetic */ void access$setMState$p(OpusAudioPlayer $this, AtomicInteger atomicInteger) {
        $this.mState = atomicInteger;
    }

    public static final /* synthetic */ void access$seekByPosition(OpusAudioPlayer $this, int targetPosition) {
        $this.seekByPosition(targetPosition);
    }

    public static final /* synthetic */ void access$doPause(OpusAudioPlayer $this, boolean needNotify) {
        $this.doPause(needNotify);
    }

    public static final /* synthetic */ boolean access$isAudioTrackPaused(OpusAudioPlayer $this) {
        return $this.isAudioTrackPaused();
    }

    public static final /* synthetic */ boolean access$releaseAudioTrack(OpusAudioPlayer $this) {
        return $this.releaseAudioTrack();
    }

    public static final /* synthetic */ boolean access$getMPlayComplete$p(OpusAudioPlayer $this) {
        return $this.mPlayComplete;
    }

    public static final /* synthetic */ void access$setMPlayComplete$p(OpusAudioPlayer $this, boolean bl) {
        $this.mPlayComplete = bl;
    }
}

