/*
 * Decompiled with CFR 0.152.
 */
package com.martin.audiolib;

import com.martin.audiolib.AudioUtilKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0017\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\f\u0018\u0000 .2\u00020\u0001:\u0001.B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\t\u0010\u0005\u001a\u00020\u0004H\u0082 J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u001a\u0010\r\u001a\u0004\u0018\u00010\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\t\u0010\u0012\u001a\u00020\u0007H\u0082 J\u0015\u0010\u0013\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0086 J\u001d\u0010\u0014\u001a\u0004\u0018\u00010\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0086 J\u0011\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0082 J\u0010\u0010\u0016\u001a\u00020\u00172\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0010\u0010\u0018\u001a\u00020\u00172\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0011\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0082 J\"\u0010\u001a\u001a\u00020\u00042\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u00112\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ!\u0010 \u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001fH\u0082 J\u000e\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020#J\u0011\u0010$\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020#H\u0082 J\u0010\u0010%\u001a\u00020\u00172\b\u0010&\u001a\u0004\u0018\u00010\fJ\u0011\u0010'\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0082 J\u0006\u0010(\u001a\u00020\u0004J\t\u0010)\u001a\u00020\u0004H\u0082 J\u0019\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020\u0011H\u0082 J\u0018\u0010-\u001a\u00020\u00172\b\u0010+\u001a\u0004\u0018\u00010\u001c2\u0006\u0010,\u001a\u00020\u0011\u00a8\u0006/"}, d2={"Lcom/martin/audiolib/OpusTool;", "", "()V", "closeFile", "", "closeOpusFile", "getDuration", "", "getPcmDuration", "getPcmWaveForm", "", "path", "", "getPcmWaveform2", "array", "", "length", "", "getTotalPcmDuration", "getWaveform", "getWaveform2", "isOpusFile", "isOpusFileFormat", "", "openFile", "openOpusFile", "readFile", "buffer", "Ljava/nio/ByteBuffer;", "capacity", "args", "", "readOpusFile", "seekFile", "position", "", "seekOpusFile", "startOpusRecord", "filePath", "startRecord", "stopOpusRecord", "stopRecord", "writeFrame", "frame", "len", "writeOpusFrame", "Companion", "AudioLib_release"})
public final class OpusTool {
    public static final int READ_OPUS_FINISHED = 1;
    private static final int START_RECORD_SUC = 1;
    private static final int WRITE_RECORD_FRAME_SUC = 1;
    private static final int OPEN_RECORD_SUC = 1;
    private static final int IS_OPUS_FILE_FORMAT = 1;
    private static boolean isLoadSucceed;
    public static final Companion Companion;

    private final native int startRecord(String var1);

    private final native int writeFrame(ByteBuffer var1, int var2);

    private final native void stopRecord();

    private final native int openOpusFile(String var1);

    private final native int seekOpusFile(float var1);

    private final native int isOpusFile(String var1);

    private final native void closeOpusFile();

    private final native void readOpusFile(ByteBuffer var1, int var2, int[] var3);

    private final native long getTotalPcmDuration();

    @Nullable
    public final native byte[] getWaveform(@Nullable String var1);

    @Nullable
    public final native byte[] getWaveform2(@Nullable short[] var1, int var2);

    public final boolean startOpusRecord(@Nullable String filePath) {
        String string = filePath;
        Intrinsics.checkNotNull((Object)string);
        return this.startRecord(string) == 1;
    }

    public final boolean writeOpusFrame(@Nullable ByteBuffer frame, int len) {
        ByteBuffer byteBuffer = frame;
        Intrinsics.checkNotNull((Object)byteBuffer);
        return this.writeFrame(byteBuffer, len) == 1;
    }

    public final void stopOpusRecord() {
        this.stopRecord();
    }

    public final boolean openFile(@Nullable String path) {
        String string = path;
        Intrinsics.checkNotNull((Object)string);
        return this.openOpusFile(string) != 0;
    }

    public final int seekFile(float position) {
        return this.seekOpusFile(position);
    }

    public final boolean isOpusFileFormat(@Nullable String path) {
        try {
            String string = path;
            Intrinsics.checkNotNull((Object)string);
            return this.isOpusFile(string) == 1;
        }
        catch (Throwable e) {
            AudioUtilKt.log_e("[isOpusFile] error, msg:" + e.getMessage());
            return false;
        }
    }

    public final void closeFile() {
        this.closeOpusFile();
    }

    public final void readFile(@Nullable ByteBuffer buffer, int capacity, @Nullable int[] args) {
        ByteBuffer byteBuffer = buffer;
        Intrinsics.checkNotNull((Object)byteBuffer);
        Intrinsics.checkNotNull((Object)args);
        this.readOpusFile(byteBuffer, capacity, args);
    }

    public final long getPcmDuration() {
        return this.getTotalPcmDuration();
    }

    public final long getDuration() {
        return Companion.convertPcm2NormalDuration(this.getTotalPcmDuration());
    }

    @Nullable
    public final byte[] getPcmWaveForm(@Nullable String path) {
        return this.getWaveform(path);
    }

    @Nullable
    public final byte[] getPcmWaveform2(@Nullable short[] array, int length) {
        return this.getWaveform2(array, length);
    }

    static {
        boolean bl;
        Companion = new Companion(null);
        try {
            System.loadLibrary("opustool");
            bl = true;
        }
        catch (Exception e) {
            AudioUtilKt.log_d("load library opus failed," + e.getMessage());
            bl = false;
        }
        isLoadSucceed = bl;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lcom/martin/audiolib/OpusTool$Companion;", "", "()V", "IS_OPUS_FILE_FORMAT", "", "OPEN_RECORD_SUC", "READ_OPUS_FINISHED", "START_RECORD_SUC", "WRITE_RECORD_FRAME_SUC", "<set-?>", "", "isLoadSucceed", "()Z", "setLoadSucceed", "(Z)V", "convertPcm2NormalDuration", "", "pcmDuration", "AudioLib_release"})
    public static final class Companion {
        public final boolean isLoadSucceed() {
            return isLoadSucceed;
        }

        private final void setLoadSucceed(boolean bl) {
            isLoadSucceed = bl;
        }

        public final long convertPcm2NormalDuration(long pcmDuration) {
            return (long)((double)pcmDuration / 48.0);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

