/*
 * Decompiled with CFR 0.152.
 */
package dk.nota.lyt.libvlc;

import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;

public abstract class CountDownTimer {
    private final long mMillisInFuture;
    private final long mCountdownInterval;
    private long mStopTimeInFuture;
    private long mPauseTime;
    private boolean mCancelled = false;
    private boolean mFinished = false;
    private boolean mPaused = false;
    private static final int MSG = 1;
    private Handler mHandler = new Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            CountDownTimer countDownTimer = CountDownTimer.this;
            synchronized (countDownTimer) {
                if (!CountDownTimer.this.mPaused) {
                    long millisLeft = CountDownTimer.this.mStopTimeInFuture - SystemClock.elapsedRealtime();
                    if (millisLeft <= 0L) {
                        CountDownTimer.this.onFinish();
                        CountDownTimer.this.mFinished = true;
                    } else if (millisLeft < CountDownTimer.this.mCountdownInterval) {
                        this.sendMessageDelayed(this.obtainMessage(1), millisLeft);
                    } else {
                        long delay;
                        long lastTickStart = SystemClock.elapsedRealtime();
                        CountDownTimer.this.onTick(millisLeft);
                        for (delay = lastTickStart + CountDownTimer.this.mCountdownInterval - SystemClock.elapsedRealtime(); delay < 0L; delay += CountDownTimer.this.mCountdownInterval) {
                        }
                        if (!CountDownTimer.this.mCancelled) {
                            this.sendMessageDelayed(this.obtainMessage(1), delay);
                        }
                    }
                }
            }
        }
    };

    public CountDownTimer(long millisInFuture, long countDownInterval) {
        this.mMillisInFuture = millisInFuture;
        this.mCountdownInterval = countDownInterval;
    }

    public final void cancel() {
        this.mHandler.removeMessages(1);
        this.mCancelled = true;
    }

    public final synchronized CountDownTimer start() {
        if (this.mMillisInFuture <= 0L) {
            this.onFinish();
            this.mFinished = true;
            return this;
        }
        this.mStopTimeInFuture = SystemClock.elapsedRealtime() + this.mMillisInFuture;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1));
        this.mCancelled = false;
        this.mFinished = false;
        this.mPaused = false;
        return this;
    }

    public boolean isPaused() {
        return this.mPaused;
    }

    public long pause() {
        this.mPauseTime = this.mStopTimeInFuture - SystemClock.elapsedRealtime();
        this.mPaused = true;
        return this.mPauseTime;
    }

    public long resume() {
        this.mStopTimeInFuture = this.mPauseTime + SystemClock.elapsedRealtime();
        this.mPaused = false;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1));
        return this.mPauseTime;
    }

    public CountDownTimer reset() {
        return this.start();
    }

    public boolean isFinishedOrCancelled() {
        return this.mCancelled || this.mFinished;
    }

    public long getMilisLeftUntilFinished() {
        return Math.min(0L, this.mStopTimeInFuture - SystemClock.elapsedRealtime());
    }

    public abstract void onTick(long var1);

    public abstract void onFinish();
}

