/*
 * Decompiled with CFR 0.152.
 */
package dk.nota.lyt.libvlc;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.SystemClock;
import android.util.Log;
import android.view.KeyEvent;
import dk.nota.lyt.libvlc.PlaybackService;

public class RemoteControlEventReceiver
extends BroadcastReceiver {
    private static final String TAG = RemoteControlEventReceiver.class.getCanonicalName();
    private static long mHeadsetDownTime = 0L;
    private static long mHeadsetUpTime = 0L;

    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        Log.d((String)TAG, (String)("--- RemoteControlEventReceiver got action: " + action));
        if (action.equalsIgnoreCase("android.intent.action.MEDIA_BUTTON")) {
            KeyEvent event = (KeyEvent)intent.getParcelableExtra("android.intent.extra.KEY_EVENT");
            if (event == null) {
                return;
            }
            if (event.getKeyCode() != 79 && event.getKeyCode() != 85 && event.getAction() != 0) {
                return;
            }
            Intent i = null;
            switch (event.getKeyCode()) {
                case 79: 
                case 85: {
                    long time = SystemClock.uptimeMillis();
                    switch (event.getAction()) {
                        case 0: {
                            if (event.getRepeatCount() > 0) break;
                            mHeadsetDownTime = time;
                            break;
                        }
                        case 1: {
                            if (time - mHeadsetDownTime >= 1000L) {
                                i = new Intent(PlaybackService.ACTION_REMOTE_BACKWARD);
                                break;
                            }
                            if (time - mHeadsetUpTime <= 500L) {
                                i = new Intent(PlaybackService.ACTION_REMOTE_FORWARD);
                                break;
                            }
                            i = new Intent(PlaybackService.ACTION_REMOTE_PLAYPAUSE);
                            mHeadsetUpTime = time;
                        }
                    }
                    break;
                }
                case 126: {
                    i = new Intent(context, PlaybackService.class);
                    i.setAction(PlaybackService.ACTION_REMOTE_PLAY);
                    context.startService(i);
                    return;
                }
                case 127: {
                    i = new Intent(PlaybackService.ACTION_REMOTE_PAUSE);
                    break;
                }
                case 86: {
                    i = new Intent(PlaybackService.ACTION_REMOTE_STOP);
                    break;
                }
                case 87: {
                    i = new Intent(PlaybackService.ACTION_REMOTE_FORWARD);
                    break;
                }
                case 88: {
                    i = new Intent(PlaybackService.ACTION_REMOTE_BACKWARD);
                }
            }
            if (this.isOrderedBroadcast()) {
                this.abortBroadcast();
            }
            if (i != null) {
                context.sendBroadcast(i);
            }
        } else if (action.equals(PlaybackService.ACTION_REMOTE_PLAYPAUSE)) {
            intent = new Intent(context, PlaybackService.class);
            intent.setAction(PlaybackService.ACTION_REMOTE_PLAYPAUSE);
            context.startService(intent);
        }
    }
}

