/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.protocol;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.asn1.codec.mina.Asn1CodecDecoder;
import org.apache.asn1.codec.mina.Asn1CodecEncoder;
import org.apache.asn1.codec.stateful.StatefulDecoder;
import org.apache.asn1.codec.stateful.StatefulEncoder;
import org.apache.ldap.common.exception.LdapNamingException;
import org.apache.ldap.common.message.AbandonRequest;
import org.apache.ldap.common.message.AbandonRequestImpl;
import org.apache.ldap.common.message.AddRequest;
import org.apache.ldap.common.message.AddRequestImpl;
import org.apache.ldap.common.message.BindRequest;
import org.apache.ldap.common.message.BindRequestImpl;
import org.apache.ldap.common.message.CompareRequest;
import org.apache.ldap.common.message.CompareRequestImpl;
import org.apache.ldap.common.message.DeleteRequest;
import org.apache.ldap.common.message.DeleteRequestImpl;
import org.apache.ldap.common.message.ExtendedRequest;
import org.apache.ldap.common.message.ExtendedRequestImpl;
import org.apache.ldap.common.message.MessageDecoder;
import org.apache.ldap.common.message.MessageEncoder;
import org.apache.ldap.common.message.ModifyDnRequest;
import org.apache.ldap.common.message.ModifyDnRequestImpl;
import org.apache.ldap.common.message.ModifyRequest;
import org.apache.ldap.common.message.ModifyRequestImpl;
import org.apache.ldap.common.message.ResultCodeEnum;
import org.apache.ldap.common.message.SearchRequest;
import org.apache.ldap.common.message.SearchRequestImpl;
import org.apache.ldap.common.message.UnbindRequest;
import org.apache.ldap.common.message.UnbindRequestImpl;
import org.apache.ldap.server.protocol.AbandonHandler;
import org.apache.ldap.server.protocol.AddHandler;
import org.apache.ldap.server.protocol.BindHandler;
import org.apache.ldap.server.protocol.CompareHandler;
import org.apache.ldap.server.protocol.DeleteHandler;
import org.apache.ldap.server.protocol.ExtendedHandler;
import org.apache.ldap.server.protocol.ModifyDnHandler;
import org.apache.ldap.server.protocol.ModifyHandler;
import org.apache.ldap.server.protocol.SearchHandler;
import org.apache.ldap.server.protocol.SessionRegistry;
import org.apache.ldap.server.protocol.UnbindHandler;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.protocol.ProtocolCodecFactory;
import org.apache.mina.protocol.ProtocolDecoder;
import org.apache.mina.protocol.ProtocolEncoder;
import org.apache.mina.protocol.ProtocolHandler;
import org.apache.mina.protocol.ProtocolProvider;
import org.apache.mina.protocol.ProtocolSession;
import org.apache.mina.protocol.handler.DemuxingProtocolHandler;
import org.apache.mina.protocol.handler.MessageHandler;

public class LdapProtocolProvider
implements ProtocolProvider {
    public static final String SERVICE_NAME = "ldap";
    public static final Map DEFAULT_HANDLERS;
    private final ProtocolCodecFactory codecFactory;
    private final LdapProtocolHandler handler = new LdapProtocolHandler();

    public LdapProtocolProvider(Hashtable env) throws LdapNamingException {
        Hashtable copy = (Hashtable)env.clone();
        copy.put("java.naming.provider.url", "");
        SessionRegistry.releaseSingleton();
        new SessionRegistry(copy);
        Iterator requestTypes = DEFAULT_HANDLERS.keySet().iterator();
        while (requestTypes.hasNext()) {
            MessageHandler handler = null;
            String type = (String)requestTypes.next();
            Class<?> clazz = null;
            if (copy.containsKey(type)) {
                try {
                    clazz = Class.forName((String)copy.get(type));
                }
                catch (ClassNotFoundException e) {
                    String msg = "failed to load class " + clazz;
                    msg = msg + " for processing " + type + " objects.";
                    LdapNamingException lne = new LdapNamingException(msg, ResultCodeEnum.OTHER);
                    lne.setRootCause((Throwable)e);
                    throw lne;
                }
            } else {
                clazz = (Class<?>)DEFAULT_HANDLERS.get(type);
            }
            try {
                Class<?> typeClass = Class.forName(type);
                handler = (MessageHandler)clazz.newInstance();
                this.handler.registerMessageType(typeClass, handler);
            }
            catch (Exception e) {
                String msg = "failed to create handler instance of " + clazz;
                msg = msg + " for processing " + type + " objects.";
                LdapNamingException lne = new LdapNamingException(msg, ResultCodeEnum.OTHER);
                lne.setRootCause((Throwable)e);
                throw lne;
            }
        }
        this.codecFactory = new ProtocolCodecFactoryImpl(copy);
    }

    public LdapProtocolProvider() throws LdapNamingException {
        SessionRegistry.releaseSingleton();
        new SessionRegistry(null);
        Iterator requestTypes = DEFAULT_HANDLERS.keySet().iterator();
        while (requestTypes.hasNext()) {
            MessageHandler handler = null;
            String type = (String)requestTypes.next();
            Class clazz = null;
            clazz = (Class)DEFAULT_HANDLERS.get(type);
            try {
                Class<?> typeClass = Class.forName(type);
                handler = (MessageHandler)clazz.newInstance();
                this.handler.registerMessageType(typeClass, handler);
            }
            catch (Exception e) {
                String msg = "failed to create handler instance of " + clazz;
                msg = msg + " for processing " + type + " objects.";
                LdapNamingException lne = new LdapNamingException(msg, ResultCodeEnum.OTHER);
                lne.setRootCause((Throwable)e);
                throw lne;
            }
        }
        this.codecFactory = new ProtocolCodecFactoryImpl();
    }

    public String getName() {
        return SERVICE_NAME;
    }

    public ProtocolCodecFactory getCodecFactory() {
        return this.codecFactory;
    }

    public ProtocolHandler getHandler() {
        return this.handler;
    }

    public static void main(String[] args) throws Exception {
        new LdapProtocolProvider();
    }

    static {
        HashMap<String, Class> map = new HashMap<String, Class>();
        map.put(AbandonRequest.class.getName(), AbandonHandler.class);
        map.put(AbandonRequestImpl.class.getName(), AbandonHandler.class);
        map.put(AddRequest.class.getName(), AddHandler.class);
        map.put(AddRequestImpl.class.getName(), AddHandler.class);
        map.put(BindRequest.class.getName(), BindHandler.class);
        map.put(BindRequestImpl.class.getName(), BindHandler.class);
        map.put(CompareRequest.class.getName(), CompareHandler.class);
        map.put(CompareRequestImpl.class.getName(), CompareHandler.class);
        map.put(DeleteRequest.class.getName(), DeleteHandler.class);
        map.put(DeleteRequestImpl.class.getName(), DeleteHandler.class);
        map.put(ExtendedRequest.class.getName(), ExtendedHandler.class);
        map.put(ExtendedRequestImpl.class.getName(), ExtendedHandler.class);
        map.put(ModifyRequest.class.getName(), ModifyHandler.class);
        map.put(ModifyRequestImpl.class.getName(), ModifyHandler.class);
        map.put(ModifyDnRequest.class.getName(), ModifyDnHandler.class);
        map.put(ModifyDnRequestImpl.class.getName(), ModifyDnHandler.class);
        map.put(SearchRequest.class.getName(), SearchHandler.class);
        map.put(SearchRequestImpl.class.getName(), SearchHandler.class);
        map.put(UnbindRequest.class.getName(), UnbindHandler.class);
        map.put(UnbindRequestImpl.class.getName(), UnbindHandler.class);
        DEFAULT_HANDLERS = Collections.unmodifiableMap(map);
    }

    private class LdapProtocolHandler
    extends DemuxingProtocolHandler {
        private LdapProtocolHandler() {
        }

        protected void deregisterMessageType(Class arg0) {
            super.deregisterMessageType(arg0);
        }

        protected void registerMessageType(Class arg0, MessageHandler arg1) {
            super.registerMessageType(arg0, arg1);
        }

        public void sessionClosed(ProtocolSession session) {
            SessionRegistry.getSingleton().remove(session);
        }

        public void exceptionCaught(ProtocolSession session, Throwable cause) {
            cause.printStackTrace();
        }

        public void messageSent(ProtocolSession arg0, Object arg1) {
        }

        public void sessionIdle(ProtocolSession arg0, IdleStatus arg1) {
        }

        public void sessionOpened(ProtocolSession arg0) {
        }

        public void sessionCreated(ProtocolSession arg0) {
        }
    }

    private static final class ProtocolCodecFactoryImpl
    implements ProtocolCodecFactory {
        final Hashtable env;

        public ProtocolCodecFactoryImpl() {
            this.env = null;
        }

        ProtocolCodecFactoryImpl(Hashtable env) {
            this.env = env;
        }

        public ProtocolEncoder newEncoder() {
            if (this.env == null || this.env.get("asn.1.berlib.provider") == null) {
                return new Asn1CodecEncoder((StatefulEncoder)new MessageEncoder());
            }
            return new Asn1CodecEncoder((StatefulEncoder)new MessageEncoder(this.env));
        }

        public ProtocolDecoder newDecoder() {
            if (this.env == null || this.env.get("asn.1.berlib.provider") == null) {
                return new Asn1CodecDecoder((StatefulDecoder)new MessageDecoder());
            }
            return new Asn1CodecDecoder((StatefulDecoder)new MessageDecoder(this.env));
        }
    }
}

