/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.security.engine.core;

import com.google.common.collect.ImmutableList;
import digital.nedra.commons.starter.security.engine.core.Authority;
import digital.nedra.commons.starter.security.engine.core.AuthorityException;
import digital.nedra.commons.starter.security.engine.core.Fields;
import digital.nedra.commons.starter.security.engine.core.RoleBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.springframework.security.util.FieldUtils;
import org.springframework.util.CollectionUtils;

public interface RoleHandler {
    public List<Authority> getAuthorities();

    public String getRole();

    public BiPredicate<String, Object> getHandler();

    public static RoleBuilder builder() {
        return new RoleBuilder.DefaultRoleBuilder();
    }

    default public boolean handle(String authority, Object context) {
        BiPredicate<String, Object> handler = this.getHandler();
        if (handler == null) {
            handler = this.defaultHandler();
        }
        return handler.test(authority, context);
    }

    default public BiPredicate<String, Object> defaultHandler() {
        return (authority, context) -> {
            Authority currentAuthority = this.getAuthorities().stream().filter(auth -> authority.equalsIgnoreCase(auth.getName())).findFirst().orElse(null);
            if (currentAuthority == null) {
                return false;
            }
            Fields fields = currentAuthority.getContext();
            List contextFields = Optional.ofNullable(fields).map(Fields::getValue).orElse(null);
            if (CollectionUtils.isEmpty((Collection)contextFields)) {
                return currentAuthority.isAvailable();
            }
            Function<String, Boolean> func = field -> this.getFieldValue(context, (String)field);
            Fields.Type type = fields.getType();
            ImmutableList<String> attr = fields.getValue();
            switch (type) {
                case AND: {
                    return attr.stream().map(func).filter(Boolean.FALSE::equals).findFirst().orElse(true);
                }
                case OR: {
                    return attr.stream().map(func).filter(Boolean.TRUE::equals).findFirst().orElse(false);
                }
            }
            return false;
        };
    }

    private boolean getFieldValue(Object context, String fieldName) {
        Object value = FieldUtils.getProtectedFieldValue((String)fieldName, (Object)context);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new AuthorityException(String.format("Field [%s] of [%s] is not boolean.", fieldName, context.getClass()));
    }

    public static class DefaultRoleHandler
    implements RoleHandler {
        private String role;
        private List<Authority> authorities;
        private BiPredicate<String, Object> handler;

        @Override
        public List<Authority> getAuthorities() {
            return this.authorities;
        }

        @Override
        public String getRole() {
            return this.role;
        }

        @Override
        public BiPredicate<String, Object> getHandler() {
            return this.handler;
        }

        DefaultRoleHandler(String role, List<Authority> authorities, BiPredicate<String, Object> handler) {
            this.role = role;
            this.authorities = authorities;
            this.handler = handler;
        }
    }
}

