/*
 * Decompiled with CFR 0.152.
 */
package devlight.io.library.ntb;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.design.widget.CoordinatorLayout;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPager;
import android.support.v4.view.animation.LinearOutSlowInInterpolator;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.Scroller;
import com.gigamole.navigationtabbar.R;
import devlight.io.library.behavior.NavigationTabBarBehavior;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class NavigationTabBar
extends View
implements ViewPager.OnPageChangeListener {
    protected static final int FLAGS = 7;
    protected static final String PREVIEW_BADGE = "0";
    protected static final String PREVIEW_TITLE = "Title";
    protected static final int INVALID_INDEX = -1;
    public static final int AUTO_SIZE = -2;
    public static final int AUTO_COLOR = -3;
    public static final int AUTO_SCALE = -4;
    protected static final int DEFAULT_BADGE_ANIMATION_DURATION = 200;
    protected static final int DEFAULT_BADGE_REFRESH_ANIMATION_DURATION = 100;
    protected static final int DEFAULT_ANIMATION_DURATION = 300;
    protected static final float DEFAULT_ICON_SIZE_FRACTION = 0.5f;
    protected static final float DEFAULT_TITLE_ICON_SIZE_FRACTION = 0.5f;
    protected static final int DEFAULT_INACTIVE_COLOR = Color.parseColor((String)"#9f90af");
    protected static final int DEFAULT_ACTIVE_COLOR = -1;
    protected static final int DEFAULT_BG_COLOR = Color.parseColor((String)"#605271");
    protected static final float MIN_FRACTION = 0.0f;
    protected static final float MAX_FRACTION = 1.0f;
    protected static final int MIN_ALPHA = 0;
    protected static final int MAX_ALPHA = 255;
    protected static final float SCALED_FRACTION = 0.3f;
    protected static final float TITLE_ACTIVE_ICON_SCALE_BY = 0.2f;
    protected static final float TITLE_ACTIVE_SCALE_BY = 0.2f;
    protected static final float TITLE_SIZE_FRACTION = 0.2f;
    protected static final float TITLE_MARGIN_FRACTION = 0.15f;
    protected static final float TITLE_MARGIN_SCALE_FRACTION = 0.25f;
    protected static final float BADGE_HORIZONTAL_FRACTION = 0.5f;
    protected static final float BADGE_VERTICAL_FRACTION = 0.75f;
    protected static final float BADGE_TITLE_SIZE_FRACTION = 0.9f;
    protected static final float LEFT_FRACTION = 0.25f;
    protected static final float CENTER_FRACTION = 0.5f;
    protected static final float RIGHT_FRACTION = 0.75f;
    protected static final Interpolator DECELERATE_INTERPOLATOR = new DecelerateInterpolator();
    protected static final Interpolator ACCELERATE_INTERPOLATOR = new AccelerateInterpolator();
    protected static final Interpolator OUT_SLOW_IN_INTERPOLATOR = new LinearOutSlowInInterpolator();
    protected final RectF mBounds;
    protected final RectF mBgBounds;
    protected final RectF mPointerBounds;
    protected final Rect mBadgeBounds;
    protected final RectF mBgBadgeBounds;
    protected Bitmap mBitmap;
    protected final Canvas mCanvas;
    protected Bitmap mIconsBitmap;
    protected final Canvas mIconsCanvas;
    protected Bitmap mTitlesBitmap;
    protected final Canvas mTitlesCanvas;
    protected Bitmap mPointerBitmap;
    protected final Canvas mPointerCanvas;
    protected NavigationTabBarBehavior mBehavior;
    protected boolean mIsBehaviorSet;
    protected boolean mBehaviorEnabled;
    protected boolean mNeedHide;
    protected boolean mAnimateHide;
    protected final Paint mPaint;
    protected final Paint mBgPaint;
    protected final Paint mPointerPaint;
    protected final Paint mIconPaint;
    protected final Paint mSelectedIconPaint;
    protected final Paint mIconPointerPaint;
    protected final Paint mModelTitlePaint;
    protected final Paint mBadgePaint;
    protected final ValueAnimator mAnimator;
    protected final ResizeInterpolator mResizeInterpolator;
    protected int mAnimationDuration;
    protected final List<Model> mModels;
    protected ViewPager mViewPager;
    protected ViewPager.OnPageChangeListener mOnPageChangeListener;
    protected int mScrollState;
    protected OnTabBarSelectedIndexListener mOnTabBarSelectedIndexListener;
    protected Animator.AnimatorListener mAnimatorListener;
    protected float mModelSize;
    protected float mIconSize;
    protected float mIconSizeFraction;
    protected float mCornersRadius;
    protected float mModelTitleSize;
    protected float mTitleMargin;
    protected float mBadgeMargin;
    protected float mBadgeTitleSize;
    protected TitleMode mTitleMode;
    protected BadgePosition mBadgePosition;
    protected BadgeGravity mBadgeGravity;
    protected int mBadgeTitleColor;
    protected int mBadgeBgColor;
    protected int mLastIndex;
    protected int mIndex;
    protected float mFraction;
    protected float mStartPointerX;
    protected float mEndPointerX;
    protected float mPointerLeftTop;
    protected float mPointerRightBottom;
    protected boolean mIsTitled;
    protected boolean mIsBadged;
    protected boolean mIsScaled;
    protected boolean mIsTinted;
    protected boolean mIsSwiped;
    protected boolean mIsBadgeUseTypeface;
    protected boolean mIsViewPagerMode;
    protected boolean mIsHorizontalOrientation;
    protected boolean mIsResizeIn;
    protected boolean mIsActionDown;
    protected boolean mIsPointerActionDown;
    protected boolean mIsSetIndexFromTabBar;
    protected int mInactiveColor;
    protected int mActiveColor;
    protected int mBgColor;
    protected Typeface mTypeface;

    public NavigationTabBar(Context context) {
        this(context, null);
    }

    public NavigationTabBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NavigationTabBar(Context context, AttributeSet attrs, int defStyleAttr) {
        block10: {
            super(context, attrs, defStyleAttr);
            this.mBounds = new RectF();
            this.mBgBounds = new RectF();
            this.mPointerBounds = new RectF();
            this.mBadgeBounds = new Rect();
            this.mBgBadgeBounds = new RectF();
            this.mCanvas = new Canvas();
            this.mIconsCanvas = new Canvas();
            this.mTitlesCanvas = new Canvas();
            this.mPointerCanvas = new Canvas();
            this.mPaint = new Paint(7){
                {
                    this.setStyle(Paint.Style.FILL);
                }
            };
            this.mBgPaint = new Paint(7){
                {
                    this.setStyle(Paint.Style.FILL);
                }
            };
            this.mPointerPaint = new Paint(7){
                {
                    this.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
                }
            };
            this.mIconPaint = new Paint(7);
            this.mSelectedIconPaint = new Paint(7);
            this.mIconPointerPaint = new Paint(7){
                {
                    this.setStyle(Paint.Style.FILL);
                    this.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
                }
            };
            this.mModelTitlePaint = new TextPaint(7){
                {
                    this.setColor(-1);
                    this.setTextAlign(Paint.Align.CENTER);
                }
            };
            this.mBadgePaint = new TextPaint(7){
                {
                    this.setTextAlign(Paint.Align.CENTER);
                    this.setFakeBoldText(true);
                }
            };
            this.mAnimator = new ValueAnimator();
            this.mResizeInterpolator = new ResizeInterpolator();
            this.mModels = new ArrayList<Model>();
            this.mModelTitleSize = -2.0f;
            this.mBadgeTitleSize = -2.0f;
            this.mBadgeTitleColor = -3;
            this.mBadgeBgColor = -3;
            this.mLastIndex = -1;
            this.mIndex = -1;
            this.setWillNotDraw(false);
            ViewCompat.setLayerType((View)this, (int)1, null);
            this.setLayerType(1, null);
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.NavigationTabBar);
            try {
                this.setIsTitled(typedArray.getBoolean(R.styleable.NavigationTabBar_ntb_titled, false));
                this.setIsBadged(typedArray.getBoolean(R.styleable.NavigationTabBar_ntb_badged, false));
                this.setIsScaled(typedArray.getBoolean(R.styleable.NavigationTabBar_ntb_scaled, true));
                this.setIsTinted(typedArray.getBoolean(R.styleable.NavigationTabBar_ntb_tinted, true));
                this.setIsSwiped(typedArray.getBoolean(R.styleable.NavigationTabBar_ntb_swiped, true));
                this.setTitleSize(typedArray.getDimension(R.styleable.NavigationTabBar_ntb_title_size, -2.0f));
                this.setIsBadgeUseTypeface(typedArray.getBoolean(R.styleable.NavigationTabBar_ntb_badge_use_typeface, false));
                this.setTitleMode(typedArray.getInt(R.styleable.NavigationTabBar_ntb_title_mode, 0));
                this.setBadgeSize(typedArray.getDimension(R.styleable.NavigationTabBar_ntb_badge_size, -2.0f));
                this.setBadgePosition(typedArray.getInt(R.styleable.NavigationTabBar_ntb_badge_position, 2));
                this.setBadgeGravity(typedArray.getInt(R.styleable.NavigationTabBar_ntb_badge_gravity, 0));
                this.setBadgeBgColor(typedArray.getColor(R.styleable.NavigationTabBar_ntb_badge_bg_color, -3));
                this.setBadgeTitleColor(typedArray.getColor(R.styleable.NavigationTabBar_ntb_badge_title_color, -3));
                this.setTypeface(typedArray.getString(R.styleable.NavigationTabBar_ntb_typeface));
                this.setInactiveColor(typedArray.getColor(R.styleable.NavigationTabBar_ntb_inactive_color, DEFAULT_INACTIVE_COLOR));
                this.setActiveColor(typedArray.getColor(R.styleable.NavigationTabBar_ntb_active_color, -1));
                this.setBgColor(typedArray.getColor(R.styleable.NavigationTabBar_ntb_bg_color, DEFAULT_BG_COLOR));
                this.setAnimationDuration(typedArray.getInteger(R.styleable.NavigationTabBar_ntb_animation_duration, 300));
                this.setCornersRadius(typedArray.getDimension(R.styleable.NavigationTabBar_ntb_corners_radius, 0.0f));
                this.setIconSizeFraction(typedArray.getFloat(R.styleable.NavigationTabBar_ntb_icon_size_fraction, -4.0f));
                this.mAnimator.setFloatValues(new float[]{0.0f, 1.0f});
                this.mAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
                this.mAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animation) {
                        NavigationTabBar.this.updateIndicatorPosition(((Float)animation.getAnimatedValue()).floatValue());
                    }
                });
                if (!this.isInEditMode()) break block10;
                String[] previewColors = null;
                try {
                    int previewColorsId = typedArray.getResourceId(R.styleable.NavigationTabBar_ntb_preview_colors, 0);
                    previewColors = previewColorsId == 0 ? null : typedArray.getResources().getStringArray(previewColorsId);
                }
                catch (Exception exception) {
                    previewColors = null;
                    exception.printStackTrace();
                }
                finally {
                    if (previewColors == null) {
                        previewColors = typedArray.getResources().getStringArray(R.array.default_preview);
                    }
                    for (String previewColor : previewColors) {
                        this.mModels.add(new Model.Builder(null, Color.parseColor((String)previewColor)).build());
                    }
                    this.requestLayout();
                }
            }
            finally {
                typedArray.recycle();
            }
        }
    }

    public int getAnimationDuration() {
        return this.mAnimationDuration;
    }

    public void setAnimationDuration(int animationDuration) {
        this.mAnimationDuration = animationDuration;
        this.mAnimator.setDuration((long)this.mAnimationDuration);
        this.resetScroller();
    }

    public List<Model> getModels() {
        return this.mModels;
    }

    public void setModels(List<Model> models) {
        for (final Model model : models) {
            model.mBadgeAnimator.removeAllUpdateListeners();
            model.mBadgeAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    model.mBadgeFraction = ((Float)animation.getAnimatedValue()).floatValue();
                    NavigationTabBar.this.postInvalidate();
                }
            });
        }
        this.mModels.clear();
        this.mModels.addAll(models);
        this.requestLayout();
    }

    public boolean isTitled() {
        return this.mIsTitled;
    }

    public void setIsTitled(boolean isTitled) {
        this.mIsTitled = isTitled;
        this.requestLayout();
    }

    public boolean isBadged() {
        return this.mIsBadged;
    }

    public void setIsBadged(boolean isBadged) {
        this.mIsBadged = isBadged;
        this.requestLayout();
    }

    public boolean isScaled() {
        return this.mIsScaled;
    }

    public void setIsScaled(boolean isScaled) {
        this.mIsScaled = isScaled;
        this.requestLayout();
    }

    public boolean isTinted() {
        return this.mIsTinted;
    }

    public void setIsTinted(boolean isTinted) {
        this.mIsTinted = isTinted;
        this.updateTint();
    }

    public boolean isSwiped() {
        return this.mIsSwiped;
    }

    public void setIsSwiped(boolean swiped) {
        this.mIsSwiped = swiped;
    }

    public float getTitleSize() {
        return this.mModelTitleSize;
    }

    public void setTitleSize(float modelTitleSize) {
        this.mModelTitleSize = modelTitleSize;
        if (modelTitleSize == -2.0f) {
            this.requestLayout();
        }
    }

    public boolean isBadgeUseTypeface() {
        return this.mIsBadgeUseTypeface;
    }

    public void setIsBadgeUseTypeface(boolean isBadgeUseTypeface) {
        this.mIsBadgeUseTypeface = isBadgeUseTypeface;
        this.setBadgeTypeface();
        this.postInvalidate();
    }

    public TitleMode getTitleMode() {
        return this.mTitleMode;
    }

    protected void setTitleMode(int index) {
        switch (index) {
            case 1: {
                this.setTitleMode(TitleMode.ACTIVE);
                break;
            }
            default: {
                this.setTitleMode(TitleMode.ALL);
            }
        }
    }

    public void setTitleMode(TitleMode titleMode) {
        this.mTitleMode = titleMode;
        this.postInvalidate();
    }

    public BadgePosition getBadgePosition() {
        return this.mBadgePosition;
    }

    protected void setBadgePosition(int index) {
        switch (index) {
            case 0: {
                this.setBadgePosition(BadgePosition.LEFT);
                break;
            }
            case 1: {
                this.setBadgePosition(BadgePosition.CENTER);
                break;
            }
            default: {
                this.setBadgePosition(BadgePosition.RIGHT);
            }
        }
    }

    public void setBadgePosition(BadgePosition badgePosition) {
        this.mBadgePosition = badgePosition;
        this.postInvalidate();
    }

    public BadgeGravity getBadgeGravity() {
        return this.mBadgeGravity;
    }

    protected void setBadgeGravity(int index) {
        switch (index) {
            case 1: {
                this.setBadgeGravity(BadgeGravity.BOTTOM);
                break;
            }
            default: {
                this.setBadgeGravity(BadgeGravity.TOP);
            }
        }
    }

    public void setBadgeGravity(BadgeGravity badgeGravity) {
        this.mBadgeGravity = badgeGravity;
        this.requestLayout();
    }

    public int getBadgeBgColor() {
        return this.mBadgeBgColor;
    }

    public void setBadgeBgColor(int badgeBgColor) {
        this.mBadgeBgColor = badgeBgColor;
    }

    public int getBadgeTitleColor() {
        return this.mBadgeTitleColor;
    }

    public void setBadgeTitleColor(int badgeTitleColor) {
        this.mBadgeTitleColor = badgeTitleColor;
    }

    public float getBadgeSize() {
        return this.mBadgeTitleSize;
    }

    public void setBadgeSize(float badgeTitleSize) {
        this.mBadgeTitleSize = badgeTitleSize;
        if (this.mBadgeTitleSize == -2.0f) {
            this.requestLayout();
        }
    }

    public Typeface getTypeface() {
        return this.mTypeface;
    }

    public void setTypeface(String typeface) {
        Typeface tempTypeface;
        if (TextUtils.isEmpty((CharSequence)typeface)) {
            return;
        }
        try {
            tempTypeface = Typeface.createFromAsset((AssetManager)this.getContext().getAssets(), (String)typeface);
        }
        catch (Exception e) {
            tempTypeface = Typeface.create((Typeface)Typeface.DEFAULT, (int)0);
            e.printStackTrace();
        }
        this.setTypeface(tempTypeface);
    }

    public void setTypeface(Typeface typeface) {
        this.mTypeface = typeface;
        this.mModelTitlePaint.setTypeface(typeface);
        this.setBadgeTypeface();
        this.postInvalidate();
    }

    protected void setBadgeTypeface() {
        this.mBadgePaint.setTypeface(this.mIsBadgeUseTypeface ? this.mTypeface : Typeface.create((Typeface)Typeface.DEFAULT, (int)0));
    }

    public int getActiveColor() {
        return this.mActiveColor;
    }

    public void setActiveColor(int activeColor) {
        this.mActiveColor = activeColor;
        this.mIconPointerPaint.setColor(this.mActiveColor);
        this.updateTint();
    }

    public int getInactiveColor() {
        return this.mInactiveColor;
    }

    public void setInactiveColor(int inactiveColor) {
        this.mInactiveColor = inactiveColor;
        this.mModelTitlePaint.setColor(this.mInactiveColor);
        this.updateTint();
    }

    public int getBgColor() {
        return this.mBgColor;
    }

    public void setBgColor(int bgColor) {
        this.mBgColor = bgColor;
        this.mBgPaint.setColor(this.mBgColor);
        this.postInvalidate();
    }

    public float getCornersRadius() {
        return this.mCornersRadius;
    }

    public void setCornersRadius(float cornersRadius) {
        this.mCornersRadius = cornersRadius;
        this.postInvalidate();
    }

    public float getIconSizeFraction() {
        return this.mIconSizeFraction;
    }

    public void setIconSizeFraction(float iconSizeFraction) {
        this.mIconSizeFraction = iconSizeFraction;
        this.requestLayout();
    }

    public float getBadgeMargin() {
        return this.mBadgeMargin;
    }

    public float getBarHeight() {
        return this.mBounds.height();
    }

    public OnTabBarSelectedIndexListener getOnTabBarSelectedIndexListener() {
        return this.mOnTabBarSelectedIndexListener;
    }

    public void setOnTabBarSelectedIndexListener(OnTabBarSelectedIndexListener onTabBarSelectedIndexListener) {
        this.mOnTabBarSelectedIndexListener = onTabBarSelectedIndexListener;
        if (this.mAnimatorListener == null) {
            this.mAnimatorListener = new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    if (NavigationTabBar.this.mOnTabBarSelectedIndexListener != null) {
                        NavigationTabBar.this.mOnTabBarSelectedIndexListener.onStartTabSelected(NavigationTabBar.this.mModels.get(NavigationTabBar.this.mIndex), NavigationTabBar.this.mIndex);
                    }
                    animation.removeListener((Animator.AnimatorListener)this);
                    animation.addListener((Animator.AnimatorListener)this);
                }

                public void onAnimationEnd(Animator animation) {
                    if (NavigationTabBar.this.mIsViewPagerMode) {
                        return;
                    }
                    animation.removeListener((Animator.AnimatorListener)this);
                    animation.addListener((Animator.AnimatorListener)this);
                    if (NavigationTabBar.this.mOnTabBarSelectedIndexListener != null) {
                        NavigationTabBar.this.mOnTabBarSelectedIndexListener.onEndTabSelected(NavigationTabBar.this.mModels.get(NavigationTabBar.this.mIndex), NavigationTabBar.this.mIndex);
                    }
                }
            };
        }
        this.mAnimator.removeListener(this.mAnimatorListener);
        this.mAnimator.addListener(this.mAnimatorListener);
    }

    public void setViewPager(ViewPager viewPager) {
        if (viewPager == null) {
            this.mIsViewPagerMode = false;
            return;
        }
        if (viewPager.equals(this.mViewPager)) {
            return;
        }
        if (this.mViewPager != null) {
            this.mViewPager.setOnPageChangeListener(null);
        }
        if (viewPager.getAdapter() == null) {
            throw new IllegalStateException("ViewPager does not provide adapter instance.");
        }
        this.mIsViewPagerMode = true;
        this.mViewPager = viewPager;
        this.mViewPager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.resetScroller();
        this.postInvalidate();
    }

    public void setViewPager(ViewPager viewPager, int index) {
        this.setViewPager(viewPager);
        this.mIndex = index;
        if (this.mIsViewPagerMode) {
            this.mViewPager.setCurrentItem(index, true);
        }
        this.postInvalidate();
    }

    protected void resetScroller() {
        if (this.mViewPager == null) {
            return;
        }
        try {
            Field scrollerField = ViewPager.class.getDeclaredField("mScroller");
            scrollerField.setAccessible(true);
            ResizeViewPagerScroller scroller = new ResizeViewPagerScroller(this.getContext());
            scrollerField.set(this.mViewPager, (Object)scroller);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.mOnPageChangeListener = listener;
    }

    public boolean isBehaviorEnabled() {
        return this.mBehaviorEnabled;
    }

    public void setBehaviorEnabled(boolean enabled) {
        this.mBehaviorEnabled = enabled;
        if (this.getParent() != null && this.getParent() instanceof CoordinatorLayout) {
            ViewGroup.LayoutParams params = this.getLayoutParams();
            if (this.mBehavior == null) {
                this.mBehavior = new NavigationTabBarBehavior(enabled);
            } else {
                this.mBehavior.setBehaviorTranslationEnabled(enabled);
            }
            ((CoordinatorLayout.LayoutParams)params).setBehavior((CoordinatorLayout.Behavior)this.mBehavior);
            if (this.mNeedHide) {
                this.mNeedHide = false;
                this.mBehavior.hideView(this, (int)this.getBarHeight(), this.mAnimateHide);
            }
        }
    }

    public int getModelIndex() {
        return this.mIndex;
    }

    public void setModelIndex(int index) {
        this.setModelIndex(index, false);
    }

    public void setModelIndex(int modelIndex, boolean isForce) {
        if (this.mAnimator.isRunning()) {
            return;
        }
        if (this.mModels.isEmpty()) {
            return;
        }
        int index = modelIndex;
        boolean force = isForce;
        if (this.mIndex == -1) {
            force = true;
        }
        if (index == this.mIndex) {
            force = true;
        }
        this.mIsResizeIn = (index = Math.max(0, Math.min(index, this.mModels.size() - 1))) < this.mIndex;
        this.mLastIndex = this.mIndex;
        this.mIndex = index;
        this.mIsSetIndexFromTabBar = true;
        if (this.mIsViewPagerMode) {
            if (this.mViewPager == null) {
                throw new IllegalStateException("ViewPager is null.");
            }
            this.mViewPager.setCurrentItem(index, !force);
        }
        if (force) {
            this.mEndPointerX = this.mStartPointerX = (float)this.mIndex * this.mModelSize;
        } else {
            this.mStartPointerX = this.mPointerLeftTop;
            this.mEndPointerX = (float)this.mIndex * this.mModelSize;
        }
        if (force) {
            this.updateIndicatorPosition(1.0f);
            if (this.mOnTabBarSelectedIndexListener != null) {
                this.mOnTabBarSelectedIndexListener.onStartTabSelected(this.mModels.get(this.mIndex), this.mIndex);
            }
            if (this.mIsViewPagerMode) {
                if (!this.mViewPager.isFakeDragging()) {
                    this.mViewPager.beginFakeDrag();
                }
                if (this.mViewPager.isFakeDragging()) {
                    this.mViewPager.fakeDragBy(0.0f);
                }
                if (this.mViewPager.isFakeDragging()) {
                    this.mViewPager.endFakeDrag();
                }
            } else if (this.mOnTabBarSelectedIndexListener != null) {
                this.mOnTabBarSelectedIndexListener.onEndTabSelected(this.mModels.get(this.mIndex), this.mIndex);
            }
        } else {
            this.mAnimator.start();
        }
    }

    public void deselect() {
        this.mLastIndex = -1;
        this.mIndex = -1;
        this.mEndPointerX = this.mStartPointerX = -1.0f * this.mModelSize;
        this.updateIndicatorPosition(0.0f);
    }

    protected void updateIndicatorPosition(float fraction) {
        this.mFraction = fraction;
        this.mPointerLeftTop = this.mStartPointerX + this.mResizeInterpolator.getResizeInterpolation(fraction, this.mIsResizeIn) * (this.mEndPointerX - this.mStartPointerX);
        this.mPointerRightBottom = this.mStartPointerX + this.mModelSize + this.mResizeInterpolator.getResizeInterpolation(fraction, !this.mIsResizeIn) * (this.mEndPointerX - this.mStartPointerX);
        this.postInvalidate();
    }

    protected void notifyDataSetChanged() {
        this.requestLayout();
        this.postInvalidate();
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mAnimator.isRunning()) {
            return true;
        }
        if (this.mScrollState != 0) {
            return true;
        }
        switch (event.getAction()) {
            case 0: {
                this.mIsActionDown = true;
                if (!this.mIsViewPagerMode || !this.mIsSwiped) break;
                if (this.mIsHorizontalOrientation) {
                    this.mIsPointerActionDown = (int)(event.getX() / this.mModelSize) == this.mIndex;
                    break;
                }
                this.mIsPointerActionDown = (int)(event.getY() / this.mModelSize) == this.mIndex;
                break;
            }
            case 2: {
                if (this.mIsPointerActionDown) {
                    if (this.mIsHorizontalOrientation) {
                        this.mViewPager.setCurrentItem((int)(event.getX() / this.mModelSize), true);
                        break;
                    }
                    this.mViewPager.setCurrentItem((int)(event.getY() / this.mModelSize), true);
                    break;
                }
                if (this.mIsActionDown) break;
            }
            case 1: {
                if (this.mIsActionDown) {
                    this.playSoundEffect(0);
                    if (this.mIsHorizontalOrientation) {
                        this.setModelIndex((int)(event.getX() / this.mModelSize));
                    } else {
                        this.setModelIndex((int)(event.getY() / this.mModelSize));
                    }
                }
            }
            default: {
                this.mIsPointerActionDown = false;
                this.mIsActionDown = false;
            }
        }
        return true;
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.mModels.isEmpty() || width == 0 || height == 0) {
            return;
        }
        if (width > height) {
            float side;
            this.mIsHorizontalOrientation = true;
            this.mModelSize = (float)width / (float)this.mModels.size();
            float f = side = this.mModelSize > (float)height ? (float)height : this.mModelSize;
            if (this.mIsBadged) {
                side -= side * 0.2f;
            }
            this.mIconSize = side * (this.mIconSizeFraction != -4.0f ? this.mIconSizeFraction : (this.mIsTitled ? 0.5f : 0.5f));
            if (this.mModelTitleSize == -2.0f) {
                this.mModelTitleSize = side * 0.2f;
            }
            this.mTitleMargin = side * 0.15f;
            if (this.mIsBadged) {
                if (this.mBadgeTitleSize == -2.0f) {
                    this.mBadgeTitleSize = side * 0.2f * 0.9f;
                }
                Rect badgeBounds = new Rect();
                this.mBadgePaint.setTextSize(this.mBadgeTitleSize);
                this.mBadgePaint.getTextBounds(PREVIEW_BADGE, 0, 1, badgeBounds);
                this.mBadgeMargin = (float)badgeBounds.height() * 0.5f + this.mBadgeTitleSize * 0.5f * 0.75f;
            }
        } else {
            this.mBehaviorEnabled = false;
            this.mIsHorizontalOrientation = false;
            this.mIsTitled = false;
            this.mIsBadged = false;
            this.mModelSize = (float)height / (float)this.mModels.size();
            this.mIconSize = (int)((this.mModelSize > (float)width ? (float)width : this.mModelSize) * (this.mIconSizeFraction == -4.0f ? 0.5f : this.mIconSizeFraction));
        }
        this.mBounds.set(0.0f, 0.0f, (float)width, (float)height - this.mBadgeMargin);
        float barBadgeMargin = this.mBadgeGravity == BadgeGravity.TOP ? this.mBadgeMargin : 0.0f;
        this.mBgBounds.set(0.0f, barBadgeMargin, this.mBounds.width(), this.mBounds.height() + barBadgeMargin);
        for (Model model : this.mModels) {
            float originalIconSize = model.mIcon.getWidth() > model.mIcon.getHeight() ? (float)model.mIcon.getWidth() : (float)model.mIcon.getHeight();
            model.mInactiveIconScale = this.mIconSize / originalIconSize;
            model.mActiveIconScaleBy = model.mInactiveIconScale * (this.mIsTitled ? 0.2f : 0.3f);
        }
        this.mBitmap = null;
        this.mPointerBitmap = null;
        this.mIconsBitmap = null;
        if (this.mIsTitled) {
            this.mTitlesBitmap = null;
        }
        if (this.isInEditMode() || !this.mIsViewPagerMode) {
            this.mIsSetIndexFromTabBar = true;
            if (this.isInEditMode()) {
                this.mIndex = new Random().nextInt(this.mModels.size());
                if (this.mIsBadged) {
                    for (int i = 0; i < this.mModels.size(); ++i) {
                        Model model;
                        model = this.mModels.get(i);
                        if (i == this.mIndex) {
                            model.mBadgeFraction = 1.0f;
                            model.showBadge();
                            continue;
                        }
                        model.mBadgeFraction = 0.0f;
                        model.hideBadge();
                    }
                }
            }
            this.mEndPointerX = this.mStartPointerX = (float)this.mIndex * this.mModelSize;
            this.updateIndicatorPosition(1.0f);
        }
        if (!this.mIsBehaviorSet) {
            this.setBehaviorEnabled(this.mBehaviorEnabled);
            this.mIsBehaviorSet = true;
        }
    }

    protected void onDraw(Canvas canvas) {
        int mBadgedHeight = (int)(this.mBounds.height() + this.mBadgeMargin);
        if (this.mBitmap == null || this.mBitmap.isRecycled()) {
            this.mBitmap = Bitmap.createBitmap((int)((int)this.mBounds.width()), (int)mBadgedHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.mCanvas.setBitmap(this.mBitmap);
        }
        if (this.mPointerBitmap == null || this.mPointerBitmap.isRecycled()) {
            this.mPointerBitmap = Bitmap.createBitmap((int)((int)this.mBounds.width()), (int)mBadgedHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.mPointerCanvas.setBitmap(this.mPointerBitmap);
        }
        if (this.mIconsBitmap == null || this.mIconsBitmap.isRecycled()) {
            this.mIconsBitmap = Bitmap.createBitmap((int)((int)this.mBounds.width()), (int)mBadgedHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.mIconsCanvas.setBitmap(this.mIconsBitmap);
        }
        if (this.mIsTitled) {
            if (this.mTitlesBitmap == null || this.mTitlesBitmap.isRecycled()) {
                this.mTitlesBitmap = Bitmap.createBitmap((int)((int)this.mBounds.width()), (int)mBadgedHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                this.mTitlesCanvas.setBitmap(this.mTitlesBitmap);
            }
        } else {
            this.mTitlesBitmap = null;
        }
        this.mCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
        this.mPointerCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
        this.mIconsCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
        if (this.mIsTitled) {
            this.mTitlesCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
        }
        if (this.mCornersRadius == 0.0f) {
            canvas.drawRect(this.mBgBounds, this.mBgPaint);
        } else {
            canvas.drawRoundRect(this.mBgBounds, this.mCornersRadius, this.mCornersRadius, this.mBgPaint);
        }
        float barBadgeMargin = this.mBadgeGravity == BadgeGravity.TOP ? this.mBadgeMargin : 0.0f;
        for (int i = 0; i < this.mModels.size(); ++i) {
            this.mPaint.setColor(this.mModels.get(i).getColor());
            if (this.mIsHorizontalOrientation) {
                float left = this.mModelSize * (float)i;
                float right = left + this.mModelSize;
                this.mCanvas.drawRect(left, barBadgeMargin, right, this.mBounds.height() + barBadgeMargin, this.mPaint);
                continue;
            }
            float top = this.mModelSize * (float)i;
            float bottom = top + this.mModelSize;
            this.mCanvas.drawRect(0.0f, top, this.mBounds.width(), bottom, this.mPaint);
        }
        if (this.mIsHorizontalOrientation) {
            this.mPointerBounds.set(this.mPointerLeftTop, barBadgeMargin, this.mPointerRightBottom, this.mBounds.height() + barBadgeMargin);
        } else {
            this.mPointerBounds.set(0.0f, this.mPointerLeftTop, this.mBounds.width(), this.mPointerRightBottom);
        }
        if (this.mCornersRadius == 0.0f) {
            this.mPointerCanvas.drawRect(this.mPointerBounds, this.mPaint);
        } else {
            this.mPointerCanvas.drawRoundRect(this.mPointerBounds, this.mCornersRadius, this.mCornersRadius, this.mPaint);
        }
        this.mCanvas.drawBitmap(this.mPointerBitmap, 0.0f, 0.0f, this.mPointerPaint);
        float iconMarginTitleHeight = this.mIconSize + this.mTitleMargin + this.mModelTitleSize;
        for (int i = 0; i < this.mModels.size(); ++i) {
            float topOffset;
            float leftOffset;
            Model model = this.mModels.get(i);
            float leftTitleOffset = this.mModelSize * (float)i + this.mModelSize * 0.5f;
            float topTitleOffset = this.mBounds.height() - (this.mBounds.height() - iconMarginTitleHeight) * 0.5f;
            if (this.mIsHorizontalOrientation) {
                leftOffset = this.mModelSize * (float)i + (this.mModelSize - (float)model.mIcon.getWidth()) * 0.5f;
                topOffset = (this.mBounds.height() - (float)model.mIcon.getHeight()) * 0.5f;
            } else {
                leftOffset = (this.mBounds.width() - (float)model.mIcon.getWidth()) * 0.5f;
                topOffset = this.mModelSize * (float)i + (this.mModelSize - (float)model.mIcon.getHeight()) * 0.5f;
            }
            float matrixCenterX = leftOffset + (float)model.mIcon.getWidth() * 0.5f;
            float matrixCenterY = topOffset + (float)model.mIcon.getHeight() * 0.5f;
            float titleTranslate = topOffset - (float)model.mIcon.getHeight() * 0.25f;
            model.mIconMatrix.setTranslate(leftOffset, this.mIsTitled && this.mTitleMode == TitleMode.ALL ? titleTranslate : topOffset);
            float interpolation = this.mResizeInterpolator.getResizeInterpolation(this.mFraction, true);
            float lastInterpolation = this.mResizeInterpolator.getResizeInterpolation(this.mFraction, false);
            float matrixScale = model.mActiveIconScaleBy * interpolation;
            float matrixLastScale = model.mActiveIconScaleBy * lastInterpolation;
            int titleAlpha = (int)(255.0f * interpolation);
            int titleLastAlpha = 255 - (int)(255.0f * lastInterpolation);
            float titleScale = this.mIsScaled ? 1.0f + interpolation * 0.2f : 1.0f;
            float titleLastScale = this.mIsScaled ? 1.2f - lastInterpolation * 0.2f : titleScale;
            this.mIconPaint.setAlpha(255);
            if (model.mSelectedIcon != null) {
                this.mSelectedIconPaint.setAlpha(255);
            }
            if (this.mIsSetIndexFromTabBar) {
                if (this.mIndex == i) {
                    this.updateCurrentModel(model, leftOffset, topOffset, titleTranslate, interpolation, matrixCenterX, matrixCenterY, matrixScale, titleScale, titleAlpha);
                } else if (this.mLastIndex == i) {
                    this.updateLastModel(model, leftOffset, topOffset, titleTranslate, lastInterpolation, matrixCenterX, matrixCenterY, matrixLastScale, titleLastScale, titleLastAlpha);
                } else {
                    this.updateInactiveModel(model, leftOffset, topOffset, titleScale, matrixScale, matrixCenterX, matrixCenterY);
                }
            } else if (i == this.mIndex + 1) {
                this.updateCurrentModel(model, leftOffset, topOffset, titleTranslate, interpolation, matrixCenterX, matrixCenterY, matrixScale, titleScale, titleAlpha);
            } else if (i == this.mIndex) {
                this.updateLastModel(model, leftOffset, topOffset, titleTranslate, lastInterpolation, matrixCenterX, matrixCenterY, matrixLastScale, titleLastScale, titleLastAlpha);
            } else {
                this.updateInactiveModel(model, leftOffset, topOffset, titleScale, matrixScale, matrixCenterX, matrixCenterY);
            }
            if (model.mSelectedIcon == null) {
                if (model.mIcon != null && !model.mIcon.isRecycled()) {
                    this.mIconsCanvas.drawBitmap(model.mIcon, model.mIconMatrix, this.mIconPaint);
                }
            } else if (this.mIconPaint.getAlpha() != 0 && model.mIcon != null && !model.mIcon.isRecycled()) {
                this.mIconsCanvas.drawBitmap(model.mIcon, model.mIconMatrix, this.mIconPaint);
            }
            if (this.mSelectedIconPaint.getAlpha() != 0 && model.mSelectedIcon != null && !model.mSelectedIcon.isRecycled()) {
                this.mIconsCanvas.drawBitmap(model.mSelectedIcon, model.mIconMatrix, this.mSelectedIconPaint);
            }
            if (!this.mIsTitled) continue;
            this.mTitlesCanvas.drawText(this.isInEditMode() ? PREVIEW_TITLE : model.getTitle(), leftTitleOffset, topTitleOffset, this.mModelTitlePaint);
        }
        if (this.mIsHorizontalOrientation) {
            this.mPointerBounds.set(this.mPointerLeftTop, 0.0f, this.mPointerRightBottom, this.mBounds.height());
        }
        if (this.mCornersRadius == 0.0f) {
            if (this.mIsTinted) {
                this.mIconsCanvas.drawRect(this.mPointerBounds, this.mIconPointerPaint);
            }
            if (this.mIsTitled) {
                this.mTitlesCanvas.drawRect(this.mPointerBounds, this.mIconPointerPaint);
            }
        } else {
            if (this.mIsTinted) {
                this.mIconsCanvas.drawRoundRect(this.mPointerBounds, this.mCornersRadius, this.mCornersRadius, this.mIconPointerPaint);
            }
            if (this.mIsTitled) {
                this.mTitlesCanvas.drawRoundRect(this.mPointerBounds, this.mCornersRadius, this.mCornersRadius, this.mIconPointerPaint);
            }
        }
        canvas.drawBitmap(this.mBitmap, 0.0f, 0.0f, null);
        canvas.drawBitmap(this.mIconsBitmap, 0.0f, barBadgeMargin, null);
        if (this.mIsTitled) {
            canvas.drawBitmap(this.mTitlesBitmap, 0.0f, barBadgeMargin, null);
        }
        if (!this.mIsBadged) {
            return;
        }
        float modelBadgeMargin = this.mBadgeGravity == BadgeGravity.TOP ? this.mBadgeMargin : this.mBounds.height();
        float modelBadgeOffset = this.mBadgeGravity == BadgeGravity.TOP ? 0.0f : this.mBounds.height() - this.mBadgeMargin;
        for (int i = 0; i < this.mModels.size(); ++i) {
            Model model = this.mModels.get(i);
            if (this.isInEditMode() || TextUtils.isEmpty((CharSequence)model.getBadgeTitle())) {
                model.setBadgeTitle(PREVIEW_BADGE);
            }
            this.mBadgePaint.setTextSize(this.mBadgeTitleSize * model.mBadgeFraction);
            this.mBadgePaint.getTextBounds(model.getBadgeTitle(), 0, model.getBadgeTitle().length(), this.mBadgeBounds);
            float horizontalPadding = this.mBadgeTitleSize * 0.5f;
            float verticalPadding = horizontalPadding * 0.75f;
            float badgeBoundsHorizontalOffset = this.mModelSize * (float)i + this.mModelSize * this.mBadgePosition.mPositionFraction;
            float badgeMargin = this.mBadgeMargin * model.mBadgeFraction;
            if (model.getBadgeTitle().length() == 1) {
                this.mBgBadgeBounds.set(badgeBoundsHorizontalOffset - badgeMargin, modelBadgeMargin - badgeMargin, badgeBoundsHorizontalOffset + badgeMargin, modelBadgeMargin + badgeMargin);
            } else {
                this.mBgBadgeBounds.set(badgeBoundsHorizontalOffset - Math.max(badgeMargin, (float)this.mBadgeBounds.centerX() + horizontalPadding), modelBadgeMargin - badgeMargin, badgeBoundsHorizontalOffset + Math.max(badgeMargin, (float)this.mBadgeBounds.centerX() + horizontalPadding), modelBadgeOffset + verticalPadding * 2.0f + (float)this.mBadgeBounds.height());
            }
            if (model.mBadgeFraction == 0.0f) {
                this.mBadgePaint.setColor(0);
            } else {
                this.mBadgePaint.setColor(this.mBadgeBgColor == -3 ? this.mActiveColor : this.mBadgeBgColor);
            }
            this.mBadgePaint.setAlpha((int)(255.0f * model.mBadgeFraction));
            float cornerRadius = this.mBgBadgeBounds.height() * 0.5f;
            canvas.drawRoundRect(this.mBgBadgeBounds, cornerRadius, cornerRadius, this.mBadgePaint);
            if (model.mBadgeFraction == 0.0f) {
                this.mBadgePaint.setColor(0);
            } else {
                this.mBadgePaint.setColor(this.mBadgeTitleColor == -3 ? model.getColor() : this.mBadgeTitleColor);
            }
            this.mBadgePaint.setAlpha((int)(255.0f * model.mBadgeFraction));
            float badgeHalfHeight = (float)this.mBadgeBounds.height() * 0.5f;
            float badgeVerticalOffset = this.mBgBadgeBounds.height() * 0.5f + badgeHalfHeight - (float)this.mBadgeBounds.bottom + modelBadgeOffset;
            canvas.drawText(model.getBadgeTitle(), badgeBoundsHorizontalOffset, badgeVerticalOffset + (float)this.mBadgeBounds.height() - (float)this.mBadgeBounds.height() * model.mBadgeFraction, this.mBadgePaint);
        }
    }

    protected void updateCurrentModel(Model model, float leftOffset, float topOffset, float titleTranslate, float interpolation, float matrixCenterX, float matrixCenterY, float matrixScale, float titleScale, int titleAlpha) {
        float selectedIconAlpha;
        float iconAlpha;
        if (this.mIsTitled && this.mTitleMode == TitleMode.ACTIVE) {
            model.mIconMatrix.setTranslate(leftOffset, topOffset - interpolation * (topOffset - titleTranslate));
        }
        float scale = model.mInactiveIconScale + (this.mIsScaled ? matrixScale : 0.0f);
        model.mIconMatrix.postScale(scale, scale, matrixCenterX, matrixCenterY);
        this.mModelTitlePaint.setTextSize(this.mModelTitleSize * titleScale);
        if (this.mTitleMode == TitleMode.ACTIVE) {
            this.mModelTitlePaint.setAlpha(titleAlpha);
        }
        if (model.mSelectedIcon == null) {
            this.mIconPaint.setAlpha(255);
            return;
        }
        if (interpolation <= 0.475f) {
            iconAlpha = 1.0f - interpolation * 2.1f;
            selectedIconAlpha = 0.0f;
        } else if (interpolation >= 0.525f) {
            iconAlpha = 0.0f;
            selectedIconAlpha = (interpolation - 0.55f) * 1.9f;
        } else {
            iconAlpha = 0.0f;
            selectedIconAlpha = 0.0f;
        }
        this.mIconPaint.setAlpha((int)(255.0f * this.clampValue(iconAlpha)));
        this.mSelectedIconPaint.setAlpha((int)(255.0f * this.clampValue(selectedIconAlpha)));
    }

    protected void updateLastModel(Model model, float leftOffset, float topOffset, float titleTranslate, float lastInterpolation, float matrixCenterX, float matrixCenterY, float matrixLastScale, float titleLastScale, int titleLastAlpha) {
        float selectedIconAlpha;
        float iconAlpha;
        if (this.mIsTitled && this.mTitleMode == TitleMode.ACTIVE) {
            model.mIconMatrix.setTranslate(leftOffset, titleTranslate + lastInterpolation * (topOffset - titleTranslate));
        }
        float scale = model.mInactiveIconScale + (this.mIsScaled ? model.mActiveIconScaleBy - matrixLastScale : 0.0f);
        model.mIconMatrix.postScale(scale, scale, matrixCenterX, matrixCenterY);
        this.mModelTitlePaint.setTextSize(this.mModelTitleSize * titleLastScale);
        if (this.mTitleMode == TitleMode.ACTIVE) {
            this.mModelTitlePaint.setAlpha(titleLastAlpha);
        }
        if (model.mSelectedIcon == null) {
            this.mIconPaint.setAlpha(255);
            return;
        }
        if (lastInterpolation <= 0.475f) {
            iconAlpha = 0.0f;
            selectedIconAlpha = 1.0f - lastInterpolation * 2.1f;
        } else if (lastInterpolation >= 0.525f) {
            iconAlpha = (lastInterpolation - 0.55f) * 1.9f;
            selectedIconAlpha = 0.0f;
        } else {
            iconAlpha = 0.0f;
            selectedIconAlpha = 0.0f;
        }
        this.mIconPaint.setAlpha((int)(255.0f * this.clampValue(iconAlpha)));
        this.mSelectedIconPaint.setAlpha((int)(255.0f * this.clampValue(selectedIconAlpha)));
    }

    protected void updateInactiveModel(Model model, float leftOffset, float topOffset, float textScale, float matrixScale, float matrixCenterX, float matrixCenterY) {
        if (this.mIsTitled && this.mTitleMode == TitleMode.ACTIVE) {
            model.mIconMatrix.setTranslate(leftOffset, topOffset);
        }
        model.mIconMatrix.postScale(model.mInactiveIconScale, model.mInactiveIconScale, matrixCenterX, matrixCenterY);
        this.mModelTitlePaint.setTextSize(this.mModelTitleSize);
        if (this.mTitleMode == TitleMode.ACTIVE) {
            this.mModelTitlePaint.setAlpha(0);
        }
        if (model.mSelectedIcon == null) {
            this.mIconPaint.setAlpha(255);
            return;
        }
        this.mSelectedIconPaint.setAlpha(0);
    }

    protected void updateTint() {
        if (this.mIsTinted) {
            PorterDuffColorFilter colorFilter = new PorterDuffColorFilter(this.mInactiveColor, PorterDuff.Mode.SRC_IN);
            this.mIconPaint.setColorFilter((ColorFilter)colorFilter);
            this.mSelectedIconPaint.setColorFilter((ColorFilter)colorFilter);
        } else {
            this.mIconPaint.reset();
            this.mSelectedIconPaint.reset();
        }
        this.postInvalidate();
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
        }
        if (!this.mIsSetIndexFromTabBar) {
            this.mIsResizeIn = position < this.mIndex;
            this.mLastIndex = this.mIndex;
            this.mIndex = position;
            this.mStartPointerX = (float)position * this.mModelSize;
            this.mEndPointerX = this.mStartPointerX + this.mModelSize;
            this.updateIndicatorPosition(positionOffset);
        }
        if (!this.mAnimator.isRunning() && this.mIsSetIndexFromTabBar) {
            this.mFraction = 0.0f;
            this.mIsSetIndexFromTabBar = false;
        }
    }

    public void onPageSelected(int position) {
    }

    public void onPageScrollStateChanged(int state) {
        this.mScrollState = state;
        if (state == 0) {
            if (this.mOnPageChangeListener != null) {
                this.mOnPageChangeListener.onPageSelected(this.mIndex);
            }
            if (this.mIsViewPagerMode && this.mOnTabBarSelectedIndexListener != null) {
                this.mOnTabBarSelectedIndexListener.onEndTabSelected(this.mModels.get(this.mIndex), this.mIndex);
            }
        }
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageScrollStateChanged(state);
        }
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mIndex = savedState.index;
        this.requestLayout();
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.index = this.mIndex;
        return savedState;
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.requestLayout();
        final int tempIndex = this.mIndex;
        this.deselect();
        this.post(new Runnable(){

            @Override
            public void run() {
                NavigationTabBar.this.setModelIndex(tempIndex, true);
            }
        });
    }

    protected float clampValue(float value) {
        return Math.max(Math.min(value, 1.0f), 0.0f);
    }

    public void hide() {
        if (this.mBehavior != null) {
            this.mBehavior.hideView(this, (int)this.getBarHeight(), true);
        } else if (this.getParent() != null && this.getParent() instanceof CoordinatorLayout) {
            this.mNeedHide = true;
            this.mAnimateHide = true;
        } else {
            this.scrollDown();
        }
    }

    public void show() {
        if (this.mBehavior != null) {
            this.mBehavior.resetOffset(this, true);
        } else {
            this.scrollUp();
        }
    }

    protected void scrollDown() {
        ViewCompat.animate((View)this).translationY(this.getBarHeight()).setInterpolator((Interpolator)new LinearOutSlowInInterpolator()).setDuration(300L).start();
    }

    protected void scrollUp() {
        ViewCompat.animate((View)this).translationY(0.0f).setInterpolator(OUT_SLOW_IN_INTERPOLATOR).setDuration(300L).start();
    }

    public static interface OnTabBarSelectedIndexListener {
        public void onStartTabSelected(Model var1, int var2);

        public void onEndTabSelected(Model var1, int var2);
    }

    public static enum BadgeGravity {
        TOP,
        BOTTOM;

        public static final int TOP_INDEX = 0;
        public static final int BOTTOM_INDEX = 1;
    }

    public static enum BadgePosition {
        LEFT(0.25f),
        CENTER(0.5f),
        RIGHT(0.75f);

        public static final int LEFT_INDEX = 0;
        public static final int CENTER_INDEX = 1;
        public static final int RIGHT_INDEX = 2;
        private final float mPositionFraction;

        private BadgePosition(float positionFraction) {
            this.mPositionFraction = positionFraction;
        }
    }

    public static enum TitleMode {
        ALL,
        ACTIVE;

        public static final int ALL_INDEX = 0;
        public static final int ACTIVE_INDEX = 1;
    }

    protected class ResizeInterpolator
    implements Interpolator {
        private static final float FACTOR = 1.0f;
        private boolean mResizeIn;

        protected ResizeInterpolator() {
        }

        public float getInterpolation(float input) {
            if (this.mResizeIn) {
                return (float)(1.0 - Math.pow(1.0f - input, 2.0));
            }
            return (float)Math.pow(input, 2.0);
        }

        private float getResizeInterpolation(float input, boolean resizeIn) {
            this.mResizeIn = resizeIn;
            return this.getInterpolation(input);
        }
    }

    protected class ResizeViewPagerScroller
    extends Scroller {
        ResizeViewPagerScroller(Context context) {
            super(context, (Interpolator)new AccelerateDecelerateInterpolator());
        }

        public void startScroll(int startX, int startY, int dx, int dy, int duration) {
            super.startScroll(startX, startY, dx, dy, NavigationTabBar.this.mAnimationDuration);
        }

        public void startScroll(int startX, int startY, int dx, int dy) {
            super.startScroll(startX, startY, dx, dy, NavigationTabBar.this.mAnimationDuration);
        }
    }

    public static class Model {
        private int mColor;
        private final Bitmap mIcon;
        private final Bitmap mSelectedIcon;
        private final Matrix mIconMatrix = new Matrix();
        private String mTitle = "";
        private String mBadgeTitle = "";
        private String mTempBadgeTitle = "";
        private float mBadgeFraction;
        private boolean mIsBadgeShowed;
        private boolean mIsBadgeUpdated;
        private final ValueAnimator mBadgeAnimator = new ValueAnimator();
        private float mInactiveIconScale;
        private float mActiveIconScaleBy;

        Model(Builder builder) {
            this.mColor = builder.mColor;
            this.mIcon = builder.mIcon;
            this.mSelectedIcon = builder.mSelectedIcon;
            this.mTitle = builder.mTitle;
            this.mBadgeTitle = builder.mBadgeTitle;
            this.mBadgeAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    animation.removeListener((Animator.AnimatorListener)this);
                    animation.addListener((Animator.AnimatorListener)this);
                }

                public void onAnimationEnd(Animator animation) {
                    animation.removeListener((Animator.AnimatorListener)this);
                    animation.addListener((Animator.AnimatorListener)this);
                    if (!Model.this.mIsBadgeUpdated) {
                        Model.this.mIsBadgeShowed = !Model.this.mIsBadgeShowed;
                    } else {
                        Model.this.mIsBadgeUpdated = false;
                    }
                }

                public void onAnimationRepeat(Animator animation) {
                    if (Model.this.mIsBadgeUpdated) {
                        Model.this.mBadgeTitle = Model.this.mTempBadgeTitle;
                    }
                }
            });
        }

        public String getTitle() {
            return this.mTitle;
        }

        public void setTitle(String title) {
            this.mTitle = title;
        }

        public int getColor() {
            return this.mColor;
        }

        public void setColor(int color) {
            this.mColor = color;
        }

        public boolean isBadgeShowed() {
            return this.mIsBadgeShowed;
        }

        public String getBadgeTitle() {
            return this.mBadgeTitle;
        }

        public void setBadgeTitle(String badgeTitle) {
            this.mBadgeTitle = badgeTitle;
        }

        public void updateBadgeTitle(String badgeTitle) {
            if (!this.mIsBadgeShowed) {
                return;
            }
            if (this.mBadgeAnimator.isRunning()) {
                this.mBadgeAnimator.end();
            }
            this.mTempBadgeTitle = badgeTitle;
            this.mIsBadgeUpdated = true;
            this.mBadgeAnimator.setFloatValues(new float[]{1.0f, 0.0f});
            this.mBadgeAnimator.setDuration(100L);
            this.mBadgeAnimator.setRepeatMode(2);
            this.mBadgeAnimator.setRepeatCount(1);
            this.mBadgeAnimator.start();
        }

        public void toggleBadge() {
            if (this.mBadgeAnimator.isRunning()) {
                this.mBadgeAnimator.end();
            }
            if (this.mIsBadgeShowed) {
                this.hideBadge();
            } else {
                this.showBadge();
            }
        }

        public void showBadge() {
            this.mIsBadgeUpdated = false;
            if (this.mBadgeAnimator.isRunning()) {
                this.mBadgeAnimator.end();
            }
            if (this.mIsBadgeShowed) {
                return;
            }
            this.mBadgeAnimator.setFloatValues(new float[]{0.0f, 1.0f});
            this.mBadgeAnimator.setInterpolator((TimeInterpolator)DECELERATE_INTERPOLATOR);
            this.mBadgeAnimator.setDuration(200L);
            this.mBadgeAnimator.setRepeatMode(1);
            this.mBadgeAnimator.setRepeatCount(0);
            this.mBadgeAnimator.start();
        }

        public void hideBadge() {
            this.mIsBadgeUpdated = false;
            if (this.mBadgeAnimator.isRunning()) {
                this.mBadgeAnimator.end();
            }
            if (!this.mIsBadgeShowed) {
                return;
            }
            this.mBadgeAnimator.setFloatValues(new float[]{1.0f, 0.0f});
            this.mBadgeAnimator.setInterpolator((TimeInterpolator)ACCELERATE_INTERPOLATOR);
            this.mBadgeAnimator.setDuration(200L);
            this.mBadgeAnimator.setRepeatMode(1);
            this.mBadgeAnimator.setRepeatCount(0);
            this.mBadgeAnimator.start();
        }

        public static class Builder {
            private final int mColor;
            private final Bitmap mIcon;
            private Bitmap mSelectedIcon;
            private String mTitle;
            private String mBadgeTitle;

            public Builder(Drawable icon, int color) {
                this.mColor = color;
                if (icon != null) {
                    if (icon instanceof BitmapDrawable) {
                        this.mIcon = ((BitmapDrawable)icon).getBitmap();
                    } else {
                        this.mIcon = Bitmap.createBitmap((int)icon.getIntrinsicWidth(), (int)icon.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                        Canvas canvas = new Canvas(this.mIcon);
                        icon.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
                        icon.draw(canvas);
                    }
                } else {
                    this.mIcon = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.RGB_565);
                }
            }

            public Builder selectedIcon(Drawable selectedIcon) {
                if (selectedIcon != null) {
                    if (selectedIcon instanceof BitmapDrawable) {
                        this.mSelectedIcon = ((BitmapDrawable)selectedIcon).getBitmap();
                    } else {
                        this.mSelectedIcon = Bitmap.createBitmap((int)selectedIcon.getIntrinsicWidth(), (int)selectedIcon.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                        Canvas canvas = new Canvas(this.mSelectedIcon);
                        selectedIcon.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
                        selectedIcon.draw(canvas);
                    }
                } else {
                    this.mSelectedIcon = null;
                }
                return this;
            }

            public Builder title(String title) {
                this.mTitle = title;
                return this;
            }

            public Builder badgeTitle(String title) {
                this.mBadgeTitle = title;
                return this;
            }

            public Model build() {
                return new Model(this);
            }
        }
    }

    protected static class SavedState
    extends View.BaseSavedState {
        private int index;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.index = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.index);
        }
    }
}

