/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import java.util.logging.Logger;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.runtime.ModuleSerializationProxy;
import zio.internal.Signal;
import zio.internal.Signal$SignalHandler$;

public final class Signal$
implements Serializable {
    private static final Signal.SignalHandler signalHandler;
    private static final Signal$SignalHandler$ SignalHandler;
    public static final Signal$ MODULE$;

    private Signal$() {
    }

    static {
        Signal.SignalHandler signalHandler;
        MODULE$ = new Signal$();
        Logger logger = Logger.getLogger("zio.internal.Signal");
        Class<?> signalClass = MODULE$.findClass("sun.misc.Signal");
        Class<?> signalHandlerClass = MODULE$.findClass("sun.misc.SignalHandler");
        MethodHandle constructorHandle = null;
        MethodHandle staticMethodHandle = null;
        if (signalClass != null && signalHandlerClass != null) {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            constructorHandle = MODULE$.initSignalConstructorMethodHandle(lookup, signalClass);
            staticMethodHandle = MODULE$.initHandleStaticMethodHandle(lookup, signalClass, signalHandlerClass);
        } else {
            constructorHandle = null;
            staticMethodHandle = null;
        }
        if (signalHandlerClass != null && constructorHandle != null && staticMethodHandle != null) {
            signalHandler = new Signal.SignalHandler.SunMiscSignalHandler(signalHandlerClass, constructorHandle, staticMethodHandle);
        } else {
            logger.warning("sun.misc.Signal and sun.misc.SignalHandler are not available on this platform. Defaulting to no-op signal handling implementation; ZIO fiber dump functionality might not work as expected.");
            signalHandler = new Signal.SignalHandler.NoOpSignalHandler();
        }
        Signal$.signalHandler = signalHandler;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Signal$.class);
    }

    public void handle(String signal, Consumer<Object> handler) {
        signalHandler.handle(signal, handler);
    }

    private Class<?> findClass(String name) {
        Class<?> clazz;
        try {
            clazz = Class.forName(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = null;
        }
        return clazz;
    }

    private MethodHandle initSignalConstructorMethodHandle(MethodHandles.Lookup lookup, Class<?> signalClass) {
        MethodHandle methodHandle;
        MethodType signalConstructorMethodType = MethodType.methodType(Void.TYPE, String.class);
        try {
            methodHandle = lookup.findConstructor(signalClass, signalConstructorMethodType);
        }
        catch (Exception exception) {
            methodHandle = null;
        }
        return methodHandle;
    }

    private MethodHandle initHandleStaticMethodHandle(MethodHandles.Lookup lookup, Class<?> signalClass, Class<?> signalHandlerClass) {
        MethodHandle methodHandle;
        try {
            MethodType handleStaticMethodType = MethodType.methodType(signalHandlerClass, signalClass, signalHandlerClass);
            methodHandle = lookup.findStatic(signalClass, "handle", handleStaticMethodType);
        }
        catch (Exception exception) {
            methodHandle = null;
        }
        return methodHandle;
    }

    public static final /* synthetic */ Object zio$internal$Signal$SignalHandler$SunMiscSignalHandler$$_$initInvocationHandler$$anonfun$1(Consumer handler$1, Object proxy, Method method, Object[] args) {
        Object object = Predef$.MODULE$.refArrayOps(args);
        if (ArrayOps$.MODULE$.nonEmpty$extension(object)) {
            handler$1.accept(args[0]);
        }
        return null;
    }
}

